/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.persist.model.Persistent;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.ComplexValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.NumberUtils;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.StringValueImpl;
import oracle.kv.impl.api.table.TimestampDefImpl;
import oracle.kv.impl.api.table.TupleValue;
import oracle.kv.impl.util.JsonUtils;
import oracle.kv.table.ArrayValue;
import oracle.kv.table.BinaryValue;
import oracle.kv.table.BooleanValue;
import oracle.kv.table.DoubleValue;
import oracle.kv.table.EnumValue;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.FixedBinaryValue;
import oracle.kv.table.FloatValue;
import oracle.kv.table.IndexKey;
import oracle.kv.table.IntegerValue;
import oracle.kv.table.LongValue;
import oracle.kv.table.MapValue;
import oracle.kv.table.NumberValue;
import oracle.kv.table.PrimaryKey;
import oracle.kv.table.RecordValue;
import oracle.kv.table.Row;
import oracle.kv.table.StringValue;
import oracle.kv.table.TimestampValue;
import org.apache.avro.Schema;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectWriter;

@Persistent(version=1)
public abstract class FieldValueImpl
implements FieldValue,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;

    @Override
    public FieldValueImpl clone() {
        try {
            return (FieldValueImpl)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public int compareTo(FieldValue o) {
        throw new IllegalArgumentException("FieldValueImpl objects must implement compareTo");
    }

    @Override
    public abstract FieldDefImpl getDefinition();

    @Override
    public BinaryValue asBinary() {
        throw new ClassCastException("Field is not a Binary: " + this.getClass());
    }

    @Override
    public NumberValue asNumber() {
        throw new ClassCastException("Field is not a Number: " + this.getClass());
    }

    @Override
    public BooleanValue asBoolean() {
        throw new ClassCastException("Field is not a Boolean: " + this.getClass());
    }

    @Override
    public DoubleValue asDouble() {
        throw new ClassCastException("Field is not a Double: " + this.getClass());
    }

    @Override
    public FloatValue asFloat() {
        throw new ClassCastException("Field is not a Float: " + this.getClass());
    }

    @Override
    public IntegerValue asInteger() {
        throw new ClassCastException("Field is not an Integer: " + this.getClass());
    }

    @Override
    public LongValue asLong() {
        throw new ClassCastException("Field is not a Long: " + this.getClass());
    }

    @Override
    public StringValue asString() {
        throw new ClassCastException("Field is not a String: " + this.getClass());
    }

    @Override
    public TimestampValue asTimestamp() {
        throw new ClassCastException("Field is not a Timestamp: " + this.getClass());
    }

    @Override
    public EnumValue asEnum() {
        throw new ClassCastException("Field is not an Enum: " + this.getClass());
    }

    @Override
    public FixedBinaryValue asFixedBinary() {
        throw new ClassCastException("Field is not a FixedBinary: " + this.getClass());
    }

    @Override
    public ArrayValue asArray() {
        throw new ClassCastException("Field is not an Array: " + this.getClass());
    }

    @Override
    public MapValue asMap() {
        throw new ClassCastException("Field is not a Map: " + this.getClass());
    }

    @Override
    public RecordValue asRecord() {
        throw new ClassCastException("Field is not a Record: " + this.getClass());
    }

    @Override
    public Row asRow() {
        throw new ClassCastException("Field is not a Row: " + this.getClass());
    }

    @Override
    public PrimaryKey asPrimaryKey() {
        throw new ClassCastException("Field is not a PrimaryKey: " + this.getClass());
    }

    @Override
    public IndexKey asIndexKey() {
        throw new ClassCastException("Field is not an IndexKey: " + this.getClass());
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isDouble() {
        return false;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public boolean isFixedBinary() {
        return false;
    }

    @Override
    public boolean isLong() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isTimestamp() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public boolean isRecord() {
        return false;
    }

    @Override
    public boolean isRow() {
        return false;
    }

    @Override
    public boolean isPrimaryKey() {
        return false;
    }

    @Override
    public boolean isIndexKey() {
        return false;
    }

    @Override
    public boolean isJsonNull() {
        return false;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean isAtomic() {
        return false;
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    public String toJsonString(boolean pretty) {
        if (pretty) {
            ObjectWriter writer = JsonUtils.createWriter(pretty);
            try {
                return writer.writeValueAsString(this.toJsonNode());
            }
            catch (IOException ioe) {
                return ioe.toString();
            }
        }
        StringBuilder sb = new StringBuilder(128);
        this.toStringBuilder(sb);
        return sb.toString();
    }

    public boolean isTuple() {
        return false;
    }

    public int size() {
        throw new ClassCastException("Value is not complex (array, map, or record): " + this.getClass());
    }

    public Map<String, FieldValue> getMap() {
        throw new ClassCastException("Value is not a record or map: " + this.getClass());
    }

    public int getInt() {
        throw new ClassCastException("Value is not an integer or subtype: " + this.getClass());
    }

    public void setInt(int v) {
        throw new ClassCastException("Value is not an integer or subtype: " + this.getClass());
    }

    public long getLong() {
        throw new ClassCastException("Value is not a long or subtype: " + this.getClass());
    }

    public void setLong(long v) {
        throw new ClassCastException("Value is not a long or subtype: " + this.getClass());
    }

    public float getFloat() {
        throw new ClassCastException("Value is not a float or subtype: " + this.getClass());
    }

    public void setFloat(float v) {
        throw new ClassCastException("Value is not a float or subtype: " + this.getClass());
    }

    public void setDecimal(BigDecimal v) {
        throw new ClassCastException("Value is not a Number or subtype: " + this.getClass());
    }

    public BigDecimal getDecimal() {
        throw new ClassCastException("Value is not a double or subtype: " + this.getClass());
    }

    public double getDouble() {
        throw new ClassCastException("Value is not a double or subtype: " + this.getClass());
    }

    public void setDouble(double v) {
        throw new ClassCastException("Value is not a double or subtype: " + this.getClass());
    }

    public String getString() {
        throw new ClassCastException("Value is not a string or subtype: " + this.getClass());
    }

    public void setString(String v) {
        throw new ClassCastException("Value is not a String or subtype: " + this.getClass());
    }

    public String getEnumString() {
        throw new ClassCastException("Value is not an enum or subtype: " + this.getClass());
    }

    public void setEnum(String v) {
        throw new ClassCastException("Value is not an enum or subtype: " + this.getClass());
    }

    public boolean getBoolean() {
        throw new ClassCastException("Value is not a boolean: " + this.getClass());
    }

    public void setBoolean(boolean v) {
        throw new ClassCastException("Value is not a boolean or subtype: " + this.getClass());
    }

    public byte[] getBytes() {
        throw new ClassCastException("Value is not a binary: " + this.getClass());
    }

    public void setTimestamp(Timestamp timestamp) {
        throw new ClassCastException("Value is not a timetamp: " + this.getClass());
    }

    public Timestamp getTimestamp() {
        throw new ClassCastException("Value is not a timetamp: " + this.getClass());
    }

    public FieldValueImpl getElement(int index) {
        if (this.isArray()) {
            return ((ArrayValueImpl)this).get(index);
        }
        if (this.isRecord()) {
            return ((RecordValueImpl)this).get(index);
        }
        if (this.isTuple()) {
            return ((TupleValue)this).get(index);
        }
        throw new ClassCastException("Value is not an array or record: " + this.getClass());
    }

    public FieldValueImpl getElement(String fieldName) {
        if (this.isMap()) {
            return ((MapValueImpl)this).get(fieldName);
        }
        if (this.isRecord()) {
            return ((RecordValueImpl)this).get(fieldName);
        }
        if (this.isTuple()) {
            return ((TupleValue)this).get(fieldName);
        }
        throw new ClassCastException("Value is not a map or a record: " + this.getClass());
    }

    public FieldValueImpl getFieldValue(String fieldName) {
        if (this.isMap()) {
            return ((MapValueImpl)this).get(fieldName);
        }
        if (this.isRecord()) {
            return ((RecordValueImpl)this).get(fieldName);
        }
        if (this.isTuple()) {
            return ((TupleValue)this).get(fieldName);
        }
        throw new ClassCastException("Value is not a map or a record: " + this.getClass());
    }

    FieldValueImpl getNextValue() {
        throw new IllegalArgumentException("Type does not implement getNextValue: " + this.getClass().getName());
    }

    FieldValueImpl getMinimumValue() {
        throw new IllegalArgumentException("Type does not implement getMinimumValue: " + this.getClass().getName());
    }

    public abstract JsonNode toJsonNode();

    public abstract void toStringBuilder(StringBuilder var1);

    static FieldValue fromJavaObjectValue(FieldDef def, Object o) {
        switch (def.getType()) {
            case INTEGER: {
                return def.createInteger((Integer)o);
            }
            case LONG: {
                return def.createLong((Long)o);
            }
            case DOUBLE: {
                return def.createDouble((Double)o);
            }
            case FLOAT: {
                return def.createFloat(((Float)o).floatValue());
            }
            case NUMBER: {
                return def.createNumber((BigDecimal)o);
            }
            case STRING: {
                return def.createString((String)o);
            }
            case BINARY: {
                return def.createBinary((byte[])o);
            }
            case FIXED_BINARY: {
                return def.createFixedBinary((byte[])o);
            }
            case BOOLEAN: {
                return def.createBoolean((Boolean)o);
            }
            case ENUM: {
                return def.createEnum((String)o);
            }
            case TIMESTAMP: {
                return def.createTimestamp((Timestamp)o);
            }
            case RECORD: {
                return RecordValueImpl.fromJavaObjectValue(def, o);
            }
            case ARRAY: {
                return ArrayValueImpl.fromJavaObjectValue(def, o);
            }
            case MAP: {
                return MapValueImpl.fromJavaObjectValue(def, o);
            }
        }
        throw new IllegalArgumentException("Complex classes must override fromJavaObjectValue");
    }

    public String formatForKey(FieldDef field, int storageSize) {
        throw new IllegalArgumentException("Key components must be atomic types");
    }

    String formatForKey(FieldDef field) {
        return this.formatForKey(field, 0);
    }

    FieldValue putComplex(ListIterator<String> fieldPath, FieldValue value) {
        FieldDef.Type type = value.isNull() ? null : value.getType();
        switch (this.getType()) {
            case RECORD: {
                if (this.isTuple()) {
                    throw new IllegalStateException("Cannot add fields to a TupleValue");
                }
                RecordValueImpl rec = (RecordValueImpl)this;
                String fname = fieldPath.next();
                int pos = rec.getFieldPos(fname);
                if (!fieldPath.hasNext()) {
                    rec.putInternal(pos, value);
                } else {
                    FieldDefImpl def = rec.getFieldDef(pos);
                    FieldValueImpl val = rec.get(pos);
                    if (val == null) {
                        val = FieldValueImpl.createComplexValue(def);
                    }
                    rec.putInternal(pos, val.putComplex(fieldPath, value));
                }
                return this;
            }
            case ARRAY: {
                ArrayValueImpl arr = (ArrayValueImpl)this;
                FieldDefImpl elemDef = arr.getElementDef();
                if (arr.size() > 1) {
                    throw new IllegalArgumentException("Array encountered during construction/update of IndexKey must have at most one element. Array value : \n" + this);
                }
                String fname = fieldPath.next();
                if (!fname.equals("[]")) {
                    throw new IllegalStateException("Unexpected step in index path over array : " + fname);
                }
                if (!fieldPath.hasNext()) {
                    if (!value.isNull()) {
                        if (arr.size() == 0) {
                            arr.add(value);
                        } else {
                            arr.set(0, value);
                        }
                    }
                    return this;
                }
                ComplexValueImpl val = null;
                if (arr.size() == 0) {
                    val = FieldValueImpl.createComplexValue(elemDef);
                    arr.add(val);
                } else {
                    if (!(arr.get(0) instanceof ComplexValueImpl)) {
                        throw new IllegalArgumentException("Invalid attempt to overwrite an atomic element with a complex element in an array encountered during construction/update of IndexKey. Array value : \n" + this);
                    }
                    val = (ComplexValueImpl)arr.get(0);
                }
                val.putComplex(fieldPath, value);
                return this;
            }
            case MAP: {
                Set<String> mapKeys;
                Iterator<String> iterator;
                MapValueImpl map = (MapValueImpl)this;
                FieldDefImpl elemDef = map.getElementDef();
                if (map.size() > 1) {
                    throw new IllegalStateException("Found a map with more than one entries");
                }
                String mapKey = fieldPath.next();
                if (MapDefImpl.isMapKeyTag(mapKey)) {
                    if (value.isNull()) {
                        map.getMap().clear();
                        return this;
                    }
                    assert (value instanceof StringValueImpl);
                    mapKey = ((StringValueImpl)value).get();
                    if (map.size() == 0) {
                        map.putNull(mapKey);
                    } else {
                        FieldValueImpl mapVal = map.get("[]");
                        assert (mapVal != null);
                        map.getMap().clear();
                        map.put(mapKey, mapVal);
                    }
                    return this;
                }
                if (mapKey.equals("[]") && map.size() != 0 && (iterator = (mapKeys = map.getMap().keySet()).iterator()).hasNext()) {
                    String key;
                    mapKey = key = iterator.next();
                }
                if (!fieldPath.hasNext()) {
                    if (value.isNull()) {
                        return this;
                    }
                    if (type != elemDef.getType()) {
                        throw new IllegalStateException("Incorrect type for map.  Expected " + elemDef.getType() + ", received " + type);
                    }
                    map.put(mapKey, value);
                } else {
                    FieldValueImpl val = map.get(mapKey);
                    if (val == null || val.isNull()) {
                        val = FieldValueImpl.createComplexValue(elemDef);
                    }
                    map.put(mapKey, val.putComplex(fieldPath, value));
                }
                return this;
            }
        }
        throw new IllegalArgumentException("Cannot put a value in an atomic value");
    }

    private static ComplexValueImpl createComplexValue(FieldDef def) {
        switch (def.getType()) {
            case MAP: {
                return (ComplexValueImpl)((Object)def.createMap());
            }
            case RECORD: {
                return (ComplexValueImpl)((Object)def.createRecord());
            }
            case ARRAY: {
                return (ComplexValueImpl)((Object)def.createArray());
            }
        }
        throw new IllegalArgumentException("Not a complex type: " + def.getType());
    }

    FieldValueImpl findFieldValue(ListIterator<String> iter, int arrayIndex) {
        return null;
    }

    FieldValueImpl findFieldValue(ListIterator<String> fieldPath, String mapKey) {
        return null;
    }

    protected static Object readTuple(FieldDef def, TupleInput in) {
        switch (def.getType()) {
            case INTEGER: {
                return in.readSortedPackedInt();
            }
            case STRING: {
                return in.readString();
            }
            case LONG: {
                return in.readSortedPackedLong();
            }
            case DOUBLE: {
                return in.readSortedDouble();
            }
            case FLOAT: {
                return Float.valueOf(in.readSortedFloat());
            }
            case NUMBER: {
                return NumberUtils.readTuple(in);
            }
            case ENUM: {
                return in.readSortedPackedInt();
            }
            case BOOLEAN: {
                return in.readBoolean();
            }
            case TIMESTAMP: {
                byte[] buf = new byte[((TimestampDefImpl)def).getNumBytes()];
                in.read(buf);
                return buf;
            }
        }
        throw new IllegalStateException("Type not supported in indexes: " + def.getType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int compareFieldValues(FieldValue val1, FieldValue val2) {
        if (val1 != null) {
            if (val2 == null) {
                return -1;
            }
            if (!val1.isNull() && !val2.isNull()) return val1.compareTo(val2);
            if (!val1.isNull()) {
                return -1;
            }
            if (val2.isNull()) return 0;
            return 1;
        }
        if (val2 == null) return 0;
        return 1;
    }

    static Schema getUnionSchema(Schema schema, Schema.Type type) {
        if (schema.getType() == Schema.Type.UNION) {
            for (Schema s : schema.getTypes()) {
                if (s.getType() != type) continue;
                return s;
            }
            throw new IllegalArgumentException("Cannot find type in union schema: " + (Object)((Object)type));
        }
        return schema;
    }

    public int castAsInt() {
        throw new ClassCastException("Value can not be cast to an integer: " + this.getClass());
    }

    public long castAsLong() {
        throw new ClassCastException("Value can not be cast to a long: " + this.getClass());
    }

    public float castAsFloat() {
        throw new ClassCastException("Value can not be cast to a float: " + this.getClass());
    }

    public double castAsDouble() {
        throw new ClassCastException("Value can not be cast to a double: " + this.getClass());
    }

    public BigDecimal castAsDecimal() {
        throw new ClassCastException("Value can not be cast to a Number: " + this.getClass());
    }

    public String castAsString() {
        throw new ClassCastException("Value can not be cast to a String: " + this.getClass());
    }

    FieldValue castToSuperType(FieldDefImpl targetDef) {
        FieldDefImpl valDef = this.getDefinition();
        if (targetDef.isWildcard() || targetDef.equals(valDef)) {
            return this;
        }
        assert (valDef.isSubtype(targetDef));
        switch (this.getType()) {
            case INTEGER: {
                return targetDef.isLong() ? targetDef.createLong(this.asInteger().get()) : targetDef.createNumber(this.asInteger().get());
            }
            case LONG: {
                assert (targetDef.isNumber());
                return targetDef.createNumber(this.asLong().get());
            }
            case FLOAT: {
                return targetDef.isDouble() ? targetDef.createDouble(this.asFloat().get()) : targetDef.createNumber(this.asFloat().get());
            }
            case DOUBLE: {
                assert (targetDef.isNumber());
                return targetDef.createNumber(this.asDouble().get());
            }
            case ARRAY: {
                FieldDefImpl elemDef = ((ArrayDefImpl)targetDef).getElement();
                ArrayValueImpl arr = (ArrayValueImpl)this;
                ArrayValueImpl newarr = ((ArrayDefImpl)targetDef).createArray();
                for (FieldValue e : arr.getArrayInternal()) {
                    FieldValueImpl elem = (FieldValueImpl)e;
                    newarr.addInternal(elem.castToSuperType(elemDef));
                }
                return newarr;
            }
            case MAP: {
                FieldDefImpl targetElemDef = ((MapDefImpl)targetDef).getElement();
                MapValueImpl map = (MapValueImpl)this;
                MapValueImpl newmap = ((MapDefImpl)targetDef).createMap();
                for (Map.Entry<String, FieldValue> entry : map.getMap().entrySet()) {
                    String key = entry.getKey();
                    FieldValueImpl elem = (FieldValueImpl)entry.getValue();
                    newmap.put(key, elem.castToSuperType(targetElemDef));
                }
                return newmap;
            }
            case RECORD: {
                RecordValueImpl rec = (RecordValueImpl)this;
                RecordValueImpl newrec = ((RecordDefImpl)targetDef).createRecord();
                int numFields = rec.getNumFields();
                RecordDefImpl recTargetDef = (RecordDefImpl)targetDef;
                for (int i = 0; i < numFields; ++i) {
                    FieldValueImpl fval = rec.get(i);
                    if (fval == null) continue;
                    FieldDefImpl targetFieldDef = recTargetDef.getFieldDef(i);
                    newrec.put(i, fval.castToSuperType(targetFieldDef));
                }
                return newrec;
            }
            case NUMBER: 
            case STRING: 
            case BINARY: 
            case FIXED_BINARY: 
            case BOOLEAN: 
            case ENUM: 
            case TIMESTAMP: {
                return this;
            }
        }
        throw new IllegalStateException("Unexpected type: " + this.getType());
    }
}

