/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import java.io.Serializable;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

@Persistent(version=2)
class FieldMapEntry
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final transient String fieldName;
    private final FieldDefImpl field;
    private boolean nullable;
    private FieldValueImpl defaultValue;

    FieldMapEntry(String name, FieldDefImpl type, boolean nullable, FieldValueImpl defaultValue) {
        this.fieldName = name;
        this.field = type;
        this.nullable = nullable;
        this.defaultValue = defaultValue;
    }

    FieldMapEntry(String name, FieldDefImpl type) {
        this(name, type, true, null);
    }

    private FieldMapEntry(FieldMapEntry other) {
        this.fieldName = other.fieldName;
        this.field = other.field.clone();
        this.nullable = other.nullable;
        this.defaultValue = other.defaultValue != null ? other.defaultValue.clone() : null;
    }

    public FieldMapEntry clone() {
        return new FieldMapEntry(this);
    }

    private FieldMapEntry() {
        this.fieldName = null;
        this.field = null;
        this.defaultValue = null;
        this.nullable = false;
    }

    String getFieldName() {
        return this.fieldName;
    }

    FieldDefImpl getFieldDef() {
        return this.field;
    }

    boolean isNullable() {
        return this.nullable;
    }

    boolean isPrecise() {
        return this.field.isPrecise();
    }

    boolean isSubtype(FieldMapEntry sup) {
        if (!this.fieldName.equals(sup.fieldName)) {
            return false;
        }
        if (this.nullable != sup.nullable && this.nullable) {
            return false;
        }
        return this.field.isSubtype(sup.field);
    }

    FieldValueImpl getDefaultValueInternal() {
        return this.defaultValue;
    }

    FieldValueImpl getDefaultValue() {
        return this.defaultValue != null ? this.defaultValue : NullValueImpl.getInstance();
    }

    boolean hasDefaultValue() {
        return this.defaultValue != null && !this.defaultValue.isNull();
    }

    void setAsPrimaryKey() {
        this.nullable = false;
        this.defaultValue = null;
    }

    void setNullable() {
        this.nullable = true;
        this.defaultValue = null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FieldMapEntry) {
            FieldMapEntry other = (FieldMapEntry)obj;
            return this.fieldName.equalsIgnoreCase(other.fieldName) && this.field.equals(other.field) && this.nullable == other.nullable && this.getDefaultValue().equals(other.getDefaultValue());
        }
        return false;
    }

    public int hashCode() {
        return this.fieldName.hashCode() + this.field.hashCode() + Boolean.valueOf(this.nullable).hashCode() + this.getDefaultValue().hashCode();
    }

    final JsonNode createAvroTypeAndDefault(ObjectNode node) {
        if (this.isNullable()) {
            ArrayNode arrayNode = node.putArray("type");
            if (this.getDefaultValue().isNull()) {
                arrayNode.add("null");
                arrayNode.add(this.field.mapTypeToAvroJsonNode());
            } else {
                arrayNode.add(this.field.mapTypeToAvroJsonNode());
                arrayNode.add("null");
            }
        } else {
            node.put("type", this.field.mapTypeToAvroJsonNode());
        }
        node.put("default", this.getDefaultValue().toJsonNode());
        return node;
    }

    void toJson(ObjectNode node) {
        this.field.toJson(node);
        node.put("nullable", this.nullable);
        node.put("default", this.getDefaultValue().toJsonNode());
    }
}

