/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.FieldDefFactory;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.FieldMapEntry;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FieldValueSerialization;
import oracle.kv.impl.api.table.FixedBinaryDefImpl;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.TimestampDefImpl;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.table.FieldDef;

public class FieldDefSerialization {
    public static void writeFieldDef(FieldDef def, DataOutput out, short serialVersion) throws IOException {
        def.getType().writeFastExternal(out, serialVersion);
        switch (def.getType()) {
            case INTEGER: 
            case LONG: 
            case DOUBLE: 
            case FLOAT: 
            case STRING: 
            case BINARY: 
            case BOOLEAN: 
            case NUMBER: 
            case ANY: 
            case ANY_ATOMIC: 
            case ANY_RECORD: 
            case EMPTY: 
            case JSON: 
            case ANY_JSON_ATOMIC: {
                break;
            }
            case FIXED_BINARY: {
                int size = ((FixedBinaryDefImpl)def).getSize();
                SerializationUtil.writePackedInt(out, size);
                break;
            }
            case ENUM: {
                FieldDefSerialization.writeEnum(def, out, serialVersion);
                break;
            }
            case TIMESTAMP: {
                FieldDefSerialization.writeTimestamp(def, out, serialVersion);
                break;
            }
            case RECORD: {
                FieldDefSerialization.writeRecord((RecordDefImpl)def, out, serialVersion);
                break;
            }
            case MAP: {
                FieldDefSerialization.writeMap((MapDefImpl)def, out, serialVersion);
                break;
            }
            case ARRAY: {
                FieldDefSerialization.writeArray((ArrayDefImpl)def, out, serialVersion);
            }
        }
    }

    static void writeRecord(RecordDefImpl def, DataOutput out, short serialVersion) throws IOException {
        SerializationUtil.writeString(out, def.getName());
        SerializationUtil.writePackedInt(out, def.getNumFields());
        for (FieldMapEntry fme : def.getFieldProperties()) {
            String fname = fme.getFieldName();
            FieldDefImpl fdef = fme.getFieldDef();
            SerializationUtil.writeString(out, fname);
            FieldDefSerialization.writeFieldDef(fdef, out, serialVersion);
            boolean nullable = fme.isNullable();
            out.writeBoolean(nullable);
            if (nullable) continue;
            FieldValueImpl defVal = fme.getDefaultValue();
            assert (defVal != null);
            FieldValueSerialization.writeFieldValue(defVal, fdef.isWildcard(), out, serialVersion);
        }
    }

    static void writeMap(MapDefImpl def, DataOutput out, short serialVersion) throws IOException {
        FieldDefSerialization.writeFieldDef(def.getElement(), out, serialVersion);
    }

    static void writeArray(ArrayDefImpl def, DataOutput out, short serialVersion) throws IOException {
        FieldDefSerialization.writeFieldDef(def.getElement(), out, serialVersion);
    }

    static void writeEnum(FieldDef def, DataOutput out, short serialVersion) throws IOException {
        EnumDefImpl enumDef = (EnumDefImpl)def;
        String[] values = enumDef.getValues();
        SerializationUtil.writePackedInt(out, values.length);
        for (String value : values) {
            SerializationUtil.writeString(out, value);
        }
    }

    static void writeTimestamp(FieldDef def, DataOutput out, short serialVersion) throws IOException {
        SerializationUtil.writePackedInt(out, def.asTimestamp().getPrecision());
    }

    public static FieldDefImpl readFieldDef(DataInput in, short serialVersion) throws IOException {
        FieldDef.Type type = FieldDef.Type.readFastExternal(in, serialVersion);
        switch (type) {
            case INTEGER: {
                return FieldDefImpl.integerDef;
            }
            case LONG: {
                return FieldDefImpl.longDef;
            }
            case DOUBLE: {
                return FieldDefImpl.doubleDef;
            }
            case FLOAT: {
                return FieldDefImpl.floatDef;
            }
            case STRING: {
                return FieldDefImpl.stringDef;
            }
            case BINARY: {
                return FieldDefImpl.binaryDef;
            }
            case BOOLEAN: {
                return FieldDefImpl.booleanDef;
            }
            case NUMBER: {
                return FieldDefImpl.numberDef;
            }
            case FIXED_BINARY: {
                int size = SerializationUtil.readPackedInt(in);
                return new FixedBinaryDefImpl(size, null);
            }
            case ENUM: {
                return FieldDefSerialization.readEnum(in, serialVersion);
            }
            case TIMESTAMP: {
                return FieldDefSerialization.readTimestamp(in, serialVersion);
            }
            case RECORD: {
                return FieldDefSerialization.readRecord(in, serialVersion);
            }
            case MAP: {
                return FieldDefSerialization.readMap(in, serialVersion);
            }
            case ARRAY: {
                return FieldDefSerialization.readArray(in, serialVersion);
            }
            case ANY: {
                return FieldDefImpl.anyDef;
            }
            case ANY_ATOMIC: {
                return FieldDefImpl.anyAtomicDef;
            }
            case ANY_JSON_ATOMIC: {
                return FieldDefImpl.anyJsonAtomicDef;
            }
            case ANY_RECORD: {
                return FieldDefImpl.anyRecordDef;
            }
            case EMPTY: {
                return FieldDefImpl.emptyDef;
            }
            case JSON: {
                return FieldDefImpl.jsonDef;
            }
        }
        throw new IllegalStateException("Unknown type code: " + type);
    }

    static RecordDefImpl readRecord(DataInput in, short serialVersion) throws IOException {
        String name = SerializationUtil.readString(in);
        int size = SerializationUtil.readPackedInt(in);
        FieldMap fieldMap = new FieldMap();
        for (int i = 0; i < size; ++i) {
            String fname = SerializationUtil.readString(in);
            FieldDefImpl fdef = FieldDefSerialization.readFieldDef(in, serialVersion);
            boolean nullable = in.readBoolean();
            FieldValueImpl defVal = null;
            if (!nullable) {
                defVal = (FieldValueImpl)FieldValueSerialization.readFieldValue(fdef.isWildcard() ? null : fdef, in, serialVersion);
            }
            fieldMap.put(fname, fdef, nullable, defVal);
        }
        if (name == null) {
            return new RecordDefImpl(fieldMap, null);
        }
        return new RecordDefImpl(name, fieldMap);
    }

    static MapDefImpl readMap(DataInput in, short serialVersion) throws IOException {
        return FieldDefFactory.createMapDef(FieldDefSerialization.readFieldDef(in, serialVersion));
    }

    static ArrayDefImpl readArray(DataInput in, short serialVersion) throws IOException {
        return FieldDefFactory.createArrayDef(FieldDefSerialization.readFieldDef(in, serialVersion));
    }

    static EnumDefImpl readEnum(DataInput in, short serialVersion) throws IOException {
        int numValues = SerializationUtil.readPackedInt(in);
        String[] values = new String[numValues];
        for (int i = 0; i < numValues; ++i) {
            values[i] = SerializationUtil.readString(in);
        }
        return new EnumDefImpl(values, null);
    }

    static TimestampDefImpl readTimestamp(DataInput in, short serialVersion) throws IOException {
        return new TimestampDefImpl(SerializationUtil.readPackedInt(in));
    }
}

