/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ListIterator;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.api.table.AnyAtomicDefImpl;
import oracle.kv.impl.api.table.AnyDefImpl;
import oracle.kv.impl.api.table.AnyJsonAtomicDefImpl;
import oracle.kv.impl.api.table.AnyRecordDefImpl;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.BinaryDefImpl;
import oracle.kv.impl.api.table.BooleanDefImpl;
import oracle.kv.impl.api.table.BooleanValueImpl;
import oracle.kv.impl.api.table.ComplexValueImpl;
import oracle.kv.impl.api.table.DoubleDefImpl;
import oracle.kv.impl.api.table.DoubleValueImpl;
import oracle.kv.impl.api.table.EmptyDefImpl;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.EnumValueImpl;
import oracle.kv.impl.api.table.FieldDefFactory;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FixedBinaryDefImpl;
import oracle.kv.impl.api.table.FloatDefImpl;
import oracle.kv.impl.api.table.FloatValueImpl;
import oracle.kv.impl.api.table.IntegerDefImpl;
import oracle.kv.impl.api.table.IntegerValueImpl;
import oracle.kv.impl.api.table.JsonDefImpl;
import oracle.kv.impl.api.table.LongDefImpl;
import oracle.kv.impl.api.table.LongValueImpl;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.NumberDefImpl;
import oracle.kv.impl.api.table.NumberValueImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.StringDefImpl;
import oracle.kv.impl.api.table.TableJsonUtils;
import oracle.kv.impl.api.table.TimestampDefImpl;
import oracle.kv.impl.api.table.TimestampValueImpl;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.util.JsonUtils;
import oracle.kv.table.AnyAtomicDef;
import oracle.kv.table.AnyDef;
import oracle.kv.table.AnyJsonAtomicDef;
import oracle.kv.table.AnyRecordDef;
import oracle.kv.table.ArrayDef;
import oracle.kv.table.ArrayValue;
import oracle.kv.table.BinaryDef;
import oracle.kv.table.BinaryValue;
import oracle.kv.table.BooleanDef;
import oracle.kv.table.BooleanValue;
import oracle.kv.table.DoubleDef;
import oracle.kv.table.DoubleValue;
import oracle.kv.table.EnumDef;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.FixedBinaryDef;
import oracle.kv.table.FixedBinaryValue;
import oracle.kv.table.FloatDef;
import oracle.kv.table.FloatValue;
import oracle.kv.table.IntegerDef;
import oracle.kv.table.IntegerValue;
import oracle.kv.table.JsonDef;
import oracle.kv.table.LongDef;
import oracle.kv.table.LongValue;
import oracle.kv.table.MapDef;
import oracle.kv.table.MapValue;
import oracle.kv.table.NumberDef;
import oracle.kv.table.NumberValue;
import oracle.kv.table.RecordDef;
import oracle.kv.table.RecordValue;
import oracle.kv.table.StringDef;
import oracle.kv.table.StringValue;
import oracle.kv.table.TimestampDef;
import oracle.kv.table.TimestampValue;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.TextNode;

@Persistent(version=1)
public abstract class FieldDefImpl
implements FieldDef,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final IntegerDefImpl integerDef = new IntegerDefImpl();
    public static final LongDefImpl longDef = new LongDefImpl();
    public static final FloatDefImpl floatDef = new FloatDefImpl();
    public static final DoubleDefImpl doubleDef = new DoubleDefImpl();
    public static final StringDefImpl stringDef = new StringDefImpl();
    public static final BooleanDefImpl booleanDef = new BooleanDefImpl();
    public static final BinaryDefImpl binaryDef = new BinaryDefImpl();
    public static final NumberDefImpl numberDef = new NumberDefImpl();
    public static final TimestampDefImpl[] timestampDefs = new TimestampDefImpl[10];
    public static final AnyDefImpl anyDef;
    public static final AnyRecordDefImpl anyRecordDef;
    public static final AnyAtomicDefImpl anyAtomicDef;
    public static final JsonDefImpl jsonDef;
    public static final AnyJsonAtomicDefImpl anyJsonAtomicDef;
    public static final MapDefImpl mapAnyDef;
    public static final MapDefImpl mapJsonDef;
    public static final ArrayDefImpl arrayAnyDef;
    public static final ArrayDefImpl arrayJsonDef;
    public static final EmptyDefImpl emptyDef;
    private final FieldDef.Type type;
    private String description;

    static TimestampDefImpl getTimeDef(int prec) {
        return timestampDefs[prec];
    }

    FieldDefImpl(FieldDef.Type type) {
        this(type, null);
    }

    FieldDefImpl(FieldDef.Type type, String description) {
        this.type = type;
        this.description = description;
    }

    FieldDefImpl(FieldDefImpl impl) {
        this.type = impl.type;
        this.description = impl.description;
    }

    FieldDefImpl() {
        this.type = null;
        this.description = null;
    }

    public String toString() {
        return this.toJsonString();
    }

    @Override
    public FieldDefImpl clone() {
        try {
            return (FieldDefImpl)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object other) {
        throw new IllegalStateException("Classes that implement FieldDefImpl must override equals");
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public FieldDef.Type getType() {
        return this.type;
    }

    @Override
    public boolean isType(FieldDef.Type type1) {
        return this.type == type1;
    }

    @Override
    public boolean isValidKeyField() {
        return false;
    }

    @Override
    public boolean isValidIndexField() {
        return false;
    }

    public boolean isEmpty() {
        return this.type == FieldDef.Type.EMPTY;
    }

    @Override
    public boolean isAny() {
        return this.type == FieldDef.Type.ANY;
    }

    @Override
    public boolean isAnyRecord() {
        return this.type == FieldDef.Type.ANY_RECORD;
    }

    @Override
    public boolean isAnyAtomic() {
        return this.type == FieldDef.Type.ANY_ATOMIC;
    }

    @Override
    public boolean isAnyJsonAtomic() {
        return this.type == FieldDef.Type.ANY_JSON_ATOMIC;
    }

    public boolean isWildcard() {
        switch (this.type) {
            case ANY: 
            case ANY_RECORD: 
            case ANY_ATOMIC: 
            case JSON: 
            case ANY_JSON_ATOMIC: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isString() {
        return this.type == FieldDef.Type.STRING;
    }

    @Override
    public boolean isInteger() {
        return this.type == FieldDef.Type.INTEGER;
    }

    @Override
    public boolean isLong() {
        return this.type == FieldDef.Type.LONG;
    }

    @Override
    public boolean isDouble() {
        return this.type == FieldDef.Type.DOUBLE;
    }

    @Override
    public boolean isFloat() {
        return this.type == FieldDef.Type.FLOAT;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return this.type == FieldDef.Type.BOOLEAN;
    }

    @Override
    public boolean isBinary() {
        return this.type == FieldDef.Type.BINARY;
    }

    @Override
    public boolean isFixedBinary() {
        return this.type == FieldDef.Type.FIXED_BINARY;
    }

    @Override
    public boolean isTimestamp() {
        return this.type == FieldDef.Type.TIMESTAMP;
    }

    @Override
    public boolean isArray() {
        return this.type == FieldDef.Type.ARRAY;
    }

    @Override
    public boolean isMap() {
        return this.type == FieldDef.Type.MAP;
    }

    @Override
    public boolean isRecord() {
        return this.type == FieldDef.Type.RECORD;
    }

    @Override
    public boolean isJson() {
        return this.type == FieldDef.Type.JSON;
    }

    @Override
    public boolean isEnum() {
        return this.type == FieldDef.Type.ENUM;
    }

    @Override
    public boolean isAtomic() {
        switch (this.type) {
            case ANY_ATOMIC: 
            case ANY_JSON_ATOMIC: 
            case BOOLEAN: 
            case DOUBLE: 
            case FLOAT: 
            case INTEGER: 
            case LONG: 
            case STRING: 
            case BINARY: 
            case FIXED_BINARY: 
            case ENUM: 
            case TIMESTAMP: {
                return true;
            }
        }
        return false;
    }

    public boolean isJsonAtomic() {
        switch (this.type) {
            case ANY_JSON_ATOMIC: 
            case BOOLEAN: 
            case DOUBLE: 
            case FLOAT: 
            case INTEGER: 
            case LONG: 
            case STRING: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isNumeric() {
        switch (this.type) {
            case DOUBLE: 
            case FLOAT: 
            case INTEGER: 
            case LONG: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isComplex() {
        switch (this.type) {
            case ANY: 
            case ANY_RECORD: 
            case JSON: 
            case RECORD: 
            case ARRAY: 
            case MAP: {
                return true;
            }
        }
        return false;
    }

    @Override
    public AnyDef asAny() {
        throw new ClassCastException("Type is not Any: " + this.getClass());
    }

    @Override
    public AnyRecordDef asAnyRecord() {
        throw new ClassCastException("Type is not AnyRecord: " + this.getClass());
    }

    @Override
    public AnyAtomicDef asAnyAtomic() {
        throw new ClassCastException("Type is not AnyAtomic: " + this.getClass());
    }

    @Override
    public AnyJsonAtomicDef asAnyJsonAtomic() {
        throw new ClassCastException("Type is not AnyAtomic: " + this.getClass());
    }

    @Override
    public BinaryDef asBinary() {
        throw new ClassCastException("Type is not a Binary: " + this.getClass());
    }

    @Override
    public FixedBinaryDef asFixedBinary() {
        throw new ClassCastException("Type is not a FixedBinary: " + this.getClass());
    }

    @Override
    public NumberDef asNumber() {
        throw new ClassCastException("Type is not a Number: " + this.getClass());
    }

    @Override
    public BooleanDef asBoolean() {
        throw new ClassCastException("Type is not a Boolean: " + this.getClass());
    }

    @Override
    public DoubleDef asDouble() {
        throw new ClassCastException("Type is not a Double: " + this.getClass());
    }

    @Override
    public FloatDef asFloat() {
        throw new ClassCastException("Type is not a Float: " + this.getClass());
    }

    @Override
    public IntegerDef asInteger() {
        throw new ClassCastException("Type is not an Integer: " + this.getClass());
    }

    @Override
    public LongDef asLong() {
        throw new ClassCastException("Type is not a Long: " + this.getClass());
    }

    @Override
    public StringDef asString() {
        throw new ClassCastException("Type is not a String: " + this.getClass());
    }

    @Override
    public TimestampDef asTimestamp() {
        throw new ClassCastException("Type is not a Timestmap: " + this.getClass());
    }

    @Override
    public EnumDef asEnum() {
        throw new ClassCastException("Type is not an Enum: " + this.getClass());
    }

    @Override
    public ArrayDef asArray() {
        throw new ClassCastException("Type is not an Array: " + this.getClass());
    }

    @Override
    public MapDef asMap() {
        throw new ClassCastException("Type is not a Map: " + this.getClass());
    }

    @Override
    public RecordDef asRecord() {
        throw new ClassCastException("Type is not a Record: " + this.getClass());
    }

    @Override
    public JsonDef asJson() {
        throw new ClassCastException("Type is not a JsonDef: " + this.getClass());
    }

    @Override
    public ArrayValue createArray() {
        throw new IllegalArgumentException("Type cannot create an Array: " + this.getClass());
    }

    @Override
    public NumberValue createNumber(int value) {
        throw new ClassCastException("Type is not a Number: " + this.getClass());
    }

    @Override
    public NumberValue createNumber(long value) {
        throw new ClassCastException("Type is not a Number: " + this.getClass());
    }

    @Override
    public NumberValue createNumber(float value) {
        throw new ClassCastException("Type is not a Number: " + this.getClass());
    }

    @Override
    public NumberValue createNumber(double value) {
        throw new ClassCastException("Type is not a Number: " + this.getClass());
    }

    @Override
    public NumberValue createNumber(BigDecimal value) {
        throw new ClassCastException("Type is not a Number: " + this.getClass());
    }

    @Override
    public BinaryValue createBinary(byte[] value) {
        throw new IllegalArgumentException("Type cannot create a Binary: " + this.getClass());
    }

    @Override
    public FixedBinaryValue createFixedBinary(byte[] value) {
        throw new IllegalArgumentException("Type cannot create a FixedBinary: " + this.getClass());
    }

    @Override
    public BooleanValue createBoolean(boolean value) {
        throw new IllegalArgumentException("Type cannot create a Boolean: " + this.getClass());
    }

    @Override
    public DoubleValue createDouble(double value) {
        throw new IllegalArgumentException("Type cannot create a Double: " + this.getClass());
    }

    @Override
    public FloatValue createFloat(float value) {
        throw new IllegalArgumentException("Type cannot create a Float: " + this.getClass());
    }

    @Override
    public EnumValueImpl createEnum(String value) {
        throw new IllegalArgumentException("Type cannot create an Enum: " + this.getClass());
    }

    @Override
    public IntegerValue createInteger(int value) {
        throw new IllegalArgumentException("Type cannot create an Integer: " + this.getClass());
    }

    @Override
    public LongValue createLong(long value) {
        throw new IllegalArgumentException("Type cannot create a Long: " + this.getClass());
    }

    @Override
    public TimestampValue createTimestamp(Timestamp value) {
        throw new IllegalArgumentException("Type cannot create a Timestamp: " + this.getClass());
    }

    @Override
    public MapValue createMap() {
        throw new IllegalArgumentException("Type cannot create a Map: " + this.getClass());
    }

    @Override
    public RecordValue createRecord() {
        throw new IllegalArgumentException("Type cannot create a Record: " + this.getClass());
    }

    @Override
    public StringValue createString(String value) {
        throw new IllegalArgumentException("Type cannot create a String: " + this.getClass());
    }

    @Override
    public FieldValue createJsonNull() {
        throw new IllegalArgumentException("Type cannot create a JSON null value: " + this.getClass());
    }

    boolean compare(Object o, Object other) {
        if (o != null) {
            return o.equals(other);
        }
        return other == null;
    }

    public void setDescription(String descr) {
        this.description = descr;
    }

    int getEncodingLength() {
        return -1;
    }

    public boolean isPrecise() {
        return true;
    }

    public boolean hasMin() {
        return false;
    }

    public boolean hasMax() {
        return false;
    }

    public boolean isSubtype(FieldDefImpl superType) {
        throw new IllegalStateException("Classes that implement FieldDefImpl must override isSubtype");
    }

    public FieldDefImpl getUnionType(FieldDefImpl other) {
        FieldDef.Type t2;
        if (this.isSubtype(other)) {
            return other;
        }
        if (other.isSubtype(this)) {
            return this;
        }
        FieldDef.Type t1 = this.getType();
        if (t1 == (t2 = other.getType())) {
            if (t1 == FieldDef.Type.RECORD || t1 == FieldDef.Type.ANY_RECORD) {
                return anyRecordDef;
            }
            if (t1 == FieldDef.Type.ARRAY) {
                ArrayDefImpl def1 = (ArrayDefImpl)this;
                ArrayDefImpl def2 = (ArrayDefImpl)other;
                FieldDefImpl edef1 = def1.getElement();
                FieldDefImpl edef2 = def2.getElement();
                FieldDefImpl eunion = edef1.getUnionType(edef2);
                return FieldDefFactory.createArrayDef(eunion);
            }
            if (t1 == FieldDef.Type.MAP) {
                MapDefImpl def1 = (MapDefImpl)this;
                MapDefImpl def2 = (MapDefImpl)other;
                FieldDefImpl edef1 = def1.getElement();
                FieldDefImpl edef2 = def2.getElement();
                FieldDefImpl eunion = edef1.getUnionType(edef2);
                return FieldDefFactory.createMapDef(eunion);
            }
        }
        if (this.isJsonAtomic() && other.isJsonAtomic()) {
            return anyJsonAtomicDef;
        }
        if (this.isSubtype(jsonDef) && other.isSubtype(jsonDef)) {
            return jsonDef;
        }
        if (this.isAtomic() && other.isAtomic()) {
            return anyAtomicDef;
        }
        return anyDef;
    }

    FieldDefImpl findField(ListIterator<String> fieldPath) {
        return null;
    }

    FieldDefImpl findField(String fieldName) {
        return null;
    }

    public String toJsonString() {
        ObjectWriter writer = JsonUtils.createWriter(true);
        ObjectNode o = JsonUtils.createObjectNode();
        this.toJson(o);
        try {
            return writer.writeValueAsString(o);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Failed to serialize type description: " + ioe.getMessage());
        }
    }

    void toJson(ObjectNode node) {
        if (this.description != null) {
            node.put("comment", this.description);
        }
        node.put("type", this.getType().toString());
    }

    public String getDDLString() {
        StringBuilder sb = new StringBuilder();
        this.display(sb, new QueryFormatter());
        return sb.toString();
    }

    public void display(StringBuilder sb, QueryFormatter formatter) {
        switch (this.getType()) {
            case ANY: {
                sb.append("Any");
                break;
            }
            case ANY_ATOMIC: {
                sb.append("AnyAtomic");
                break;
            }
            case ANY_RECORD: {
                sb.append("AnyRecord");
                break;
            }
            case ANY_JSON_ATOMIC: {
                sb.append("AnyJsonAtomic");
                break;
            }
            case JSON: {
                sb.append("Json");
                break;
            }
            case EMPTY: {
                sb.append("Empty");
                break;
            }
            case BOOLEAN: 
            case DOUBLE: 
            case FLOAT: 
            case INTEGER: 
            case LONG: 
            case STRING: 
            case BINARY: 
            case NUMBER: {
                String typeName = this.getType().toString();
                typeName = typeName.substring(0, 1).toUpperCase() + typeName.substring(1).toLowerCase();
                sb.append(typeName);
                break;
            }
            case ENUM: {
                sb.append("Enum(");
                String[] values = this.asEnum().getValues();
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append('\"');
                    sb.append(values[i]);
                    sb.append('\"');
                }
                sb.append(")");
                break;
            }
            case TIMESTAMP: {
                sb.append("Timestamp(");
                sb.append(this.asTimestamp().getPrecision());
                sb.append(")");
                break;
            }
            case FIXED_BINARY: {
                sb.append("Binary(");
                sb.append(this.asFixedBinary().getSize());
                sb.append(")");
                break;
            }
            case ARRAY: {
                ArrayDefImpl def = (ArrayDefImpl)this;
                FieldDefImpl edef = def.getElement();
                sb.append("Array(");
                if (!edef.isRecord()) {
                    edef.display(sb, formatter);
                } else {
                    formatter.incIndent();
                    sb.append("\n");
                    formatter.indent(sb);
                    edef.display(sb, formatter);
                    formatter.decIndent();
                    formatter.indent(sb);
                }
                sb.append(")");
                break;
            }
            case MAP: {
                MapDefImpl def = (MapDefImpl)this;
                FieldDefImpl edef = def.getElement();
                sb.append("Map(");
                if (!edef.isRecord()) {
                    edef.display(sb, formatter);
                } else {
                    formatter.incIndent();
                    sb.append("\n");
                    formatter.indent(sb);
                    edef.display(sb, formatter);
                    formatter.decIndent();
                    formatter.indent(sb);
                }
                sb.append(")");
                break;
            }
            case RECORD: {
                RecordDefImpl def = (RecordDefImpl)this;
                sb.append("RECORD(\n");
                formatter.incIndent();
                int numFields = def.getNumFields();
                for (int i = 0; i < numFields; ++i) {
                    formatter.indent(sb);
                    sb.append(def.getFieldName(i)).append(" : ");
                    FieldDefImpl fdef = def.getFieldDef(i);
                    if (!fdef.isRecord()) {
                        fdef.display(sb, formatter);
                    } else {
                        sb.append("\n");
                        formatter.incIndent();
                        fdef.display(sb, formatter);
                        formatter.decIndent();
                    }
                    if (i >= numFields - 1) continue;
                    sb.append(",\n");
                }
                sb.append("\n");
                formatter.decIndent();
                formatter.indent(sb);
                sb.append(")");
                break;
            }
        }
    }

    JsonNode mapTypeToAvro(ObjectNode node) {
        throw new IllegalArgumentException("Type must override mapTypeToAvro: " + this.getType());
    }

    final JsonNode mapTypeToAvroJsonNode() {
        String textValue = null;
        switch (this.type) {
            case INTEGER: {
                textValue = "int";
                break;
            }
            case LONG: {
                textValue = "long";
                break;
            }
            case STRING: {
                textValue = "string";
                break;
            }
            case BOOLEAN: {
                textValue = "boolean";
                break;
            }
            case FLOAT: {
                textValue = "float";
                break;
            }
            case DOUBLE: {
                textValue = "double";
                break;
            }
            case JSON: 
            case BINARY: 
            case TIMESTAMP: 
            case NUMBER: {
                textValue = "bytes";
                break;
            }
            case FIXED_BINARY: 
            case ENUM: 
            case RECORD: 
            case ARRAY: 
            case MAP: {
                return this.mapTypeToAvro(null);
            }
            case ANY: 
            case ANY_RECORD: 
            case ANY_ATOMIC: 
            case ANY_JSON_ATOMIC: {
                throw new IllegalStateException("Wildcard types cannot be mapped to AVRO types: " + this.type);
            }
            default: {
                throw new IllegalStateException("Unknown type in mapTypeToAvroJsonNode: " + this.type);
            }
        }
        return new TextNode(textValue);
    }

    FieldValueImpl createValue(JsonNode node) {
        return null;
    }

    IntegerValueImpl createInteger(String value) {
        throw new IllegalArgumentException("Type cannot create an Integer: " + this.getClass());
    }

    LongValueImpl createLong(String value) {
        throw new IllegalArgumentException("Type cannot create a Long: " + this.getClass());
    }

    DoubleValueImpl createDouble(String value) {
        throw new IllegalArgumentException("Type cannot create a Double: " + this.getClass());
    }

    FloatValueImpl createFloat(String value) {
        throw new IllegalArgumentException("Type cannot create a Float: " + this.getClass());
    }

    NumberValueImpl createNumber(byte[] value) {
        throw new IllegalArgumentException("Type cannot create a Number: " + this.getClass());
    }

    NumberValueImpl createNumber(String value) {
        throw new IllegalArgumentException("Type cannot create a Number: " + this.getClass());
    }

    BooleanValueImpl createBoolean(String value) {
        throw new IllegalArgumentException("Type cannot create a Boolean: " + this.getClass());
    }

    TimestampValueImpl createTimestamp(byte[] value) {
        throw new IllegalArgumentException("Type cannot create a Timestamp: " + this.getClass());
    }

    TimestampValueImpl createTimestamp(String value) {
        throw new IllegalArgumentException("Type cannot create a Timestamp: " + this.getClass());
    }

    static FieldValueImpl createValueFromKeyString(String value, FieldDefImpl type) {
        switch (type.getType()) {
            case INTEGER: {
                return type.createInteger(value);
            }
            case LONG: {
                return type.createLong(value);
            }
            case STRING: {
                return (FieldValueImpl)((Object)type.createString(value));
            }
            case DOUBLE: {
                return type.createDouble(value);
            }
            case FLOAT: {
                return type.createFloat(value);
            }
            case NUMBER: {
                return type.createNumber(value);
            }
            case ENUM: {
                return EnumValueImpl.createFromKey((EnumDefImpl)type, value);
            }
            case BOOLEAN: {
                return type.createBoolean(value);
            }
            case TIMESTAMP: {
                return type.createTimestamp(value);
            }
        }
        throw new IllegalCommandException("Type is not allowed in a key: " + type.getType());
    }

    public static FieldValue createValueFromString(String value, FieldDef def) {
        switch (def.getType()) {
            case INTEGER: {
                return def.createInteger(Integer.parseInt(value));
            }
            case LONG: {
                return def.createLong(Long.parseLong(value));
            }
            case STRING: {
                return def.createString(value);
            }
            case DOUBLE: {
                return def.createDouble(Double.parseDouble(value));
            }
            case FLOAT: {
                return def.createFloat(Float.parseFloat(value));
            }
            case NUMBER: {
                return def.createNumber(new BigDecimal(value));
            }
            case BOOLEAN: {
                return def.createBoolean(Boolean.parseBoolean(value));
            }
            case ENUM: {
                return def.createEnum(value);
            }
            case BINARY: {
                return ((BinaryDefImpl)def).fromString(value);
            }
            case FIXED_BINARY: {
                return ((FixedBinaryDefImpl)def).fromString(value);
            }
            case TIMESTAMP: {
                return ((TimestampDefImpl)def).fromString(value);
            }
            case RECORD: {
                RecordValueImpl recordValue = (RecordValueImpl)def.createRecord();
                ByteArrayInputStream jsonInput = new ByteArrayInputStream(value.getBytes());
                ComplexValueImpl.createFromJson(recordValue, jsonInput, false);
                return recordValue;
            }
            case ARRAY: {
                ArrayValueImpl arrayValue = (ArrayValueImpl)def.createArray();
                ByteArrayInputStream jsonInput = new ByteArrayInputStream(value.getBytes());
                ComplexValueImpl.createFromJson(arrayValue, jsonInput, false);
                return arrayValue;
            }
            case MAP: {
                MapValueImpl mapValue = (MapValueImpl)def.createMap();
                ByteArrayInputStream jsonInput = new ByteArrayInputStream(value.getBytes());
                ComplexValueImpl.createFromJson(mapValue, jsonInput, false);
                return mapValue;
            }
            case JSON: 
            case ANY_JSON_ATOMIC: {
                ByteArrayInputStream jsonInput = new ByteArrayInputStream(value.getBytes());
                try {
                    JsonParser jp = TableJsonUtils.createJsonParser(jsonInput);
                    return JsonDefImpl.createFromJson(jp, true);
                }
                catch (IOException ioe) {
                    throw new IllegalArgumentException("Failed to parse JSON input: " + ioe.getMessage());
                }
            }
        }
        throw new IllegalArgumentException("Type not yet implemented: " + def.getType());
    }

    FieldValue createValue(Object value) {
        switch (this.getType()) {
            case INTEGER: {
                return this.createInteger((Integer)value);
            }
            case STRING: {
                return this.createString((String)value);
            }
            case LONG: {
                return this.createLong((Long)value);
            }
            case DOUBLE: {
                return this.createDouble((Double)value);
            }
            case FLOAT: {
                return this.createFloat(((Float)value).floatValue());
            }
            case NUMBER: {
                return this.createNumber((byte[])value);
            }
            case BOOLEAN: {
                return this.createBoolean((Boolean)value);
            }
            case ENUM: {
                return ((EnumDefImpl)this).createEnum((Integer)value);
            }
            case TIMESTAMP: {
                return this.createTimestamp((byte[])value);
            }
        }
        throw new IllegalStateException("Type not supported by createValue: " + this.getType());
    }

    public abstract short getRequiredSerialVersion();

    static {
        for (int i = 0; i <= 9; ++i) {
            FieldDefImpl.timestampDefs[i] = new TimestampDefImpl(i);
        }
        anyDef = new AnyDefImpl();
        anyRecordDef = new AnyRecordDefImpl();
        anyAtomicDef = new AnyAtomicDefImpl();
        jsonDef = new JsonDefImpl();
        anyJsonAtomicDef = new AnyJsonAtomicDefImpl();
        mapAnyDef = new MapDefImpl(anyDef);
        mapJsonDef = new MapDefImpl(jsonDef);
        arrayAnyDef = new ArrayDefImpl(anyDef);
        arrayJsonDef = new ArrayDefImpl(jsonDef);
        emptyDef = new EmptyDefImpl();
    }
}

