/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import java.math.BigDecimal;
import oracle.kv.impl.api.table.DoubleDefImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.util.SortableString;
import oracle.kv.table.DoubleValue;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.DoubleNode;

@Persistent(version=1)
public class DoubleValueImpl
extends FieldValueImpl
implements DoubleValue {
    private static final long serialVersionUID = 1L;
    protected double value;

    DoubleValueImpl(double value) {
        this.value = value;
    }

    DoubleValueImpl(String keyValue) {
        this.value = SortableString.doubleFromSortable(keyValue);
    }

    private DoubleValueImpl() {
    }

    @Override
    public DoubleValueImpl clone() {
        return new DoubleValueImpl(this.value);
    }

    public int hashCode() {
        return Double.valueOf(this.value).hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof DoubleValueImpl) {
            return Double.compare(this.value, ((DoubleValueImpl)other).get()) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof DoubleValueImpl) {
            return Double.compare(this.value, ((DoubleValueImpl)other).get());
        }
        throw new ClassCastException("Object is not an DoubleValue");
    }

    public String toString() {
        return Double.toString(this.value);
    }

    @Override
    public FieldDef.Type getType() {
        return FieldDef.Type.DOUBLE;
    }

    @Override
    public DoubleDefImpl getDefinition() {
        return FieldDefImpl.doubleDef;
    }

    @Override
    public DoubleValue asDouble() {
        return this;
    }

    @Override
    public boolean isDouble() {
        return true;
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public double get() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public void setDouble(double v) {
        this.value = v;
    }

    @Override
    public int castAsInt() {
        return (int)this.value;
    }

    @Override
    public long castAsLong() {
        return (long)this.value;
    }

    @Override
    public float castAsFloat() {
        return (float)this.value;
    }

    @Override
    public double castAsDouble() {
        return this.value;
    }

    @Override
    public BigDecimal castAsDecimal() {
        return new BigDecimal(this.value);
    }

    @Override
    public String castAsString() {
        return Double.toString(this.value);
    }

    @Override
    public FieldValueImpl getNextValue() {
        return new DoubleValueImpl(Math.nextUp(this.value));
    }

    @Override
    public FieldValueImpl getMinimumValue() {
        return new DoubleValueImpl(Double.MIN_VALUE);
    }

    @Override
    public String formatForKey(FieldDef field, int storageSize) {
        return SortableString.toSortable(this.value);
    }

    @Override
    public JsonNode toJsonNode() {
        return new DoubleNode(this.value);
    }

    @Override
    public void toStringBuilder(StringBuilder sb) {
        sb.append(this.toString());
    }
}

