/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.FieldMapEntry;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.table.ArrayDef;
import oracle.kv.table.EnumDef;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FixedBinaryDef;
import oracle.kv.table.Index;
import oracle.kv.table.MapDef;
import oracle.kv.table.RecordDef;
import oracle.kv.table.Table;
import oracle.kv.table.TimeToLive;
import oracle.kv.table.TimestampDef;

public class DDLGenerator {
    private final Table table;
    private final StringBuilder tableSb;
    private final List<String> indexDDLs;

    public DDLGenerator(Table table) {
        this.table = table;
        this.tableSb = new StringBuilder();
        this.generateDDL();
        this.indexDDLs = new ArrayList<String>();
        this.generateAllIndexDDL();
    }

    public String getDDL() {
        return this.tableSb.toString();
    }

    public List<String> getAllIndexDDL() {
        return this.indexDDLs;
    }

    private void generateDDL() {
        this.tableSb.append("CREATE TABLE ").append(this.table.getFullName()).append(" (");
        ArrayList<String> rejectKeyList = new ArrayList();
        Table parentTable = this.table.getParent();
        if (parentTable != null) {
            rejectKeyList = parentTable.getPrimaryKey();
        }
        TableImpl tableImpl = (TableImpl)this.table;
        FieldMap fieldMap = tableImpl.getFieldMap();
        this.getAllFieldDDL(tableImpl.getPrimaryKeyInternal(), fieldMap, rejectKeyList);
        this.tableSb.append(", ");
        if (parentTable != null) {
            this.getChildTableKeyDDL(rejectKeyList);
        } else {
            this.getParentTableKeyDDL();
        }
        this.tableSb.append(") ");
        TimeToLive defaultTTL = this.table.getDefaultTTL();
        if (defaultTTL != null) {
            this.tableSb.append("USING TTL ").append(defaultTTL.getValue()).append(" ").append(defaultTTL.getUnit().name());
        }
    }

    private void generateAllIndexDDL() {
        Map<String, Index> indexes = this.table.getIndexes();
        if (indexes.size() != 0) {
            for (Map.Entry<String, Index> indexEntry : indexes.entrySet()) {
                Index index = indexEntry.getValue();
                this.indexDDLs.add(this.getIndexDDL(index));
            }
        }
    }

    private void getAllFieldDDL(List<String> primaryKeyFields, FieldMap fieldMap, List<String> rejectKeyList) {
        int numFields = fieldMap.size();
        for (int i = 0; i < numFields; ++i) {
            String description;
            FieldValueImpl fieldValue;
            FieldMapEntry entry = fieldMap.getFieldMapEntry(i);
            String fname = entry.getFieldName();
            if (rejectKeyList.contains(fname)) continue;
            FieldDefImpl field = entry.getFieldDef();
            this.getFieldDDL(field, fname);
            if (!(entry.isNullable() || primaryKeyFields != null && primaryKeyFields.contains(fname))) {
                this.tableSb.append(" NOT NULL");
            }
            if (!(fieldValue = entry.getDefaultValue()).isNull()) {
                String defValue = fieldValue.toString();
                this.tableSb.append(" DEFAULT ").append(defValue);
            }
            if ((description = field.getDescription()) != null) {
                this.tableSb.append(" COMMENT \"").append(description).append("\"");
            }
            if (i == numFields - 1) break;
            this.tableSb.append(", ");
        }
    }

    private void getFieldDDL(FieldDef field, String fname) {
        switch (field.getType()) {
            case STRING: 
            case BINARY: 
            case BOOLEAN: 
            case DOUBLE: 
            case FLOAT: 
            case NUMBER: 
            case JSON: {
                this.getDDL(field, fname);
                break;
            }
            case ENUM: {
                EnumDef enumField = (EnumDef)field;
                this.getEnumDDL(enumField, fname);
                break;
            }
            case FIXED_BINARY: {
                FixedBinaryDef fixedBinaryField = (FixedBinaryDef)field;
                this.getFixedBinaryDDL(fixedBinaryField, fname);
                break;
            }
            case INTEGER: 
            case LONG: {
                this.getNumericDDL(field, fname);
                break;
            }
            case ARRAY: {
                ArrayDef arrayField = (ArrayDef)field;
                this.getArrayDDL(arrayField, fname);
                break;
            }
            case MAP: {
                MapDef mapField = (MapDef)field;
                this.getMapDDL(mapField, fname);
                break;
            }
            case RECORD: {
                RecordDef recField = (RecordDef)field;
                this.getRecordDDL(recField, fname);
                break;
            }
            case TIMESTAMP: {
                TimestampDef tsField = (TimestampDef)field;
                this.getTimestampDDL(tsField, fname);
                break;
            }
        }
    }

    private String getIndexDDL(Index index) {
        String description;
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE");
        if (index.getType() == Index.IndexType.TEXT) {
            sb.append(" FULLTEXT");
        }
        sb.append(" INDEX ").append(index.getName()).append(" ON ").append(this.table.getFullName()).append("(");
        List<String> fields = ((IndexImpl)index).getFields();
        int numFields = fields.size();
        for (int i = 0; i < numFields; ++i) {
            String annotationField;
            String field = fields.get(i);
            sb.append(field);
            if (index.getType() == Index.IndexType.TEXT && (annotationField = index.getAnnotationForField(field)) != null) {
                sb.append(" ").append(annotationField);
            }
            if (i == numFields - 1) break;
            sb.append(",");
        }
        sb.append(")");
        if (index.getType() == Index.IndexType.TEXT) {
            IndexImpl indexImpl = (IndexImpl)index;
            Map<String, String> properties = indexImpl.getProperties();
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                sb.append(" ").append(entry.getKey()).append(" = ").append(entry.getValue());
            }
        }
        if ((description = index.getDescription()) != null) {
            sb.append(" COMMENT \"").append(description).append("\"");
        }
        return sb.toString();
    }

    private void getDDL(FieldDef field, String fname) {
        String type = field.getType().toString();
        if (fname == null) {
            this.tableSb.append(type);
            return;
        }
        this.tableSb.append(fname).append(" ").append(type);
    }

    private void getEnumDDL(EnumDef field, String fname) {
        String type = field.getType().toString();
        if (fname == null) {
            this.tableSb.append(type);
            return;
        }
        this.tableSb.append(fname).append(" ").append(type).append("(");
        String symbol = null;
        String[] allSymbols = field.getValues();
        int numSymbols = allSymbols.length;
        for (int i = 0; i < numSymbols; ++i) {
            symbol = allSymbols[i];
            if (i == numSymbols - 1) break;
            this.tableSb.append(symbol).append(", ");
        }
        if (symbol != null) {
            this.tableSb.append(symbol);
        }
        this.tableSb.append(")");
    }

    private void getFixedBinaryDDL(FixedBinaryDef field, String fname) {
        if (fname == null) {
            this.tableSb.append("BINARY(").append(field.getSize()).append(")");
            return;
        }
        this.tableSb.append(fname).append(" ").append("BINARY(").append(field.getSize()).append(")");
    }

    private void getNumericDDL(FieldDef field, String fname) {
        String type = field.getType().toString();
        if (fname == null) {
            this.tableSb.append(type);
            return;
        }
        this.tableSb.append(fname).append(" ").append(type);
    }

    private void getArrayDDL(ArrayDef field, String fname) {
        FieldDef element = field.getElement();
        if (fname == null) {
            this.tableSb.append(field.getType().toString()).append("(");
            this.getFieldDDL(element, null);
            this.tableSb.append(")");
            return;
        }
        this.tableSb.append(fname).append(" ").append(field.getType().toString()).append("(");
        this.getFieldDDL(element, null);
        this.tableSb.append(")");
    }

    private void getMapDDL(MapDef field, String fname) {
        FieldDef element = field.getElement();
        if (fname == null) {
            this.tableSb.append(field.getType().toString()).append("(");
            this.getFieldDDL(element, null);
            this.tableSb.append(")");
            return;
        }
        this.tableSb.append(fname).append(" ").append(field.getType().toString()).append("(");
        this.getFieldDDL(element, null);
        this.tableSb.append(")");
    }

    private void getRecordDDL(RecordDef field, String fname) {
        RecordDefImpl fieldImpl = (RecordDefImpl)field;
        FieldMap fieldMap = fieldImpl.getFieldMap();
        if (fname == null) {
            this.tableSb.append(field.getType().toString()).append("(");
            this.getAllFieldDDL(null, fieldMap, new ArrayList<String>());
            this.tableSb.append(")");
            return;
        }
        this.tableSb.append(fname).append(" ").append(field.getType().toString()).append("(");
        this.getAllFieldDDL(null, fieldMap, new ArrayList<String>());
        this.tableSb.append(")");
    }

    private void getTimestampDDL(TimestampDef field, String fname) {
        if (fname == null) {
            this.tableSb.append("TIMESTAMP(").append(field.getPrecision()).append(")");
            return;
        }
        this.tableSb.append(fname).append(" ").append("TIMESTAMP(").append(field.getPrecision()).append(")");
    }

    private void getChildTableKeyDDL(List<String> rejectKeyList) {
        this.tableSb.append("PRIMARY KEY(");
        String nextKey = "";
        List<String> primaryKey = this.table.getPrimaryKey();
        TableImpl tabImpl = (TableImpl)this.table;
        List<Integer> primaryKeySizes = tabImpl.getPrimaryKeySizes();
        int keyIndex = rejectKeyList.size();
        int pKeySize = primaryKey.size();
        for (int i = 0; i < pKeySize; ++i) {
            nextKey = primaryKey.get(i);
            if (rejectKeyList.contains(nextKey)) continue;
            if (i == pKeySize - 1) break;
            this.tableSb.append(nextKey);
            this.appendPrimaryKeySizes(primaryKeySizes, keyIndex++);
            this.tableSb.append(", ");
        }
        this.tableSb.append(nextKey);
        this.appendPrimaryKeySizes(primaryKeySizes, keyIndex++);
        this.tableSb.append(")");
    }

    private void getParentTableKeyDDL() {
        String nextKey;
        List<String> primaryKey = this.table.getPrimaryKey();
        TableImpl tabImpl = (TableImpl)this.table;
        List<Integer> primaryKeySizes = tabImpl.getPrimaryKeySizes();
        int keyIndex = 0;
        List<String> shardKey = this.table.getShardKey();
        int sKeySize = shardKey.size();
        Iterator<String> pKeyIterator = primaryKey.iterator();
        this.tableSb.append("PRIMARY KEY(");
        if (sKeySize != 0) {
            this.tableSb.append("SHARD(");
            nextKey = "";
            for (int i = 0; i < sKeySize; ++i) {
                nextKey = shardKey.get(i);
                pKeyIterator.next();
                if (i == sKeySize - 1) break;
                this.tableSb.append(nextKey);
                this.appendPrimaryKeySizes(primaryKeySizes, keyIndex++);
                this.tableSb.append(", ");
            }
            this.tableSb.append(nextKey);
            this.appendPrimaryKeySizes(primaryKeySizes, keyIndex++);
            this.tableSb.append(")");
            if (pKeyIterator.hasNext()) {
                this.tableSb.append(", ");
            }
        }
        nextKey = "";
        while (pKeyIterator.hasNext()) {
            nextKey = pKeyIterator.next();
            if (!pKeyIterator.hasNext()) break;
            this.tableSb.append(nextKey);
            this.appendPrimaryKeySizes(primaryKeySizes, keyIndex++);
            this.tableSb.append(", ");
        }
        this.tableSb.append(nextKey);
        this.appendPrimaryKeySizes(primaryKeySizes, keyIndex++);
        this.tableSb.append(")");
    }

    private void appendPrimaryKeySizes(List<Integer> primaryKeySizes, int keyIndex) {
        Integer pKeySize;
        if (primaryKeySizes != null && keyIndex != primaryKeySizes.size() && (pKeySize = primaryKeySizes.get(keyIndex)) != 0) {
            this.tableSb.append("(").append(pKeySize.toString()).append(")");
        }
    }
}

