/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.util.List;
import java.util.Map;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.TableChange;
import oracle.kv.impl.api.table.TableMetadata;

class AddIndex
extends TableChange {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final String tableName;
    private final List<String> fields;
    private final Map<String, String> annotations;
    private final Map<String, String> properties;

    AddIndex(IndexImpl index, int seqNum) {
        super(seqNum);
        this.name = index.getName();
        this.description = index.getDescription();
        this.tableName = index.getTable().getFullName();
        this.fields = index.getFieldsInternal();
        this.annotations = index.getAnnotationsInternal();
        this.properties = index.getProperties();
    }

    @Override
    boolean apply(TableMetadata md) {
        if (this.annotations == null) {
            md.insertIndex(this.name, this.tableName, this.fields, this.description);
        } else {
            md.insertTextIndex(this.name, this.tableName, this.fields, this.annotations, this.properties, this.description);
        }
        return true;
    }
}

