/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.rgstate;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.util.RateLimitingLogger;

public class UpdateThreadPoolExecutor
extends ThreadPoolExecutor {
    private static int CORE_POOL_SIZE = 1;
    private static int QUEUE_SIZE = 300;
    private static int THREAD_INC_START_THRESHOLD = 16;
    private static int THREAD_INC_PERCENT = 10;
    private volatile int rejectCount = 0;
    private volatile int executeCount = 0;
    private final Map<ResourceId, UpdateTask> activeUpdates = new ConcurrentHashMap<ResourceId, UpdateTask>();
    private volatile int maxCorePoolSize;
    private volatile int maxMaxPoolSize;
    private final RateLimitingLogger<String> logger;

    UpdateThreadPoolExecutor(Logger logger, int keepAliveMs, ThreadFactory updateThreadFactory) {
        super(1, 3, (long)keepAliveMs, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(QUEUE_SIZE), updateThreadFactory);
        this.logger = new RateLimitingLogger(60000, 10, logger);
        this.setRejectedExecutionHandler(new UpdateRejectHandler());
    }

    int getMaxCorePoolSize() {
        return this.maxCorePoolSize;
    }

    int getMaxMaxPoolSize() {
        return this.maxMaxPoolSize;
    }

    public void tunePoolSize(int numServices) {
        if (numServices == 0) {
            return;
        }
        int maxPoolSize = Math.max(3, numServices / 10);
        int corePoolSize = CORE_POOL_SIZE;
        int currCorePoolSize = this.getCorePoolSize();
        int currMaxPoolSize = this.getMaximumPoolSize();
        int activeCount = this.getActiveCount();
        int queueSize = this.getQueue().size();
        if (this.executeCount == 0 && activeCount > 0 && queueSize > 0) {
            corePoolSize = Math.min(this.increaseThreads(currCorePoolSize), numServices);
        }
        if (this.rejectCount > 0) {
            maxPoolSize = Math.min(this.increaseThreads(currMaxPoolSize), numServices);
        }
        maxPoolSize = Math.max(corePoolSize, maxPoolSize);
        this.setCorePoolSize(corePoolSize);
        this.setMaximumPoolSize(maxPoolSize);
        this.maxCorePoolSize = Math.max(this.maxCorePoolSize, corePoolSize);
        this.maxMaxPoolSize = Math.max(this.maxMaxPoolSize, maxPoolSize);
        if (corePoolSize > 1 && (corePoolSize >= numServices || maxPoolSize >= numServices)) {
            String msg = String.format("Update thread pool size at limit. Total rns:%d core pool size:%d max pool size:%d", numServices, corePoolSize, maxPoolSize);
            this.logger.log(msg, Level.INFO, msg);
        }
        this.rejectCount = 0;
        this.executeCount = 0;
    }

    private int increaseThreads(int threads) {
        return threads < THREAD_INC_START_THRESHOLD ? 4 * threads : threads + Math.min(threads / THREAD_INC_PERCENT, 1);
    }

    @Override
    @Deprecated
    public void execute(Runnable command) {
        throw new UnsupportedOperationException("Please use the method: execute(UpdateTask), instead.");
    }

    public void execute(UpdateTask task) {
        ResourceId id = task.getResourceId();
        if (id != null && this.activeUpdates.put(id, task) != null) {
            this.logger.log(id.toString(), Level.INFO, "Task " + task + " execute() ignored for service " + id + " since it already had an outstanding task: " + this.activeUpdates.get(id));
            return;
        }
        super.execute(task);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        ++this.executeCount;
        ResourceId id = ((UpdateTask)r).getResourceId();
        if (id != null) {
            this.activeUpdates.remove(id);
        }
    }

    public static interface UpdateTask
    extends Runnable {
        public ResourceId getResourceId();
    }

    private class UpdateRejectHandler
    extends ThreadPoolExecutor.DiscardPolicy {
        private UpdateRejectHandler() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            int count = UpdateThreadPoolExecutor.this.rejectCount++;
            ResourceId id = ((UpdateTask)r).getResourceId();
            if (id != null) {
                UpdateThreadPoolExecutor.this.activeUpdates.remove(id);
            }
            Level level = count % 100 == 0 ? Level.INFO : Level.FINE;
            String msg = String.format("RN state update thread pool rejected %d requests. Pool size:%d Max pool size:%d", count, UpdateThreadPoolExecutor.this.getPoolSize(), UpdateThreadPoolExecutor.this.getMaximumPoolSize());
            UpdateThreadPoolExecutor.this.logger.log(msg, level, msg);
        }
    }
}

