/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.rgstate;

import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.RequestTimeoutException;
import oracle.kv.impl.api.RequestDispatcher;
import oracle.kv.impl.api.TopologyInfo;
import oracle.kv.impl.api.rgstate.RepNodeState;
import oracle.kv.impl.api.rgstate.UpdateThread;
import oracle.kv.impl.api.rgstate.UpdateThreadPoolExecutor;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.topo.change.TopologyChange;
import oracle.kv.impl.util.registry.RegistryUtils;

public class RepNodeStateUpdateThread
extends UpdateThread {
    private static final int PULL_TOPO_RN_RENEW_MS = 10000;
    private final int nopTimeoutMs = 1000;
    private volatile int refreshCount;
    private volatile int refreshExceptionCount;
    private volatile int pullFullTopologyCount;
    private volatile int pushFullTopologyCount;
    private static boolean updateState = true;
    private final AtomicReference<FullTopoInfo> pullFullTopoInfo;
    private final Semaphore fullPullInProgress = new Semaphore(1);

    public RepNodeStateUpdateThread(RequestDispatcher requestDispatcher, int periodMs, Thread.UncaughtExceptionHandler handler, Logger logger) {
        super(requestDispatcher, periodMs, handler, logger);
        this.pullFullTopoInfo = new AtomicReference<FullTopoInfo>(new FullTopoInfo(null, Integer.MIN_VALUE));
    }

    public int getRefreshCount() {
        return this.refreshCount;
    }

    public int getRefreshExceptionCount() {
        return this.refreshExceptionCount;
    }

    public static void setUpdateState(boolean updateState) {
        RepNodeStateUpdateThread.updateState = updateState;
    }

    public int getPullFullTopologyCount() {
        return this.pullFullTopologyCount;
    }

    public int getPushFullTopologyCount() {
        return this.pushFullTopologyCount;
    }

    public void pullFullTopology(RepNodeId rnId, int topoSeqNum) {
        FullTopoInfo curr;
        FullTopoInfo update = new FullTopoInfo(rnId, topoSeqNum);
        do {
            curr = this.pullFullTopoInfo.get();
            if (update.topoSeqNum < curr.topoSeqNum) {
                return;
            }
            if (update.topoSeqNum != curr.topoSeqNum || update.timeMs - curr.timeMs >= 10000L && !update.rnId.equals(curr.rnId)) continue;
            return;
        } while (!this.pullFullTopoInfo.compareAndSet(curr, update));
        this.logger.info("Current topo#: " + curr.topoSeqNum + " Need to pull full topo#: " + update.topoSeqNum + " Full topo source RN: " + rnId);
    }

    @Override
    protected void doUpdate() {
        Topology topology = this.requestDispatcher.getTopologyManager().getTopology();
        Collection<RepNodeState> rns = this.getRNs();
        this.threadPool.tunePoolSize(rns.size());
        for (RepNodeState rnState : rns) {
            if (this.shutdown.get()) {
                return;
            }
            if (this.needsResolution(rnState) || !updateState) continue;
            if (rnState.isObsoleteVLSNState()) {
                this.threadPool.execute(new RefreshRepNodeState(rnState));
            }
            int rnTopoSeqNum = rnState.getTopoSeqNum();
            if (topology == null || rnTopoSeqNum < 0 || rnTopoSeqNum >= topology.getSequenceNumber() || !this.checkTopologySignature(topology)) continue;
            this.threadPool.execute(new PushTopology(rnState, topology));
        }
        if (updateState && topology != null && this.pullFullTopoInfo.get().topoSeqNum > topology.getSequenceNumber()) {
            this.threadPool.execute(new PullTopology(this.pullFullTopoInfo.get()));
        }
    }

    private boolean checkTopologySignature(Topology topology) {
        RegistryUtils regUtils = this.requestDispatcher.getRegUtils();
        if (regUtils == null) {
            return true;
        }
        if (regUtils.getLoginManager() == null) {
            return true;
        }
        if (this.requestDispatcher.getDispatcherId().getType() != ResourceId.ResourceType.CLIENT) {
            return true;
        }
        return topology.getSignature() != null && topology.getSignature().length != 0;
    }

    private static class FullTopoInfo {
        final int topoSeqNum;
        final RepNodeId rnId;
        final long timeMs = System.currentTimeMillis();

        FullTopoInfo(RepNodeId rnId, int topoSeqNum) {
            this.rnId = rnId;
            this.topoSeqNum = topoSeqNum;
        }
    }

    private class PushTopology
    implements UpdateThreadPoolExecutor.UpdateTask {
        private final RepNodeState rnState;
        private final Topology topology;

        PushTopology(RepNodeState rns, Topology topology) {
            this.rnState = rns;
            this.topology = topology;
        }

        @Override
        public RepNodeId getResourceId() {
            return this.rnState.getRepNodeId();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int rnTopoSeqNum = this.rnState.getTopoSeqNum();
            if (rnTopoSeqNum >= this.topology.getSequenceNumber()) {
                RepNodeStateUpdateThread.this.logger.log(Level.FINE, "Push unnecessary, {0} is up-to-date", this.rnState.getRepNodeId());
                return;
            }
            String changesMsg = "Unknown failure";
            boolean success = false;
            Exception exception = null;
            try {
                RegistryUtils regUtils = RepNodeStateUpdateThread.this.requestDispatcher.getRegUtils();
                if (regUtils == null) {
                    return;
                }
                List<TopologyChange> changes = this.topology.getChanges(rnTopoSeqNum + 1);
                RepNodeId targetRNId = this.rnState.getRepNodeId();
                RepNodeAdminAPI rnAdmin = regUtils.getRepNodeAdmin(targetRNId);
                if (changes == null) {
                    changesMsg = "entire topology push to " + targetRNId + " updating from topo seq#: " + rnTopoSeqNum + " to " + this.topology.getSequenceNumber();
                    rnAdmin.updateMetadata(this.topology);
                    RepNodeStateUpdateThread.this.pushFullTopologyCount++;
                    this.rnState.updateTopoSeqNum(this.topology.getSequenceNumber());
                    success = true;
                } else {
                    int startSeqNum = changes.get(0).getSequenceNumber();
                    int endSeqNum = changes.get(changes.size() - 1).getSequenceNumber();
                    changesMsg = "topology changes [" + startSeqNum + " .. " + endSeqNum + "]" + " to " + targetRNId;
                    TopologyInfo topoInfo = new TopologyInfo(this.topology, changes);
                    int targetSeqNum = rnAdmin.updateMetadata(topoInfo);
                    this.rnState.resetTopoSeqNum(targetSeqNum);
                    if (targetSeqNum < endSeqNum) {
                        changesMsg = startSeqNum - targetSeqNum > 1 ? "Push to be retried for " + targetRNId + " at topo seq#: " + targetSeqNum + ", cached topo seq# was: " + rnTopoSeqNum : "Push failed to " + targetRNId + " at topo seq#: " + targetSeqNum + ", current topo seq#: " + this.topology.getSequenceNumber();
                        success = false;
                    } else {
                        success = true;
                    }
                }
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                if (success) {
                    RepNodeStateUpdateThread.this.logger.log(Level.FINE, "Pushed {0}", changesMsg);
                } else {
                    RepNodeStateUpdateThread.this.logOnFailure(this.rnState.getRepNodeId(), exception, "Failed pushing " + changesMsg);
                }
            }
        }
    }

    private class PullTopology
    implements UpdateThreadPoolExecutor.UpdateTask {
        final FullTopoInfo fullTopoInfo;

        public PullTopology(FullTopoInfo fullTopoInfo) {
            this.fullTopoInfo = fullTopoInfo;
        }

        @Override
        public RepNodeId getResourceId() {
            return this.fullTopoInfo.rnId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean success = false;
            Exception exception = null;
            if (!RepNodeStateUpdateThread.this.fullPullInProgress.tryAcquire()) {
                return;
            }
            try {
                RegistryUtils regUtils = RepNodeStateUpdateThread.this.requestDispatcher.getRegUtils();
                if (regUtils == null) {
                    return;
                }
                RepNodeAdminAPI rnAdmin = regUtils.getRepNodeAdmin(this.fullTopoInfo.rnId);
                Topology newTopo = rnAdmin.getTopology();
                RepNodeStateUpdateThread.this.requestDispatcher.getTopologyManager().update(newTopo);
                RepNodeStateUpdateThread.this.pullFullTopologyCount++;
                success = true;
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                RepNodeStateUpdateThread.this.fullPullInProgress.release();
                if (success) {
                    RepNodeStateUpdateThread.this.logger.info("Pulled full topology. Topology updated to: " + RepNodeStateUpdateThread.this.requestDispatcher.getTopologyManager().getTopology().getSequenceNumber());
                } else {
                    RepNodeStateUpdateThread.this.logOnFailure(this.fullTopoInfo.rnId, exception, " full topo pull from: + rnId +  for topo seqNum:" + this.fullTopoInfo.topoSeqNum);
                }
            }
        }
    }

    private class RefreshRepNodeState
    implements UpdateThreadPoolExecutor.UpdateTask {
        final RepNodeState rns;

        RefreshRepNodeState(RepNodeState rns) {
            this.rns = rns;
        }

        @Override
        public RepNodeId getResourceId() {
            return this.rns.getRepNodeId();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Exception exception = null;
            Level level = Level.SEVERE;
            try {
                RepNodeStateUpdateThread.this.requestDispatcher.executeNOP(this.rns, 1000, null);
                RepNodeStateUpdateThread.this.refreshCount++;
            }
            catch (ConnectException e) {
                exception = e;
                level = Level.FINE;
            }
            catch (RemoteException e) {
                exception = e;
                level = Level.INFO;
            }
            catch (RequestTimeoutException e) {
                exception = e;
                level = Level.INFO;
            }
            catch (Exception e) {
                exception = e;
                level = Level.WARNING;
            }
            finally {
                if (exception != null) {
                    RepNodeStateUpdateThread.this.refreshExceptionCount++;
                    String msg = "Exception in RefreshRepNodeStateThread when contacting:" + this.rns.getRepNodeId() + " Exception " + exception.getClass().getName();
                    if (level.intValue() >= Level.WARNING.intValue()) {
                        RepNodeStateUpdateThread.this.logger.log(Level.WARNING, msg, exception);
                    } else {
                        RepNodeStateUpdateThread.this.logBrief(this.rns.getRepNodeId(), level, msg, exception);
                    }
                }
            }
        }
    }
}

