/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.query;

import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;
import oracle.kv.StatementResult;
import oracle.kv.impl.api.query.BoundStatementImpl;
import oracle.kv.impl.api.query.PreparedStatementImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.TableAPIImpl;
import oracle.kv.impl.api.table.TupleValue;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.runtime.ClientTableIter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.query.ExecuteOptions;
import oracle.kv.stats.DetailedMetrics;
import oracle.kv.table.FieldValue;
import oracle.kv.table.RecordDef;
import oracle.kv.table.RecordValue;
import oracle.kv.table.TableIterator;

public class QueryStatementResultImpl
implements StatementResult {
    private QueryResultIterator iterator;
    private boolean closed;

    public QueryStatementResultImpl(TableAPIImpl tableAPI, ExecuteOptions options, PreparedStatementImpl stmt) {
        if (stmt.hasExternalVars()) {
            throw new QueryException("The query contains external variables, none of which has been bound. Create a BoundStatement to bind the variables");
        }
        this.init(tableAPI, options, stmt, null, null, null);
    }

    public QueryStatementResultImpl(TableAPIImpl tableAPI, ExecuteOptions options, BoundStatementImpl stmt) {
        PreparedStatementImpl ps = stmt.getPreparedStmt();
        FieldValue[] externalVars = ps.getExternalVarsArray(stmt.getVariables());
        this.init(tableAPI, options, ps, externalVars, null, null);
    }

    public QueryStatementResultImpl(TableAPIImpl tableAPI, ExecuteOptions options, PreparedStatementImpl stmt, Set<Integer> partitions, Set<RepGroupId> shards) {
        if (stmt.hasExternalVars()) {
            throw new QueryException("The query contains external variables, none of which has been bound. Create a BoundStatement to bind the variables");
        }
        this.init(tableAPI, options, stmt, null, partitions, shards);
    }

    void init(TableAPIImpl tableAPI, ExecuteOptions options, PreparedStatementImpl ps, FieldValue[] externalVars, Set<Integer> partitions, Set<RepGroupId> shards) {
        PlanIter iter = ps.getQueryPlan();
        RecordDef resultDef = ps.getResultDef();
        RuntimeControlBlock rcb = new RuntimeControlBlock(tableAPI.getStore().getLogger(), iter, ps.getNumIterators(), ps.getNumRegisters(), tableAPI.getTableMetadata(), options, externalVars, null, null, 0L, new ClientTableIter.ClientTableIterFactory(tableAPI), tableAPI.getStore(), partitions, shards);
        this.iterator = new QueryResultIterator(rcb, iter, resultDef);
        this.closed = false;
    }

    @Override
    public void close() {
        this.iterator.close();
        this.closed = true;
    }

    @Override
    public RecordDef getResultDef() {
        if (this.closed) {
            throw new IllegalStateException("Statement result already closed.");
        }
        return this.iterator.getResultDef();
    }

    @Override
    public TableIterator<RecordValue> iterator() {
        if (this.closed) {
            throw new IllegalStateException("Statement result already closed.");
        }
        return this.iterator;
    }

    @Override
    public int getPlanId() {
        return 0;
    }

    @Override
    public String getInfo() {
        return null;
    }

    @Override
    public String getInfoAsJson() {
        return null;
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    @Override
    public boolean isDone() {
        return !this.iterator.hasNext();
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public String getResult() {
        return null;
    }

    @Override
    public StatementResult.Kind getKind() {
        return StatementResult.Kind.QUERY;
    }

    private class QueryResultIterator
    implements TableIterator<RecordValue> {
        private final RuntimeControlBlock rcb;
        private final PlanIter rootIter;
        private final RecordDef resultDef;
        private boolean hasNext;

        QueryResultIterator(RuntimeControlBlock rcb, PlanIter iter, RecordDef resultDef) {
            this.rcb = rcb;
            this.rootIter = iter;
            this.resultDef = resultDef;
            try {
                this.rootIter.open(rcb);
                this.hasNext = this.rootIter.next(rcb);
            }
            catch (QueryStateException qse) {
                Logger logger = rcb.getStore().getLogger();
                if (logger != null) {
                    logger.warning(qse.toString());
                }
                throw new IllegalStateException(qse.toString());
            }
            catch (QueryException qe) {
                throw qe.getIllegalArgument();
            }
        }

        RecordDef getResultDef() {
            return this.resultDef;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public RecordValue next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            RecordValueImpl record = null;
            try {
                FieldValueImpl resVal = this.rcb.getRegVal(this.rootIter.getResultReg());
                if (resVal.isTuple()) {
                    assert (this.resultDef.equals(resVal.getDefinition()));
                    record = ((TupleValue)resVal).toRecord();
                } else if (resVal.isRecord()) {
                    record = (RecordValueImpl)resVal;
                } else {
                    record = (RecordValueImpl)this.resultDef.createRecord();
                    record.put(0, (FieldValue)resVal);
                }
                this.hasNext = this.rootIter.next(this.rcb);
            }
            catch (QueryStateException qse) {
                Logger logger = this.rcb.getStore().getLogger();
                if (logger != null) {
                    logger.warning(qse.toString());
                }
                throw new IllegalStateException(qse.toString());
            }
            catch (QueryException qe) {
                throw qe.getIllegalArgument();
            }
            return record;
        }

        @Override
        public void close() {
            if (!this.isClosed()) {
                this.rootIter.close(this.rcb);
                this.hasNext = false;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<DetailedMetrics> getPartitionMetrics() {
            if (this.rcb.getTableIterator() != null) {
                return this.rcb.getTableIterator().getShardMetrics();
            }
            return Collections.emptyList();
        }

        @Override
        public List<DetailedMetrics> getShardMetrics() {
            if (this.rcb.getTableIterator() != null) {
                return this.rcb.getTableIterator().getShardMetrics();
            }
            return Collections.emptyList();
        }

        public boolean isClosed() {
            return this.rootIter.isClosed(this.rcb);
        }
    }
}

