/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.parallelscan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import oracle.kv.Consistency;
import oracle.kv.Direction;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.Request;
import oracle.kv.impl.api.TopologyManager;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.parallelscan.BaseParallelScanIteratorImpl;
import oracle.kv.impl.api.parallelscan.DetailedMetricsImpl;
import oracle.kv.impl.api.table.TableAPIImpl;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.stats.DetailedMetrics;
import oracle.kv.table.TableIterator;
import oracle.kv.table.TableIteratorOptions;

public abstract class ShardScanIterator<K>
extends BaseParallelScanIteratorImpl<K>
implements TableIterator<K>,
TopologyManager.PostUpdateListener {
    protected final Consistency consistency;
    private final int nGroups;
    private final int partitionMapHashCode;
    protected final int batchSize;
    private final Map<RepGroupId, DetailedMetricsImpl> shardMetrics = new HashMap<RepGroupId, DetailedMetricsImpl>();

    public ShardScanIterator(KVStoreImpl store, TableIteratorOptions iterateOptions, Set<RepGroupId> shardSet) {
        this.itrDirection = iterateOptions != null ? iterateOptions.getDirection() : Direction.FORWARD;
        this.storeImpl = store;
        this.consistency = TableAPIImpl.getConsistency(iterateOptions);
        long timeout = TableAPIImpl.getTimeout(iterateOptions);
        long l = this.requestTimeoutMs = timeout == 0L ? (long)store.getDefaultRequestTimeoutMs() : TableAPIImpl.getTimeoutUnit(iterateOptions).toMillis(timeout);
        if (this.requestTimeoutMs <= 0L) {
            throw new IllegalArgumentException("Timeout must be > 0 ms");
        }
        this.batchSize = TableAPIImpl.getBatchSize(iterateOptions);
        this.logger = store.getLogger();
        TopologyManager topoManager = store.getDispatcher().getTopologyManager();
        Topology topology = topoManager.getTopology();
        Set<RepGroupId> groups = shardSet == null ? topology.getRepGroupIds() : shardSet;
        this.nGroups = groups.size();
        if (this.nGroups == 0) {
            throw new IllegalStateException("Store not yet initialized");
        }
        this.partitionMapHashCode = topology.getPartitionMap().hashCode();
        this.taskExecutor = store.getTaskExecutor(this.nGroups * 2);
        this.streams = new TreeSet();
        for (RepGroupId groupId : groups) {
            ShardStream stream = this.createStream(groupId);
            this.streams.add(stream);
            stream.submit();
        }
        topoManager.addPostUpdateListener(this, true);
    }

    protected ShardStream createStream(RepGroupId groupId) {
        return new ShardStream(groupId, null, null);
    }

    @Override
    public List<DetailedMetrics> getPartitionMetrics() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DetailedMetrics> getShardMetrics() {
        Map<RepGroupId, DetailedMetricsImpl> map = this.shardMetrics;
        synchronized (map) {
            ArrayList<DetailedMetrics> ret = new ArrayList<DetailedMetrics>(this.shardMetrics.size());
            ret.addAll(this.shardMetrics.values());
            return ret;
        }
    }

    protected abstract InternalOperation createOp(byte[] var1, byte[] var2);

    protected byte[] extractResumeSecondaryKey(Result result) {
        return result.getSecondaryResumeKey();
    }

    @Override
    protected void close(Exception reason) {
        this.close(reason, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(Exception reason, boolean remove) {
        List<Runnable> unfinishedBusiness;
        ShardScanIterator shardScanIterator = this;
        synchronized (shardScanIterator) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.closeException = reason;
        }
        if (remove) {
            this.storeImpl.getDispatcher().getTopologyManager().removePostUpdateListener(this);
        }
        if (!(unfinishedBusiness = this.taskExecutor.shutdownNow()).isEmpty()) {
            this.logger.log(Level.FINE, "IndexScan executor didn''t shutdown cleanly. {0} tasks remaining.", unfinishedBusiness.size());
        }
        this.next = null;
    }

    @Override
    public boolean postUpdate(Topology topology) {
        if (this.closed) {
            return true;
        }
        int newGroupSize = topology.getRepGroupIds().size();
        if (this.nGroups > newGroupSize) {
            this.close(new UnsupportedOperationException("The number of shards has decreased during the iteration"), false);
        }
        if (this.nGroups < newGroupSize) {
            this.close(new UnsupportedOperationException("The number of shards has increased during the iteration"), false);
        }
        if (this.partitionMapHashCode != topology.getPartitionMap().hashCode()) {
            this.close(new UnsupportedOperationException("The location of one or more partitions has changed during the iteration"), false);
        }
        return this.closed;
    }

    protected class ShardStream
    extends BaseParallelScanIteratorImpl.Stream {
        protected final RepGroupId groupId;
        protected byte[] resumeSecondaryKey;
        protected byte[] resumePrimaryKey;

        protected ShardStream(RepGroupId groupId, byte[] resumeSecondaryKey, byte[] resumePrimaryKey) {
            this.groupId = groupId;
            this.resumeSecondaryKey = resumeSecondaryKey;
            this.resumePrimaryKey = resumePrimaryKey;
        }

        protected RepGroupId getGroupId() {
            return this.groupId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void updateDetailedMetrics(long timeInMs, long recordCount) {
            DetailedMetricsImpl dmi;
            Map map = ShardScanIterator.this.shardMetrics;
            synchronized (map) {
                dmi = (DetailedMetricsImpl)ShardScanIterator.this.shardMetrics.get(this.groupId);
                if (dmi == null) {
                    dmi = new DetailedMetricsImpl(this.groupId.toString(), timeInMs, recordCount);
                    ShardScanIterator.this.shardMetrics.put(this.groupId, dmi);
                    return;
                }
            }
            dmi.inc(timeInMs, recordCount);
        }

        @Override
        protected Request makeReadRequest() {
            return ShardScanIterator.this.storeImpl.makeReadRequest(ShardScanIterator.this.createOp(this.resumeSecondaryKey, this.resumePrimaryKey), this.groupId, ShardScanIterator.this.consistency, ShardScanIterator.this.requestTimeoutMs, TimeUnit.MILLISECONDS);
        }

        @Override
        protected void setResumeKey(Result result) {
            this.resumeSecondaryKey = ShardScanIterator.this.extractResumeSecondaryKey(result);
            this.resumePrimaryKey = result.getPrimaryResumeKey();
        }

        public String toString() {
            return "ShardStream[" + this.groupId + ", " + this.getStatus() + "]";
        }
    }
}

