/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.util.UserDataControl;

public abstract class SingleKeyOperation
extends InternalOperation {
    private final byte[] keyBytes;

    public SingleKeyOperation(InternalOperation.OpCode opCode, byte[] keyBytes) {
        super(opCode);
        this.keyBytes = keyBytes;
    }

    SingleKeyOperation(InternalOperation.OpCode opCode, DataInput in, short serialVersion) throws IOException {
        super(opCode, in, serialVersion);
        short keyLen = in.readShort();
        this.keyBytes = new byte[keyLen];
        in.readFully(this.keyBytes);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeShort(this.keyBytes.length);
        out.write(this.keyBytes);
    }

    public byte[] getKeyBytes() {
        return this.keyBytes;
    }

    abstract long getTableId();

    @Override
    public String toString() {
        return super.toString() + " Key: " + UserDataControl.displayKey(this.keyBytes);
    }
}

