/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.util.FastExternalizable;

public class ResultKey
implements FastExternalizable {
    private final byte[] keyBytes;
    private final long expirationTime;

    public ResultKey(byte[] keyBytes, long expirationTime) {
        this.keyBytes = keyBytes;
        this.expirationTime = expirationTime;
    }

    public ResultKey(byte[] keyBytes) {
        this(keyBytes, 0L);
    }

    public ResultKey(DataInput in, short serialVersion) throws IOException {
        short keyLen = in.readShort();
        this.keyBytes = new byte[keyLen];
        in.readFully(this.keyBytes);
        this.expirationTime = Result.readExpirationTime(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        out.writeShort(this.keyBytes.length);
        out.write(this.keyBytes);
        Result.writeExpirationTime(out, this.expirationTime, serialVersion);
    }

    public byte[] getKeyBytes() {
        return this.keyBytes;
    }

    public boolean hasExpirationTime() {
        return this.expirationTime != 0L;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }
}

