/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.Version;
import oracle.kv.impl.api.ops.ResultKeyValueVersion;

public class ResultIndexRows
extends ResultKeyValueVersion {
    private final byte[] indexKeyBytes;

    public ResultIndexRows(byte[] indexKeyBytes, byte[] primaryKeyBytes, byte[] valueBytes, Version version, long expirationTime) {
        super(primaryKeyBytes, valueBytes, version, expirationTime);
        this.indexKeyBytes = indexKeyBytes;
    }

    public ResultIndexRows(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        if (serialVersion >= 6) {
            short keyLen = in.readShort();
            this.indexKeyBytes = new byte[keyLen];
            in.readFully(this.indexKeyBytes);
        } else {
            this.indexKeyBytes = null;
        }
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        if (serialVersion >= 6) {
            out.writeShort(this.indexKeyBytes.length);
            out.write(this.indexKeyBytes);
        }
    }

    public byte[] getIndexKeyBytes() {
        return this.indexKeyBytes;
    }
}

