/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.util.FastExternalizable;

public class ResultIndexKeys
implements FastExternalizable {
    private final byte[] primaryKeyBytes;
    private final byte[] indexKeyBytes;
    private final long expirationTime;

    public ResultIndexKeys(byte[] primaryKeyBytes, byte[] indexKeyBytes, long expirationTime) {
        this.primaryKeyBytes = primaryKeyBytes;
        this.indexKeyBytes = indexKeyBytes;
        this.expirationTime = expirationTime;
    }

    public ResultIndexKeys(DataInput in, short serialVersion) throws IOException {
        short keyLen = in.readShort();
        this.primaryKeyBytes = new byte[keyLen];
        in.readFully(this.primaryKeyBytes);
        keyLen = in.readShort();
        this.indexKeyBytes = new byte[keyLen];
        in.readFully(this.indexKeyBytes);
        this.expirationTime = Result.readExpirationTime(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        out.writeShort(this.primaryKeyBytes.length);
        out.write(this.primaryKeyBytes);
        out.writeShort(this.indexKeyBytes.length);
        out.write(this.indexKeyBytes);
        Result.writeExpirationTime(out, this.expirationTime, serialVersion);
    }

    public byte[] getPrimaryKeyBytes() {
        return this.primaryKeyBytes;
    }

    public byte[] getIndexKeyBytes() {
        return this.indexKeyBytes;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }
}

