/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.kv.Operation;
import oracle.kv.OperationExecutionException;
import oracle.kv.OperationResult;
import oracle.kv.Value;
import oracle.kv.Version;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.InternalOperationHandler;
import oracle.kv.impl.api.ops.ResultIndexKeys;
import oracle.kv.impl.api.ops.ResultIndexRows;
import oracle.kv.impl.api.ops.ResultKey;
import oracle.kv.impl.api.ops.ResultKeyValueVersion;
import oracle.kv.impl.api.ops.ResultValue;
import oracle.kv.impl.api.ops.ResultValueVersion;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldDefSerialization;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FieldValueSerialization;
import oracle.kv.impl.util.FastExternalizable;

public abstract class Result
implements OperationResult,
FastExternalizable {
    private final InternalOperation.OpCode opCode;

    private Result(InternalOperation.OpCode op) {
        this.opCode = op;
        assert (op.checkResultType(this)) : "Incorrect type " + this.getClass().getName() + " for " + op;
    }

    Result(InternalOperation.OpCode op, DataInput in, short serialVersion) {
        this(op);
    }

    public static Result readFastExternal(DataInput in, short serialVersion) throws IOException {
        InternalOperation.OpCode op = InternalOperation.OpCode.readFastExternal(in, serialVersion);
        return op.readResult(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        this.opCode.writeFastExternal(out, serialVersion);
    }

    @Override
    public abstract boolean getSuccess();

    public byte[] getPrimaryResumeKey() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a primary resume key");
    }

    public byte[] getSecondaryResumeKey() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a secondary resume key");
    }

    @Override
    public Value getPreviousValue() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a Value");
    }

    @Override
    public Version getPreviousVersion() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a previous Version");
    }

    @Override
    public Version getNewVersion() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a new Version");
    }

    @Override
    public long getNewExpirationTime() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain an " + "expiration time");
    }

    @Override
    public long getPreviousExpirationTime() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a " + "previous expiration time");
    }

    public int getNDeletions() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a boolean");
    }

    public OperationExecutionException getExecuteException(List<Operation> ops) {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain an OperationExecutionException");
    }

    public List<OperationResult> getExecuteResult() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a ExecuteResult");
    }

    public List<ResultKeyValueVersion> getKeyValueVersionList() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a ResultKeyValueVersion list");
    }

    public List<ResultKey> getKeyList() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a key list");
    }

    public List<ResultIndexKeys> getIndexKeyList() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a ResultIndexKeys list");
    }

    public List<ResultIndexRows> getIndexRowList() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a ResultIndexRows list");
    }

    public List<FieldValueImpl> getQueryResults() {
        throw new IllegalStateException("result of type: " + this.getClass() + " is not a query result");
    }

    public boolean hasMoreElements() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain an iteration result");
    }

    public int getResumeParentKeyIndex() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a resume parent key index");
    }

    public int getNumRecords() {
        return 1;
    }

    static void writeExpirationTime(DataOutput out, long expirationTime, short serialVersion) throws IOException {
        if (serialVersion >= 10) {
            if (expirationTime == 0L) {
                out.write(0);
            } else {
                out.write(1);
                out.writeLong(expirationTime);
            }
        }
    }

    static long readExpirationTime(DataInput in, short serialVersion) throws IOException {
        if (serialVersion >= 10 && in.readByte() != 0) {
            return in.readLong();
        }
        return 0L;
    }

    public static class QueryResult
    extends Result {
        private final List<FieldValueImpl> results;
        private final FieldDefImpl resultDef;
        private final boolean mayReturnNULL;
        private final boolean moreElements;
        private final byte[] primaryResumeKey;
        private final byte[] secondaryResumeKey;

        QueryResult(InternalOperation.OpCode opCode, List<FieldValueImpl> results, FieldDefImpl resultDef, boolean mayReturnNULL, boolean moreElements, byte[] primaryResumeKey, byte[] secondaryResumeKey) {
            super(opCode);
            this.results = results;
            this.resultDef = resultDef;
            this.mayReturnNULL = mayReturnNULL;
            this.moreElements = moreElements;
            this.primaryResumeKey = primaryResumeKey;
            this.secondaryResumeKey = secondaryResumeKey;
        }

        QueryResult(InternalOperation.OpCode opCode, DataInput in, short serialVersion) throws IOException {
            super(opCode, in, serialVersion);
            try {
                int i;
                this.resultDef = FieldDefSerialization.readFieldDef(in, serialVersion);
                this.mayReturnNULL = serialVersion >= 12 ? in.readBoolean() : false;
                FieldDefImpl valDef = this.resultDef.isWildcard() ? null : this.resultDef;
                int listSize = in.readInt();
                this.results = new ArrayList<FieldValueImpl>(listSize);
                if (this.mayReturnNULL) {
                    for (i = 0; i < listSize; ++i) {
                        FieldValueImpl val = (FieldValueImpl)FieldValueSerialization.readFieldValue(valDef, in, serialVersion);
                        this.results.add(val);
                    }
                } else {
                    for (i = 0; i < listSize; ++i) {
                        FieldValueImpl val = (FieldValueImpl)FieldValueSerialization.readFieldValue(valDef, null, in, serialVersion);
                        this.results.add(val);
                    }
                }
                this.moreElements = in.readBoolean();
                if (this.moreElements) {
                    short keyLen = in.readShort();
                    if (keyLen > 0) {
                        this.primaryResumeKey = new byte[keyLen];
                        in.readFully(this.primaryResumeKey);
                    } else {
                        this.primaryResumeKey = null;
                    }
                    keyLen = in.readShort();
                    if (keyLen > 0) {
                        this.secondaryResumeKey = new byte[keyLen];
                        in.readFully(this.secondaryResumeKey);
                    } else {
                        this.secondaryResumeKey = null;
                    }
                } else {
                    this.primaryResumeKey = null;
                    this.secondaryResumeKey = null;
                }
            }
            catch (IOException e) {
                System.out.println("Failed to deserialize result");
                e.printStackTrace();
                throw e;
            }
            catch (ClassCastException e) {
                System.out.println("Failed to deserialize result");
                e.printStackTrace();
                throw e;
            }
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            try {
                super.writeFastExternal(out, serialVersion);
                FieldDefSerialization.writeFieldDef(this.resultDef, out, serialVersion);
                if (serialVersion >= 12) {
                    out.writeBoolean(this.mayReturnNULL);
                }
                out.writeInt(this.results.size());
                boolean isWildcard = this.resultDef.isWildcard();
                if (this.mayReturnNULL) {
                    for (FieldValueImpl res : this.results) {
                        FieldValueSerialization.writeFieldValue(res, isWildcard, out, serialVersion);
                    }
                } else {
                    for (FieldValueImpl res : this.results) {
                        FieldValueSerialization.writeFieldValue(res, isWildcard, true, out, serialVersion);
                    }
                }
                out.writeBoolean(this.moreElements);
                if (this.moreElements) {
                    assert (this.primaryResumeKey != null || this.secondaryResumeKey != null);
                    if (this.primaryResumeKey != null) {
                        out.writeShort(this.primaryResumeKey.length);
                        out.write(this.primaryResumeKey);
                    } else {
                        out.writeShort(0);
                    }
                    if (this.secondaryResumeKey != null) {
                        out.writeShort(this.secondaryResumeKey.length);
                        out.write(this.secondaryResumeKey);
                    } else {
                        out.writeShort(0);
                    }
                }
            }
            catch (IOException e) {
                System.out.println("Failed to serialize result");
                e.printStackTrace();
                throw e;
            }
            catch (ClassCastException e) {
                System.out.println("Failed to deserialize result");
                e.printStackTrace();
                throw e;
            }
        }

        @Override
        public boolean getSuccess() {
            return this.results.size() > 0;
        }

        @Override
        public List<FieldValueImpl> getQueryResults() {
            return this.results;
        }

        @Override
        public boolean hasMoreElements() {
            return this.moreElements;
        }

        @Override
        public int getNumRecords() {
            return this.results.size();
        }

        @Override
        public byte[] getPrimaryResumeKey() {
            return this.primaryResumeKey;
        }

        @Override
        public byte[] getSecondaryResumeKey() {
            return this.secondaryResumeKey;
        }
    }

    static class BulkGetKeysIterateResult
    extends KeysIterateResult {
        private final int resumeParentKeyIndex;

        BulkGetKeysIterateResult(InternalOperation.OpCode opCode, List<ResultKey> elements, boolean moreElements, int lastParentKeyIndex) {
            super(opCode, elements, moreElements);
            this.resumeParentKeyIndex = lastParentKeyIndex;
        }

        BulkGetKeysIterateResult(InternalOperation.OpCode opCode, DataInput in, short serialVersion) throws IOException {
            super(opCode, in, serialVersion);
            this.resumeParentKeyIndex = in.readInt();
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            out.writeInt(this.resumeParentKeyIndex);
        }

        @Override
        public int getResumeParentKeyIndex() {
            return this.resumeParentKeyIndex;
        }
    }

    static class BulkGetIterateResult
    extends IterateResult {
        private final int resumeParentKeyIndex;

        BulkGetIterateResult(InternalOperation.OpCode opCode, List<ResultKeyValueVersion> elements, boolean moreElements, int resumeParentKeyIndex) {
            super(opCode, elements, moreElements);
            this.resumeParentKeyIndex = resumeParentKeyIndex;
        }

        BulkGetIterateResult(InternalOperation.OpCode opCode, DataInput in, short serialVersion) throws IOException {
            super(opCode, in, serialVersion);
            this.resumeParentKeyIndex = in.readInt();
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            out.writeInt(this.resumeParentKeyIndex);
        }

        @Override
        public int getResumeParentKeyIndex() {
            return this.resumeParentKeyIndex;
        }
    }

    static class IndexRowsIterateResult
    extends Result {
        private final List<ResultIndexRows> elements;
        private final boolean moreElements;

        IndexRowsIterateResult(InternalOperation.OpCode opCode, List<ResultIndexRows> elements, boolean moreElements) {
            super(opCode);
            this.elements = elements;
            this.moreElements = moreElements;
        }

        IndexRowsIterateResult(InternalOperation.OpCode opCode, DataInput in, short serialVersion) throws IOException {
            super(opCode, in, serialVersion);
            int listSize = in.readInt();
            this.elements = new ArrayList<ResultIndexRows>(listSize);
            for (int i = 0; i < listSize; ++i) {
                this.elements.add(new ResultIndexRows(in, serialVersion));
            }
            this.moreElements = in.readBoolean();
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            out.writeInt(this.elements.size());
            for (ResultIndexRows elem : this.elements) {
                elem.writeFastExternal(out, serialVersion);
            }
            out.writeBoolean(this.moreElements);
        }

        @Override
        public boolean getSuccess() {
            return this.elements.size() > 0;
        }

        @Override
        public List<ResultIndexRows> getIndexRowList() {
            return this.elements;
        }

        @Override
        public boolean hasMoreElements() {
            return this.moreElements;
        }

        @Override
        public int getNumRecords() {
            return this.elements.size();
        }

        @Override
        public byte[] getPrimaryResumeKey() {
            if (!this.moreElements || this.elements == null || this.elements.isEmpty()) {
                return null;
            }
            return this.elements.get(this.elements.size() - 1).getKeyBytes();
        }

        @Override
        public byte[] getSecondaryResumeKey() {
            if (!this.moreElements || this.elements == null || this.elements.isEmpty()) {
                return null;
            }
            return this.elements.get(this.elements.size() - 1).getIndexKeyBytes();
        }
    }

    static class IndexKeysIterateResult
    extends Result {
        private final List<ResultIndexKeys> elements;
        private final boolean moreElements;

        IndexKeysIterateResult(InternalOperation.OpCode opCode, List<ResultIndexKeys> elements, boolean moreElements) {
            super(opCode);
            this.elements = elements;
            this.moreElements = moreElements;
        }

        IndexKeysIterateResult(InternalOperation.OpCode opCode, DataInput in, short serialVersion) throws IOException {
            super(opCode, in, serialVersion);
            int listSize = in.readInt();
            this.elements = new ArrayList<ResultIndexKeys>(listSize);
            for (int i = 0; i < listSize; ++i) {
                this.elements.add(new ResultIndexKeys(in, serialVersion));
            }
            this.moreElements = in.readBoolean();
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            out.writeInt(this.elements.size());
            for (ResultIndexKeys elem : this.elements) {
                elem.writeFastExternal(out, serialVersion);
            }
            out.writeBoolean(this.moreElements);
        }

        @Override
        public boolean getSuccess() {
            return this.elements.size() > 0;
        }

        @Override
        public List<ResultIndexKeys> getIndexKeyList() {
            return this.elements;
        }

        @Override
        public boolean hasMoreElements() {
            return this.moreElements;
        }

        @Override
        public int getNumRecords() {
            return this.elements.size();
        }

        @Override
        public byte[] getPrimaryResumeKey() {
            if (!this.moreElements || this.elements == null || this.elements.isEmpty()) {
                return null;
            }
            return this.elements.get(this.elements.size() - 1).getPrimaryKeyBytes();
        }

        @Override
        public byte[] getSecondaryResumeKey() {
            if (!this.moreElements || this.elements == null || this.elements.isEmpty()) {
                return null;
            }
            return this.elements.get(this.elements.size() - 1).getIndexKeyBytes();
        }
    }

    static class KeysIterateResult
    extends Result {
        private final List<ResultKey> elements;
        private final boolean moreElements;

        KeysIterateResult(InternalOperation.OpCode opCode, List<ResultKey> elements, boolean moreElements) {
            super(opCode);
            this.elements = elements;
            this.moreElements = moreElements;
        }

        KeysIterateResult(InternalOperation.OpCode opCode, DataInput in, short serialVersion) throws IOException {
            super(opCode, in, serialVersion);
            int listSize = in.readInt();
            this.elements = new ArrayList<ResultKey>(listSize);
            for (int i = 0; i < listSize; ++i) {
                this.elements.add(new ResultKey(in, serialVersion));
            }
            this.moreElements = in.readBoolean();
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            out.writeInt(this.elements.size());
            for (ResultKey rkey : this.elements) {
                rkey.writeFastExternal(out, serialVersion);
            }
            out.writeBoolean(this.moreElements);
        }

        @Override
        public boolean getSuccess() {
            return this.elements.size() > 0;
        }

        @Override
        public List<ResultKey> getKeyList() {
            return this.elements;
        }

        @Override
        public boolean hasMoreElements() {
            return this.moreElements;
        }

        @Override
        public int getNumRecords() {
            return this.elements.size();
        }

        @Override
        public byte[] getPrimaryResumeKey() {
            if (!this.moreElements || this.elements == null || this.elements.isEmpty()) {
                return null;
            }
            return this.elements.get(this.elements.size() - 1).getKeyBytes();
        }
    }

    static class IterateResult
    extends Result {
        private final List<ResultKeyValueVersion> elements;
        private final boolean moreElements;

        IterateResult(InternalOperation.OpCode opCode, List<ResultKeyValueVersion> elements, boolean moreElements) {
            super(opCode);
            this.elements = elements;
            this.moreElements = moreElements;
        }

        IterateResult(InternalOperation.OpCode opCode, DataInput in, short serialVersion) throws IOException {
            super(opCode, in, serialVersion);
            int listSize = in.readInt();
            this.elements = new ArrayList<ResultKeyValueVersion>(listSize);
            for (int i = 0; i < listSize; ++i) {
                this.elements.add(new ResultKeyValueVersion(in, serialVersion));
            }
            this.moreElements = in.readBoolean();
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            out.writeInt(this.elements.size());
            for (ResultKeyValueVersion elem : this.elements) {
                elem.writeFastExternal(out, serialVersion);
            }
            out.writeBoolean(this.moreElements);
        }

        @Override
        public boolean getSuccess() {
            return this.elements.size() > 0;
        }

        @Override
        public List<ResultKeyValueVersion> getKeyValueVersionList() {
            return this.elements;
        }

        @Override
        public boolean hasMoreElements() {
            return this.moreElements;
        }

        @Override
        public int getNumRecords() {
            return this.elements.size();
        }

        @Override
        public byte[] getPrimaryResumeKey() {
            if (!this.moreElements || this.elements == null || this.elements.isEmpty()) {
                return null;
            }
            return this.elements.get(this.elements.size() - 1).getKeyBytes();
        }
    }

    public static class PutBatchResult
    extends Result {
        private int numKVPairs;
        private List<Integer> keysPresent;

        PutBatchResult(int numKVPairs, List<Integer> keysPresent) {
            super(InternalOperation.OpCode.PUT_BATCH);
            this.numKVPairs = numKVPairs;
            this.keysPresent = keysPresent;
        }

        PutBatchResult(InternalOperation.OpCode op, DataInput in, short serialVersion) throws IOException {
            super(op, in, serialVersion);
            this.numKVPairs = in.readInt();
            int count = in.readInt();
            if (count == 0) {
                this.keysPresent = Collections.emptyList();
                return;
            }
            this.keysPresent = new ArrayList<Integer>(count);
            for (int i = 0; i < count; ++i) {
                this.keysPresent.add(in.readInt());
            }
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            out.writeInt(this.numKVPairs);
            int count = this.keysPresent.size();
            out.writeInt(count);
            for (int position : this.keysPresent) {
                out.writeInt(position);
            }
        }

        @Override
        public boolean getSuccess() {
            return true;
        }

        public List<Integer> getKeysPresent() {
            return this.keysPresent;
        }

        @Override
        public int getNumRecords() {
            return this.numKVPairs - this.keysPresent.size();
        }
    }

    static class ExecuteResult
    extends Result {
        private final boolean success;
        private final List<Result> successResults;
        private final int failureIndex;
        private final Result failureResult;

        ExecuteResult(InternalOperation.OpCode opCode, List<Result> successResults) {
            super(opCode);
            this.successResults = successResults;
            this.failureIndex = -1;
            this.failureResult = null;
            this.success = true;
        }

        ExecuteResult(InternalOperation.OpCode opCode, int failureIndex, Result failureResult) {
            super(opCode);
            this.failureIndex = failureIndex;
            this.failureResult = failureResult;
            this.successResults = null;
            this.success = false;
        }

        ExecuteResult(InternalOperation.OpCode opCode, DataInput in, short serialVersion) throws IOException {
            super(opCode, in, serialVersion);
            this.success = in.readBoolean();
            if (this.success) {
                int listSize = in.readInt();
                this.successResults = new ArrayList<Result>(listSize);
                for (int i = 0; i < listSize; ++i) {
                    Result result = Result.readFastExternal(in, serialVersion);
                    this.successResults.add(result);
                }
                this.failureIndex = -1;
                this.failureResult = null;
            } else {
                this.failureIndex = in.readInt();
                this.failureResult = Result.readFastExternal(in, serialVersion);
                this.successResults = new ArrayList<Result>();
            }
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            out.writeBoolean(this.success);
            if (this.success) {
                out.writeInt(this.successResults.size());
                for (Result result : this.successResults) {
                    result.writeFastExternal(out, serialVersion);
                }
            } else {
                out.writeInt(this.failureIndex);
                this.failureResult.writeFastExternal(out, serialVersion);
            }
        }

        @Override
        public boolean getSuccess() {
            return this.success;
        }

        @Override
        public OperationExecutionException getExecuteException(List<Operation> ops) {
            if (this.success) {
                return null;
            }
            return new OperationExecutionException(ops.get(this.failureIndex), this.failureIndex, this.failureResult);
        }

        @Override
        public List<OperationResult> getExecuteResult() {
            if (!this.success) {
                return null;
            }
            return Collections.unmodifiableList(this.successResults);
        }

        @Override
        public int getNumRecords() {
            if (!this.success) {
                return 0;
            }
            return this.successResults.size();
        }
    }

    static class NOPResult
    extends Result {
        NOPResult(DataInput in, short serialVersion) {
            super(InternalOperation.OpCode.NOP, in, serialVersion);
        }

        NOPResult() {
            super(InternalOperation.OpCode.NOP);
        }

        @Override
        public boolean getSuccess() {
            return true;
        }

        @Override
        public int getNumRecords() {
            return 0;
        }
    }

    static abstract class ValueVersionResult
    extends Result {
        private final ResultValue resultValue;
        protected Version version;
        private final long expirationTime;

        ValueVersionResult(InternalOperation.OpCode op, ResultValueVersion valueVersion) {
            super(op);
            if (valueVersion != null) {
                this.resultValue = valueVersion.getValueBytes() != null ? new ResultValue(valueVersion.getValueBytes()) : null;
                this.version = valueVersion.getVersion();
                this.expirationTime = valueVersion.getExpirationTime();
            } else {
                this.resultValue = null;
                this.version = null;
                this.expirationTime = 0L;
            }
        }

        ValueVersionResult(InternalOperation.OpCode op, DataInput in, short serialVersion) throws IOException {
            super(op, in, serialVersion);
            this.resultValue = in.readByte() != 0 ? new ResultValue(in, serialVersion) : null;
            this.version = in.readByte() != 0 ? Version.createVersion(in, serialVersion) : null;
            this.expirationTime = ValueVersionResult.readExpirationTime(in, serialVersion);
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            if (this.resultValue != null) {
                out.write(1);
                this.resultValue.writeFastExternal(out, serialVersion);
            } else {
                out.write(0);
            }
            out.write(this.version == null ? 0 : 1);
            if (this.version != null) {
                this.version.writeFastExternal(out, serialVersion);
            }
            ValueVersionResult.writeExpirationTime(out, this.expirationTime, serialVersion);
        }

        @Override
        public Value getPreviousValue() {
            return this.resultValue == null ? null : this.resultValue.getValue();
        }

        @Override
        public Version getPreviousVersion() {
            return this.version;
        }

        @Override
        public long getPreviousExpirationTime() {
            return this.expirationTime;
        }
    }

    static class MultiDeleteResult
    extends Result {
        private final int nDeletions;

        MultiDeleteResult(InternalOperation.OpCode opCode, int nDeletions) {
            super(opCode);
            this.nDeletions = nDeletions;
        }

        MultiDeleteResult(InternalOperation.OpCode opCode, DataInput in, short serialVersion) throws IOException {
            super(opCode, in, serialVersion);
            this.nDeletions = in.readInt();
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            out.writeInt(this.nDeletions);
        }

        @Override
        public int getNDeletions() {
            return this.nDeletions;
        }

        @Override
        public boolean getSuccess() {
            return this.nDeletions > 0;
        }

        @Override
        public int getNumRecords() {
            return this.nDeletions;
        }
    }

    static class DeleteResult
    extends ValueVersionResult {
        private final boolean success;

        DeleteResult(InternalOperation.OpCode opCode, ResultValueVersion prevVal, boolean success) {
            super(opCode, prevVal);
            this.success = success;
        }

        DeleteResult(InternalOperation.OpCode opCode, DataInput in, short serialVersion) throws IOException {
            super(opCode, in, serialVersion);
            this.success = in.readBoolean();
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            out.writeBoolean(this.success);
        }

        @Override
        public boolean getSuccess() {
            return this.success;
        }
    }

    static class PutResult
    extends ValueVersionResult {
        private final Version newVersion;
        private final long newExpirationTime;

        PutResult(InternalOperation.OpCode opCode, ResultValueVersion prevVal, InternalOperationHandler.VersionAndExpiration ve) {
            super(opCode, prevVal);
            if (ve != null) {
                this.newVersion = ve.getVersion();
                this.newExpirationTime = ve.getExpirationTime();
            } else {
                this.newVersion = null;
                this.newExpirationTime = 0L;
            }
        }

        PutResult(InternalOperation.OpCode opCode, DataInput in, short serialVersion) throws IOException {
            super(opCode, in, serialVersion);
            this.newVersion = in.readByte() != 0 ? Version.createVersion(in, serialVersion) : null;
            this.newExpirationTime = PutResult.readExpirationTime(in, serialVersion);
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            out.write(this.newVersion == null ? 0 : 1);
            if (this.newVersion != null) {
                this.newVersion.writeFastExternal(out, serialVersion);
            }
            PutResult.writeExpirationTime(out, this.newExpirationTime, serialVersion);
        }

        @Override
        public boolean getSuccess() {
            return this.newVersion != null;
        }

        @Override
        public Version getNewVersion() {
            return this.newVersion;
        }

        @Override
        public long getNewExpirationTime() {
            return this.newExpirationTime;
        }
    }

    static class GetResult
    extends ValueVersionResult {
        GetResult(InternalOperation.OpCode opCode, ResultValueVersion valueVersion) {
            super(opCode, valueVersion);
        }

        GetResult(InternalOperation.OpCode opCode, DataInput in, short serialVersion) throws IOException {
            super(opCode, in, serialVersion);
        }

        @Override
        public boolean getSuccess() {
            return this.getPreviousValue() != null;
        }
    }
}

