/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.ReturnValueVersion;
import oracle.kv.Value;
import oracle.kv.Version;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.Put;
import oracle.kv.table.TimeToLive;

public class PutIfVersion
extends Put {
    private final Version matchVersion;

    public PutIfVersion(byte[] keyBytes, Value value, ReturnValueVersion.Choice prevValChoice, Version matchVersion) {
        this(keyBytes, value, prevValChoice, matchVersion, 0L);
    }

    public PutIfVersion(byte[] keyBytes, Value value, ReturnValueVersion.Choice prevValChoice, Version matchVersion, long tableId) {
        this(keyBytes, value, prevValChoice, matchVersion, tableId, null, false);
    }

    public PutIfVersion(byte[] keyBytes, Value value, ReturnValueVersion.Choice prevValChoice, Version matchVersion, long tableId, TimeToLive ttl, boolean updateTTL) {
        super(InternalOperation.OpCode.PUT_IF_VERSION, keyBytes, value, prevValChoice, tableId, ttl, updateTTL);
        this.matchVersion = matchVersion;
    }

    PutIfVersion(DataInput in, short serialVersion) throws IOException {
        super(InternalOperation.OpCode.PUT_IF_VERSION, in, serialVersion);
        this.matchVersion = Version.createVersion(in, serialVersion);
    }

    Version getMatchVersion() {
        return this.matchVersion;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        this.matchVersion.writeFastExternal(out, serialVersion);
    }

    @Override
    public String toString() {
        return super.toString() + " MatchVersion: " + this.matchVersion;
    }
}

