/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.kv.impl.api.bulk.BulkPut;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiKeyOperation;

public class PutBatch
extends MultiKeyOperation {
    private final List<BulkPut.KVPair> kvPairs;
    private final long[] tableIds;

    public PutBatch(List<BulkPut.KVPair> le, long[] tableIds) {
        super(InternalOperation.OpCode.PUT_BATCH, null, null, null);
        this.kvPairs = le;
        this.tableIds = tableIds;
    }

    PutBatch(DataInput in, short serialVersion) throws IOException {
        super(InternalOperation.OpCode.PUT_BATCH, in, serialVersion);
        int kvPairCount = in.readInt();
        this.kvPairs = new ArrayList<BulkPut.KVPair>(kvPairCount);
        for (int i = 0; i < kvPairCount; ++i) {
            BulkPut.KVPair kv;
            int keySize = in.readInt();
            byte[] key = new byte[keySize];
            in.readFully(key);
            int valueSize = in.readInt();
            byte[] value = new byte[valueSize];
            in.readFully(value);
            if (serialVersion >= 10) {
                int ttlVal = in.readInt();
                byte ttlUnitOrdinal = ttlVal != 0 ? in.readByte() : (byte)0;
                kv = new BulkPut.KVPair(key, value, ttlVal, ttlUnitOrdinal);
            } else {
                kv = new BulkPut.KVPair(key, value);
            }
            this.kvPairs.add(kv);
        }
        int tableIdCount = in.readInt();
        if (tableIdCount == -1) {
            this.tableIds = null;
        } else {
            this.tableIds = new long[tableIdCount];
            for (int i = 0; i < tableIdCount; ++i) {
                this.tableIds[i] = in.readLong();
            }
        }
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeInt(this.kvPairs.size());
        for (BulkPut.KVPair e : this.kvPairs) {
            byte[] key = e.getKey();
            out.writeInt(key.length);
            out.write(key);
            byte[] value = e.getValue();
            out.writeInt(value.length);
            out.write(value);
            int ttlVal = e.getTTLVal();
            if (serialVersion >= 10) {
                out.writeInt(ttlVal);
                if (ttlVal == 0) continue;
                out.writeByte(e.getTTLUnitOrdinal());
                continue;
            }
            if (ttlVal == 0) continue;
            this.throwVersionRequired(serialVersion, (short)10);
        }
        if (this.tableIds != null) {
            out.writeInt(this.tableIds.length);
            Object object = this.tableIds;
            int n = ((Object)object).length;
            for (int i = 0; i < n; ++i) {
                Long tableId = (long)object[i];
                out.writeLong(tableId);
            }
        } else {
            out.writeInt(-1);
        }
    }

    List<BulkPut.KVPair> getKvPairs() {
        return this.kvPairs;
    }

    long[] getTableIds() {
        return this.tableIds;
    }
}

