/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import oracle.kv.ReturnValueVersion;
import oracle.kv.Value;
import oracle.kv.impl.api.lob.KVLargeObjectImpl;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.RequestValue;
import oracle.kv.impl.api.ops.SingleKeyOperation;
import oracle.kv.table.TimeToLive;

public class Put
extends SingleKeyOperation {
    private final RequestValue requestValue;
    private final ReturnValueVersion.Choice prevValChoice;
    private final long tableId;
    private TimeToLive ttl;
    private boolean updateTTL;

    public Put(byte[] keyBytes, Value value, ReturnValueVersion.Choice prevValChoice) {
        this(InternalOperation.OpCode.PUT, keyBytes, value, prevValChoice, 0L);
    }

    public Put(byte[] keyBytes, Value value, ReturnValueVersion.Choice prevValChoice, long tableId) {
        this(InternalOperation.OpCode.PUT, keyBytes, value, prevValChoice, tableId);
    }

    public Put(byte[] keyBytes, Value value, ReturnValueVersion.Choice prevValChoice, long tableId, TimeToLive ttl, boolean updateTTL) {
        this(InternalOperation.OpCode.PUT, keyBytes, value, prevValChoice, tableId, ttl, updateTTL);
    }

    Put(InternalOperation.OpCode opCode, byte[] keyBytes, Value value, ReturnValueVersion.Choice prevValChoice, long tableId) {
        super(opCode, keyBytes);
        this.requestValue = new RequestValue(value);
        this.prevValChoice = prevValChoice;
        this.tableId = tableId;
    }

    Put(InternalOperation.OpCode opCode, byte[] keyBytes, Value value, ReturnValueVersion.Choice prevValChoice, long tableId, TimeToLive ttl, boolean updateTTL) {
        this(opCode, keyBytes, value, prevValChoice, tableId);
        this.ttl = ttl;
        this.updateTTL = updateTTL;
    }

    Put(DataInput in, short serialVersion) throws IOException {
        this(InternalOperation.OpCode.PUT, in, serialVersion);
    }

    Put(InternalOperation.OpCode opCode, DataInput in, short serialVersion) throws IOException {
        super(opCode, in, serialVersion);
        this.requestValue = new RequestValue(in, serialVersion);
        assert (this.requestValue.getBytes() != null);
        this.prevValChoice = ReturnValueVersion.Choice.readFastExternal(in, serialVersion);
        this.tableId = serialVersion >= 4 ? in.readLong() : 0L;
        if (serialVersion >= 10) {
            int ttlVal = in.readInt();
            TimeUnit unit = ttlVal != 0 ? TimeUnit.values()[in.readByte()] : TimeUnit.DAYS;
            this.ttl = TimeToLive.createTimeToLive(ttlVal, unit);
            this.updateTTL = in.readBoolean();
        }
    }

    public void setTTLOptions(TimeToLive ttl, boolean updateTTL) {
        this.ttl = ttl;
        this.updateTTL = updateTTL;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        this.requestValue.writeFastExternal(out, serialVersion);
        this.prevValChoice.writeFastExternal(out, serialVersion);
        if (serialVersion >= 4) {
            out.writeLong(this.tableId);
        } else if (this.tableId != 0L) {
            this.throwVersionRequired(serialVersion, (short)4);
        }
        if (serialVersion >= 10) {
            int ttlVal = 0;
            if (this.ttl != null) {
                ttlVal = (int)this.ttl.getValue();
            }
            out.writeInt(ttlVal);
            if (ttlVal != 0) {
                out.writeByte(this.ttl.getUnit().ordinal());
            }
            out.writeBoolean(this.updateTTL);
        } else if (this.ttl != null && this.ttl.getValue() != 0L) {
            this.throwVersionRequired(serialVersion, (short)10);
        }
    }

    public byte[] getValueBytes() {
        return this.requestValue.getBytes();
    }

    public ReturnValueVersion.Choice getReturnValueVersionChoice() {
        return this.prevValChoice;
    }

    @Override
    long getTableId() {
        return this.tableId;
    }

    TimeToLive getTTL() {
        return this.ttl;
    }

    boolean getUpdateTTL() {
        return this.updateTTL;
    }

    @Override
    public byte[] checkLOBSuffix(byte[] lobSuffixBytes) {
        return KVLargeObjectImpl.hasLOBSuffix(this.getKeyBytes(), lobSuffixBytes) ? this.getKeyBytes() : null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        if (this.tableId != 0L) {
            sb.append(" Table Id ");
            sb.append(this.tableId);
        }
        sb.append(" Value: ");
        sb.append(this.requestValue);
        return sb.toString();
    }
}

