/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.Depth;
import oracle.kv.KeyRange;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.util.UserDataControl;

abstract class MultiKeyOperation
extends InternalOperation {
    private final byte[] parentKey;
    private final KeyRange subRange;
    private final Depth depth;

    MultiKeyOperation(InternalOperation.OpCode opCode, byte[] parentKey, KeyRange subRange, Depth depth) {
        super(opCode);
        this.parentKey = parentKey;
        this.subRange = subRange;
        this.depth = depth;
    }

    MultiKeyOperation(InternalOperation.OpCode opCode, DataInput in, short serialVersion) throws IOException {
        super(opCode, in, serialVersion);
        short keyLen = in.readShort();
        if (keyLen < 0) {
            this.parentKey = null;
        } else {
            this.parentKey = new byte[keyLen];
            in.readFully(this.parentKey);
        }
        this.subRange = in.readByte() == 0 ? null : new KeyRange(in, serialVersion);
        byte depthOrdinal = in.readByte();
        this.depth = depthOrdinal == -1 ? null : Depth.valueOf(depthOrdinal);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        if (this.parentKey == null) {
            out.writeShort(-1);
        } else {
            out.writeShort(this.parentKey.length);
            out.write(this.parentKey);
        }
        if (this.subRange == null) {
            out.write(0);
        } else {
            out.write(1);
            this.subRange.writeFastExternal(out, serialVersion);
        }
        if (this.depth == null) {
            out.writeByte(-1);
        } else {
            out.writeByte(this.depth.ordinal());
        }
    }

    byte[] getParentKey() {
        return this.parentKey;
    }

    KeyRange getSubRange() {
        return this.subRange;
    }

    Depth getDepth() {
        return this.depth;
    }

    @Override
    public String toString() {
        return super.toString() + " parentKey: " + UserDataControl.displayKey(this.parentKey) + " subRange: " + UserDataControl.displayKeyRange(this.subRange) + " depth: " + (Object)((Object)this.depth);
    }
}

