/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.KeyRange;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiKeyOperation;

public abstract class MultiKeyIterate
extends MultiKeyOperation {
    private final Direction direction;
    private final int batchSize;
    private final byte[] resumeKey;

    MultiKeyIterate(InternalOperation.OpCode opCode, byte[] parentKey, KeyRange subRange, Depth depth, Direction direction, int batchSize, byte[] resumeKey) {
        super(opCode, parentKey, subRange, depth);
        this.direction = direction;
        this.batchSize = batchSize;
        this.resumeKey = resumeKey;
    }

    MultiKeyIterate(InternalOperation.OpCode opCode, DataInput in, short serialVersion) throws IOException {
        super(opCode, in, serialVersion);
        this.direction = Direction.readFastExternal(in, serialVersion);
        this.batchSize = in.readInt();
        short keyLen = in.readShort();
        if (keyLen < 0) {
            this.resumeKey = null;
        } else {
            this.resumeKey = new byte[keyLen];
            in.readFully(this.resumeKey);
        }
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        this.direction.writeFastExternal(out, serialVersion);
        out.writeInt(this.batchSize);
        if (this.resumeKey == null) {
            out.writeShort(-1);
        } else {
            out.writeShort(this.resumeKey.length);
            out.write(this.resumeKey);
        }
    }

    Direction getDirection() {
        return this.direction;
    }

    int getBatchSize() {
        return this.batchSize;
    }

    byte[] getResumeKey() {
        return this.resumeKey;
    }
}

