/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.kv.KeyRange;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiGetTableOperation;
import oracle.kv.impl.api.table.TargetTables;

abstract class MultiGetBatchTableOperation
extends MultiGetTableOperation {
    private final List<byte[]> keys;
    private final int batchSize;
    private final byte[] resumeKey;

    public MultiGetBatchTableOperation(InternalOperation.OpCode opCode, List<byte[]> parentKeys, byte[] resumeKey, TargetTables targetTables, KeyRange subRange, int batchSize) {
        super(opCode, parentKeys.get(0), targetTables, subRange);
        this.keys = parentKeys;
        this.resumeKey = resumeKey;
        this.batchSize = batchSize;
    }

    protected MultiGetBatchTableOperation(InternalOperation.OpCode opCode, DataInput in, short serialVersion) throws IOException {
        super(opCode, in, serialVersion);
        short len;
        int nkeys = in.readShort();
        if (nkeys > 0) {
            this.keys = new ArrayList<byte[]>(nkeys);
            for (int i = 0; i < nkeys; ++i) {
                short len2 = in.readShort();
                byte[] key = new byte[len2];
                in.readFully(key);
                this.keys.add(key);
            }
        } else {
            this.keys = null;
        }
        if ((len = in.readShort()) > 0) {
            this.resumeKey = new byte[len];
            in.readFully(this.resumeKey);
        } else {
            this.resumeKey = null;
        }
        this.batchSize = in.readInt();
    }

    List<byte[]> getParentKeys() {
        return this.keys;
    }

    int getBatchSize() {
        return this.batchSize;
    }

    byte[] getResumeKey() {
        return this.resumeKey;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        if (this.keys != null) {
            out.writeShort(this.keys.size());
            for (byte[] key : this.keys) {
                out.writeShort(key.length);
                out.write(key);
            }
        } else {
            out.writeShort(-1);
        }
        if (this.resumeKey != null) {
            out.writeShort(this.resumeKey.length);
            out.write(this.resumeKey);
        } else {
            out.writeShort(-1);
        }
        out.writeInt(this.batchSize);
    }
}

