/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.kv.Depth;
import oracle.kv.KeyRange;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiKeyOperation;
import oracle.kv.impl.util.UserDataControl;

abstract class MultiGetBatchIterateOperation
extends MultiKeyOperation {
    private final List<byte[]> parentKeys;
    private final int batchSize;
    private final byte[] resumeKey;

    public MultiGetBatchIterateOperation(InternalOperation.OpCode opCode, List<byte[]> parentKeys, byte[] resumekey, KeyRange subRange, Depth depth, int batchSize) {
        super(opCode, parentKeys.get(0), subRange, depth);
        this.parentKeys = parentKeys;
        this.resumeKey = resumekey;
        this.batchSize = batchSize;
    }

    protected MultiGetBatchIterateOperation(InternalOperation.OpCode opCode, DataInput in, short serialVersion) throws IOException {
        super(opCode, in, serialVersion);
        short len;
        int nkeys = in.readShort();
        if (nkeys > 0) {
            this.parentKeys = new ArrayList<byte[]>(nkeys);
            for (int i = 0; i < nkeys; ++i) {
                short len2 = in.readShort();
                byte[] key = new byte[len2];
                in.readFully(key);
                this.parentKeys.add(key);
            }
        } else {
            this.parentKeys = null;
        }
        if ((len = in.readShort()) > 0) {
            this.resumeKey = new byte[len];
            in.readFully(this.resumeKey);
        } else {
            this.resumeKey = null;
        }
        this.batchSize = in.readInt();
    }

    List<byte[]> getParentKeys() {
        return this.parentKeys;
    }

    int getBatchSize() {
        return this.batchSize;
    }

    byte[] getResumeKey() {
        return this.resumeKey;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        if (this.parentKeys != null) {
            out.writeShort(this.parentKeys.size());
            for (byte[] key : this.parentKeys) {
                out.writeShort(key.length);
                out.write(key);
            }
        } else {
            out.writeShort(-1);
        }
        if (this.resumeKey != null && this.resumeKey.length > 0) {
            out.writeShort(this.resumeKey.length);
            out.write(this.resumeKey);
        } else {
            out.writeShort(-1);
        }
        out.writeInt(this.batchSize);
    }

    @Override
    public String toString() {
        return "parentKeys: " + this.parentKeys.size() + " resumeKey: " + UserDataControl.displayKey(this.resumeKey) + " subRange: " + UserDataControl.displayKeyRange(this.getSubRange()) + " depth: " + (Object)((Object)this.getDepth());
    }
}

