/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.IndexRange;
import oracle.kv.impl.api.table.TargetTables;

public class IndexOperation
extends InternalOperation {
    private final String indexName;
    protected final TargetTables targetTables;
    protected final IndexRange range;
    private final byte[] resumeSecondaryKey;
    private final byte[] resumePrimaryKey;
    private final int batchSize;
    private final short clientSerialVersion;

    public IndexOperation(InternalOperation.OpCode opCode, String indexName, TargetTables targetTables, IndexRange range, byte[] resumeSecondaryKey, byte[] resumePrimaryKey, int batchSize) {
        super(opCode);
        this.indexName = indexName;
        this.targetTables = targetTables;
        this.range = range;
        this.resumeSecondaryKey = resumeSecondaryKey;
        this.resumePrimaryKey = resumePrimaryKey;
        this.batchSize = batchSize;
        this.clientSerialVersion = (short)13;
    }

    IndexOperation(InternalOperation.OpCode opCode, DataInput in, short serialVersion) throws IOException {
        super(opCode, in, serialVersion);
        this.clientSerialVersion = serialVersion;
        this.indexName = in.readUTF();
        this.targetTables = new TargetTables(in, serialVersion);
        this.range = new IndexRange(in, serialVersion);
        short keyLen = in.readShort();
        if (keyLen < 0) {
            this.resumeSecondaryKey = null;
            this.resumePrimaryKey = null;
        } else {
            this.resumeSecondaryKey = new byte[keyLen];
            in.readFully(this.resumeSecondaryKey);
            keyLen = in.readShort();
            this.resumePrimaryKey = new byte[keyLen];
            in.readFully(this.resumePrimaryKey);
        }
        this.batchSize = in.readInt();
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeUTF(this.indexName);
        this.targetTables.writeFastExternal(out, serialVersion);
        this.range.writeFastExternal(out, serialVersion);
        if (this.resumeSecondaryKey == null) {
            out.writeShort(-1);
        } else {
            out.writeShort(this.resumeSecondaryKey.length);
            out.write(this.resumeSecondaryKey);
            out.writeShort(this.resumePrimaryKey.length);
            out.write(this.resumePrimaryKey);
        }
        out.writeInt(this.batchSize);
    }

    IndexRange getIndexRange() {
        return this.range;
    }

    byte[] getResumeSecondaryKey() {
        return this.resumeSecondaryKey;
    }

    byte[] getResumePrimaryKey() {
        return this.resumePrimaryKey;
    }

    int getBatchSize() {
        return this.batchSize;
    }

    String getIndexName() {
        return this.indexName;
    }

    TargetTables getTargetTables() {
        return this.targetTables;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    void checkReserializeKeys(IndexImpl index) {
        if (!index.isNullSupported() || this.clientSerialVersion > 10) {
            return;
        }
        this.range.reserializeOldKeys(index);
    }

    byte[] checkReserializeKeys(IndexImpl index, byte[] indexKey) {
        if (!index.isNullSupported() || this.clientSerialVersion > 10) {
            return indexKey;
        }
        return index.reserializeToOldKey(indexKey);
    }
}

