/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.SingleKeyOperation;

public class Get
extends SingleKeyOperation {
    private final long tableId;

    public Get(byte[] keyBytes) {
        this(keyBytes, 0L);
    }

    public Get(byte[] keyBytes, long tableId) {
        super(InternalOperation.OpCode.GET, keyBytes);
        this.tableId = tableId;
    }

    @Override
    long getTableId() {
        return this.tableId;
    }

    Get(DataInput in, short serialVersion) throws IOException {
        super(InternalOperation.OpCode.GET, in, serialVersion);
        this.tableId = serialVersion >= 4 ? in.readLong() : 0L;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        if (serialVersion >= 4) {
            out.writeLong(this.tableId);
        } else if (this.tableId != 0L) {
            this.throwVersionRequired(serialVersion, (short)4);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        if (this.tableId != 0L) {
            sb.append(" Table Id ");
            sb.append(this.tableId);
        }
        return sb.toString();
    }
}

