/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.ReturnValueVersion;
import oracle.kv.impl.api.lob.KVLargeObjectImpl;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.SingleKeyOperation;

public class Delete
extends SingleKeyOperation {
    private final ReturnValueVersion.Choice prevValChoice;
    private final long tableId;

    public Delete(byte[] keyBytes, ReturnValueVersion.Choice prevValChoice) {
        this(keyBytes, prevValChoice, 0L);
    }

    public Delete(byte[] keyBytes, ReturnValueVersion.Choice prevValChoice, long tableId) {
        this(InternalOperation.OpCode.DELETE, keyBytes, prevValChoice, tableId);
    }

    Delete(InternalOperation.OpCode opCode, byte[] keyBytes, ReturnValueVersion.Choice prevValChoice, long tableId) {
        super(opCode, keyBytes);
        this.prevValChoice = prevValChoice;
        this.tableId = tableId;
    }

    Delete(DataInput in, short serialVersion) throws IOException {
        this(InternalOperation.OpCode.DELETE, in, serialVersion);
    }

    Delete(InternalOperation.OpCode opCode, DataInput in, short serialVersion) throws IOException {
        super(opCode, in, serialVersion);
        this.prevValChoice = ReturnValueVersion.Choice.readFastExternal(in, serialVersion);
        this.tableId = serialVersion >= 4 ? in.readLong() : 0L;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        this.prevValChoice.writeFastExternal(out, serialVersion);
        if (serialVersion >= 4) {
            out.writeLong(this.tableId);
        } else if (this.tableId != 0L) {
            this.throwVersionRequired(serialVersion, (short)4);
        }
    }

    public ReturnValueVersion.Choice getReturnValueVersionChoice() {
        return this.prevValChoice;
    }

    @Override
    long getTableId() {
        return this.tableId;
    }

    @Override
    public byte[] checkLOBSuffix(byte[] lobSuffixBytes) {
        return KVLargeObjectImpl.hasLOBSuffix(this.getKeyBytes(), lobSuffixBytes) ? this.getKeyBytes() : null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Delete ");
        if (this.tableId != 0L) {
            sb.append("Table Id ");
            sb.append(this.tableId);
            sb.append(" ");
        }
        sb.append(super.toString());
        return sb.toString();
    }
}

