/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import oracle.kv.Value;
import oracle.kv.avro.RawAvroBinding;
import oracle.kv.avro.RawRecord;
import oracle.kv.avro.SchemaNotAllowedException;
import oracle.kv.avro.SpecificAvroBinding;
import oracle.kv.avro.UndefinedSchemaException;
import oracle.kv.impl.api.avro.AvroCatalogImpl;
import oracle.kv.impl.api.avro.GenericBinding;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;

class SpecificBinding<T extends SpecificRecord>
implements SpecificAvroBinding<T> {
    private final RawAvroBinding rawBinding;
    private final Map<String, Schema> allowedSchemas;

    SpecificBinding(AvroCatalogImpl catalog, Class<T> allowedCls) throws UndefinedSchemaException {
        this.rawBinding = catalog.getRawBinding();
        if (allowedCls != null) {
            Schema schema = SpecificData.get().getSchema(allowedCls);
            this.allowedSchemas = Collections.singletonMap(schema.getFullName(), schema);
            catalog.checkDefinedSchemas(this.allowedSchemas);
        } else {
            this.allowedSchemas = null;
        }
    }

    @Override
    public T toObject(Value value) throws SchemaNotAllowedException, IllegalArgumentException {
        Schema readerSchema;
        RawRecord raw = this.rawBinding.toObject(value);
        Schema writerSchema = raw.getSchema();
        if (this.allowedSchemas != null) {
            readerSchema = AvroCatalogImpl.checkToObjectSchema(writerSchema, this.allowedSchemas);
        } else {
            SpecificData specificData = SpecificData.get();
            Class cls = specificData.getClass(writerSchema);
            readerSchema = specificData.getSchema(cls);
        }
        SpecificDatumReader reader = new SpecificDatumReader(writerSchema, readerSchema);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(raw.getRawData(), null);
        try {
            return (T)((SpecificRecord)reader.read(null, decoder));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to deserialize SpecificRecord", e);
        }
    }

    @Override
    public Value toValue(T object) throws SchemaNotAllowedException, UndefinedSchemaException, IllegalArgumentException {
        Schema writerSchema = object.getSchema();
        if (this.allowedSchemas != null) {
            AvroCatalogImpl.checkToValueSchema(writerSchema, this.allowedSchemas);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SpecificWriter writer = new SpecificWriter(writerSchema);
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder(out, null);
        try {
            writer.write(object, encoder);
            encoder.flush();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to serialize SpecificRecord", e);
        }
        RawRecord raw = new RawRecord(out.toByteArray(), writerSchema);
        return this.rawBinding.toValue(raw);
    }

    private static class SpecificWriter<T>
    extends SpecificDatumWriter<T> {
        SpecificWriter(Schema writerSchema) {
            super(writerSchema);
        }

        @Override
        protected void writeFixed(Schema schema, Object datum, Encoder out) throws IOException {
            byte[] bytes = ((GenericFixed)datum).bytes();
            GenericBinding.writeFixed(schema, bytes, out);
        }
    }
}

