/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import java.io.Serializable;
import oracle.kv.impl.fault.CommandFaultException;
import oracle.kv.util.ErrorMessage;

public interface CommandResult {
    public static final String[] NO_CLEANUP_JOBS = new String[0];
    public static final String[] STORE_CLEANUP = new String[]{"store_clean.kvs"};
    public static final String[] TOPO_REPAIR = new String[]{"plan repair-topology"};
    public static final String[] PLAN_CANCEL = new String[]{"plan_cancel_retry.kvs"};
    public static final String[] TOPO_PLAN_REPAIR = new String[]{"plan repair-topology", "plan_cancel_retry.kvs"};

    public String getReturnValue();

    public String getDescription();

    public int getErrorCode();

    public String[] getCleanupJobs();

    public static class CommandWarns
    implements CommandResult,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String description;
        private final String returnValue;

        public CommandWarns(String description, String returnValue) {
            this.description = description;
            this.returnValue = returnValue;
        }

        @Override
        public String getReturnValue() {
            return this.returnValue;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public int getErrorCode() {
            return ErrorMessage.NOSQL_5000.getValue();
        }

        @Override
        public String[] getCleanupJobs() {
            return null;
        }
    }

    public static class CommandSucceeds
    implements CommandResult,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final String SUCCESS_MSG = "Operation ends successfully";
        private final String returnValue;

        public CommandSucceeds(String returnValue) {
            this.returnValue = returnValue;
        }

        @Override
        public String getReturnValue() {
            return this.returnValue;
        }

        @Override
        public String getDescription() {
            return SUCCESS_MSG;
        }

        @Override
        public int getErrorCode() {
            return ErrorMessage.NOSQL_5000.getValue();
        }

        @Override
        public String[] getCleanupJobs() {
            return null;
        }
    }

    public static class CommandFails
    implements CommandResult,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String description;
        private final int errorCode;
        private final String[] cleanupJobs;

        public CommandFails(String description, ErrorMessage errorMsg, String[] cleanupJobs) {
            this.description = description;
            this.errorCode = errorMsg.getValue();
            this.cleanupJobs = cleanupJobs;
        }

        public CommandFails(CommandFaultException cfe) {
            this(cfe.getDescription(), cfe.getErrorMessage(), cfe.getCleanupJobs());
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public int getErrorCode() {
            return this.errorCode;
        }

        @Override
        public String[] getCleanupJobs() {
            return this.cleanupJobs;
        }

        @Override
        public String getReturnValue() {
            return null;
        }
    }
}

