/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import java.io.IOException;
import java.io.ObjectInputStream;
import oracle.kv.impl.admin.CommandResult;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.fault.CommandFaultException;
import oracle.kv.impl.fault.InternalFaultException;
import oracle.kv.util.ErrorMessage;

public class AdminFaultException
extends InternalFaultException {
    private static final long serialVersionUID = 1L;
    private static final ErrorMessage DEFAULT_ERR_MSG = ErrorMessage.NOSQL_5100;
    private CommandResult cmdResult;

    public AdminFaultException(Throwable cause) {
        this(cause, new CommandResult.CommandFails(cause.getMessage(), DEFAULT_ERR_MSG, CommandResult.NO_CLEANUP_JOBS));
    }

    public AdminFaultException(Throwable cause, String description, ErrorMessage errorMsg, String[] cleanupJobs) {
        this(cause, new CommandResult.CommandFails(description, errorMsg, cleanupJobs));
    }

    private AdminFaultException(Throwable cause, CommandResult cmdResult) {
        super(cause);
        this.cmdResult = cmdResult;
    }

    public CommandResult getCommandResult() {
        return this.cmdResult;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        if (this.cmdResult == null) {
            this.cmdResult = new CommandResult.CommandFails(this.getMessage(), DEFAULT_ERR_MSG, CommandResult.NO_CLEANUP_JOBS);
        }
    }

    public static AdminFaultException wrapCommandFault(CommandFaultException cfe) {
        CommandResult.CommandFails cmdResult = new CommandResult.CommandFails(cfe);
        if (cfe instanceof IllegalCommandException || cfe.getCause() == null) {
            return new AdminFaultException(cfe, cmdResult);
        }
        return new AdminFaultException(cfe.getCause(), cmdResult);
    }
}

