/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop.table;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Direction;
import oracle.kv.FaultException;
import oracle.kv.KVSecurityException;
import oracle.kv.KVStore;
import oracle.kv.KVStoreConfig;
import oracle.kv.KVStoreFactory;
import oracle.kv.ParamConstant;
import oracle.kv.StatementResult;
import oracle.kv.hadoop.table.TableInputSplit;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.table.TableAPIImpl;
import oracle.kv.impl.security.util.KVStoreLogin;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.query.ExecuteOptions;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldRange;
import oracle.kv.table.IndexKey;
import oracle.kv.table.MultiRowOptions;
import oracle.kv.table.PrimaryKey;
import oracle.kv.table.RecordValue;
import oracle.kv.table.Row;
import oracle.kv.table.Table;
import oracle.kv.table.TableIterator;
import oracle.kv.table.TableIteratorOptions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

abstract class TableRecordReaderBase<K, V>
extends RecordReader<K, V> {
    private static final Log LOG = LogFactory.getLog((String)"oracle.kv.hadoop.table.TableRecordReaderBase");
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final String USER_SECURITY_DIR = System.getProperty("user.dir") + FILE_SEP + "TABLE_RECORD_READER_SECURITY_DIR";
    private static String[] requiredRangeNames = new String[]{"name", "start", "end"};
    private KVStore kvstore;
    private Table kvTable;
    private String tableName;
    private PrimaryKey primaryKey;
    private IndexKey indexKey;
    private MultiRowOptions rowOpts;
    private TableIteratorOptions itrOpts = null;
    private ExecuteOptions execOpts = null;
    private List<Set<Integer>> partitionSets;
    private int startNPartitionSets;
    private int queryBy = 0;
    private String whereClause = null;
    private String nativeQuery = null;
    private Set<RepGroupId> shardSet;
    private int startNShards;
    private TableIterator<? extends RecordValue> iter;
    private StatementResult statementResult;
    protected Row current;

    TableRecordReaderBase() {
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        TableInputSplit tableInputSplit = (TableInputSplit)split;
        this.tableName = tableInputSplit.getTableName();
        LOG.debug((Object)("split = " + (Object)((Object)tableInputSplit)));
        String kvStoreName = tableInputSplit.getKVStoreName();
        String[] kvHelperHosts = tableInputSplit.getKVHelperHosts();
        if (this.kvstore == null) {
            KVStoreConfig storeConfig = new KVStoreConfig(kvStoreName, kvHelperHosts);
            String kvStoreSecurityFile = TableRecordReaderBase.createLocalKVSecurity(tableInputSplit.getSecurityLogin(), tableInputSplit.getSecurityTrust());
            storeConfig.setSecurityProperties(KVStoreLogin.createSecurityProperties(kvStoreSecurityFile));
            RuntimeException cause = null;
            try {
                this.kvstore = KVStoreFactory.getStore(storeConfig, tableInputSplit.getSecurityCredentials(), null);
            }
            catch (FaultException fe) {
                cause = fe;
            }
            catch (KVSecurityException kse) {
                cause = kse;
            }
            if (cause != null) {
                if (tableInputSplit.getSecurityCredentials() != null) {
                    KVStoreConfig kvStoreConfigNonSecure = new KVStoreConfig(kvStoreName, kvHelperHosts);
                    kvStoreConfigNonSecure.setSecurityProperties(KVStoreLogin.createSecurityProperties(null));
                    this.kvstore = KVStoreFactory.getStore(kvStoreConfigNonSecure);
                } else {
                    throw cause;
                }
            }
        }
        this.kvTable = this.kvstore.getTableAPI().getTable(this.tableName);
        if (this.kvTable == null) {
            String msg = "Store does not contain table [name=" + this.tableName + "]";
            LOG.error((Object)msg);
            throw new RuntimeException(msg);
        }
        this.primaryKey = this.getPrimaryKey(this.kvTable, tableInputSplit.getPrimaryKeyProperty());
        this.rowOpts = new MultiRowOptions(this.getFieldRange(this.kvTable, tableInputSplit.getFieldRangeProperty()));
        Direction direction = tableInputSplit.getDirection();
        Consistency consistency = tableInputSplit.getConsistency();
        long timeout = tableInputSplit.getTimeout();
        TimeUnit timeoutUnit = tableInputSplit.getTimeoutUnit();
        int maxRequests = tableInputSplit.getMaxRequests();
        int batchSize = tableInputSplit.getBatchSize();
        if (timeout >= 0L && timeoutUnit != null || maxRequests >= 0 || batchSize >= 0 || direction != null) {
            this.execOpts = new ExecuteOptions();
            this.execOpts = this.execOpts.setConsistency(consistency);
            if (timeout >= 0L && timeoutUnit != null) {
                this.execOpts = this.execOpts.setTimeout(timeout, timeoutUnit);
            }
            if (maxRequests >= 0) {
                this.execOpts = this.execOpts.setMaxConcurrentRequests(maxRequests);
            }
            if (batchSize >= 0) {
                this.execOpts = this.execOpts.setResultsBatchSize(batchSize);
            }
            if (direction != null) {
                this.itrOpts = this.execOpts.createTableIteratorOptions(direction);
            }
        }
        this.partitionSets = tableInputSplit.getPartitionSets();
        this.startNPartitionSets = this.partitionSets.size();
        this.queryBy = tableInputSplit.getQueryBy();
        this.whereClause = tableInputSplit.getWhereClause();
        this.nativeQuery = "SELECT * FROM " + this.tableName + " WHERE " + this.whereClause;
        this.shardSet = tableInputSplit.getShardSet();
        this.startNShards = this.shardSet.size();
        if (LOG.isDebugEnabled()) {
            if (this.queryBy == 2) {
                LOG.debug((Object)"pushing index key (scanning ALL_SHARDS)");
            } else if (this.queryBy == 0) {
                LOG.debug((Object)"pushing primary key (scanning ALL_PARTITIONS)");
            } else if (this.queryBy == 1) {
                LOG.debug((Object)"pushing primary key (scanning SINGLE_PARTITION)");
            } else if (this.queryBy == 3) {
                LOG.debug((Object)("pushing native query (scanning ALL_PARTITIONS) - [" + this.nativeQuery + "]"));
            } else if (this.queryBy == 4) {
                LOG.debug((Object)("pushing native query (scanning SINGLE_PARTITION) - [" + this.nativeQuery + "]"));
            } else if (this.queryBy == 5) {
                LOG.debug((Object)("pushing native query (scanning ALL_SHARDS) - [" + this.nativeQuery + "]"));
            } else {
                LOG.debug((Object)("pushing native query (using default, all partitions in 1 split) - [" + this.nativeQuery + "]"));
            }
        }
    }

    public boolean nextKeyValue() {
        try {
            if (this.iter == null) {
                this.iter = this.getNextIterator();
            }
            while (this.iter != null) {
                if (this.iter.hasNext()) {
                    RecordValue nextRecord = (RecordValue)this.iter.next();
                    this.current = nextRecord instanceof Row ? (Row)nextRecord : this.kvTable.createRow(nextRecord);
                    LOG.trace((Object)("next row: " + this.current));
                    return true;
                }
                this.current = null;
                if (this.statementResult != null) {
                    this.statementResult.close();
                    this.statementResult = null;
                }
                this.iter = this.getNextIterator();
            }
            LOG.trace((Object)"exit loop: return false");
            return false;
        }
        catch (Exception e) {
            LOG.error((Object)("Exception while iterating table [" + e + "]"), (Throwable)e);
            return false;
        }
    }

    private TableIterator<? extends RecordValue> getNextIterator() {
        if (this.queryBy == 2 && this.indexKey != null) {
            if (this.shardSet.isEmpty()) {
                return null;
            }
            HashSet<RepGroupId> repGroupIds = new HashSet<RepGroupId>(this.shardSet);
            this.shardSet.clear();
            return ((TableAPIImpl)this.kvstore.getTableAPI()).tableIterator(this.indexKey, this.rowOpts, this.itrOpts, repGroupIds);
        }
        if (this.queryBy == 0 || this.queryBy == 1) {
            if (this.partitionSets.isEmpty()) {
                return null;
            }
            Set<Integer> partitions = this.partitionSets.remove(0);
            assert (partitions.size() > 0);
            return ((TableAPIImpl)this.kvstore.getTableAPI()).tableIterator(this.primaryKey, this.rowOpts, this.itrOpts, partitions);
        }
        if (this.queryBy == 3 || this.queryBy == 4) {
            return this.getNextOnqlIteratorPartitions(this.nativeQuery);
        }
        return this.getNextOnqlIteratorShards(this.nativeQuery);
    }

    private TableIterator<? extends RecordValue> getNextOnqlIteratorPartitions(String query) {
        if (this.partitionSets.isEmpty()) {
            return null;
        }
        Set<Integer> partitions = this.partitionSets.remove(0);
        assert (partitions.size() > 0);
        this.statementResult = ((KVStoreImpl)this.kvstore).executeSyncPartitions(query, this.execOpts, partitions);
        if (this.statementResult == null) {
            return null;
        }
        return this.statementResult.iterator();
    }

    private TableIterator<? extends RecordValue> getNextOnqlIteratorShards(String query) {
        if (this.shardSet.isEmpty()) {
            return null;
        }
        HashSet<RepGroupId> repGroupIds = new HashSet<RepGroupId>(this.shardSet);
        this.shardSet.clear();
        this.statementResult = ((KVStoreImpl)this.kvstore).executeSyncShards(query, this.execOpts, repGroupIds);
        if (this.statementResult == null) {
            return null;
        }
        return this.statementResult.iterator();
    }

    public float getProgress() {
        if (this.queryBy == 2) {
            return this.shardSet == null ? 0.0f : (float)(this.startNShards - this.shardSet.size()) / (float)this.startNShards;
        }
        return this.partitionSets == null ? 0.0f : (float)(this.startNPartitionSets - this.partitionSets.size()) / (float)this.startNPartitionSets;
    }

    public void close() throws IOException {
        LOG.trace((Object)"close iterator and store");
        if (this.iter != null) {
            this.iter.close();
        }
        if (this.kvstore != null) {
            this.kvstore.close();
        }
    }

    private PrimaryKey getPrimaryKey(Table table, String prop) {
        PrimaryKey retKey = table.createPrimaryKey();
        if (prop == null) {
            return retKey;
        }
        String warnStr = "Invalid JSON in property [" + ParamConstant.PRIMARY_KEY.getName() + "=" + prop + "]: " + "must be a list of name:value pairs in JSON format having " + "the form -D" + ParamConstant.PRIMARY_KEY.getName() + "=" + "\"{\\\"fieldName\\\":\\\"stringValue\\\"," + "\\\"fieldName\\\":floatValue, ... }\"; where the list " + "is enclosed in un-escaped double quotes and curly braces, " + "and each fieldName component and each STRING type fieldValue " + "component is enclosed in ESCAPED double quotes. ";
        String proceedStr = "Proceeding with full PrimaryKey wildcard.";
        try {
            retKey = table.createPrimaryKeyFromJson(prop, false);
        }
        catch (IllegalArgumentException e) {
            LOG.warn((Object)(warnStr + "Proceeding with full PrimaryKey wildcard."));
            e.printStackTrace();
        }
        return retKey;
    }

    private FieldRange getFieldRange(Table table, String rangeFieldProp) {
        FieldRange retRange = null;
        if (rangeFieldProp == null) {
            return retRange;
        }
        String warnStr = "Invalid JSON in property [" + ParamConstant.FIELD_RANGE.getName() + "=" + rangeFieldProp + "]: must be a list of name:value pairs in JSON format having " + "the form -D" + ParamConstant.FIELD_RANGE.getName() + "=" + "\"{\\\"name\\\":\\\"fieldName\\\"," + "\\\"start\\\":\\\"stringStartVal\\\"|scalarStartVal," + "[\\\"startInclusive\\\":true|false]," + "\\\"end\\\":\\\"stringEndVal\\\"|scalarEndVal," + "[\\\"endInclusive\\\":true|false]}\"; where the list " + "is enclosed in un-escaped double quotes and curly braces, " + "and each name component and each STRING type value component " + "is enclosed in ESCAPED double quotes. ";
        String proceedStr = "Proceeding with full range of values for the PrimaryKey rather than a sub-range ";
        try {
            retRange = this.createFieldRange(table, rangeFieldProp);
        }
        catch (IllegalArgumentException e) {
            LOG.warn((Object)(warnStr + "Proceeding with full range of values for the PrimaryKey rather than a sub-range "));
            e.printStackTrace();
        }
        return retRange;
    }

    private FieldRange createFieldRange(Table table, String rangeFieldProp) {
        FieldRange retRange;
        block27: {
            String[] propComponents;
            retRange = null;
            if (rangeFieldProp == null) {
                return retRange;
            }
            String missingLeftBraceStr = "invalid JSON format: system property does not begin with left curly brace ['{']";
            String missingRightBraceStr = "invalid JSON format: system property does not end with right curly brace ['}']";
            if (!rangeFieldProp.startsWith("{")) {
                throw new IllegalArgumentException("invalid JSON format: system property does not begin with left curly brace ['{']");
            }
            if (!rangeFieldProp.endsWith("}")) {
                throw new IllegalArgumentException("invalid JSON format: system property does not end with right curly brace ['}']");
            }
            String dq = "\"";
            String colon = ":";
            String missingNameBase = "missing required range field name ";
            for (String requiredName : requiredRangeNames) {
                String missingName = "missing required range field name [" + requiredName + "]";
                int indxOf = rangeFieldProp.indexOf("\"" + requiredName + "\"" + ":");
                if (indxOf >= 0) continue;
                throw new IllegalArgumentException(missingName);
            }
            String nameVal = null;
            String startVal = null;
            boolean startInclusive = true;
            String endVal = null;
            boolean endInclusive = true;
            FieldDef.Type fieldType = null;
            String invalidComponentBase = "invalid JSON format: invalid \"name\":\"value\" pair in system property ";
            String prop = rangeFieldProp.substring(1, rangeFieldProp.length() - 1);
            for (String propComponent : propComponents = prop.split(",")) {
                String invalidComponent = "invalid JSON format: invalid \"name\":\"value\" pair in system property [" + propComponent + "]";
                String[] rangeComponents = propComponent.split(":");
                if (rangeComponents.length != 2) {
                    throw new IllegalArgumentException(invalidComponent);
                }
                String name = rangeComponents[0].substring(1, rangeComponents[0].length() - 1);
                String val = rangeComponents[1];
                if ("name".equals(name.toLowerCase())) {
                    if (!val.startsWith("\"") || !val.endsWith("\"")) {
                        throw new IllegalArgumentException(invalidComponent);
                    }
                    nameVal = val.substring(1, val.length() - 1);
                    fieldType = table.getField(nameVal).getType();
                    continue;
                }
                if ("start".equals(name.toLowerCase())) {
                    if (val.startsWith("\"") && !val.endsWith("\"")) {
                        throw new IllegalArgumentException(invalidComponent);
                    }
                    if (!val.startsWith("\"") && val.endsWith("\"")) {
                        throw new IllegalArgumentException(invalidComponent);
                    }
                    if (val.startsWith("\"") && val.endsWith("\"")) {
                        startVal = val.substring(1, val.length() - 1);
                        continue;
                    }
                    startVal = val;
                    continue;
                }
                if ("startinclusive".equals(name.toLowerCase())) {
                    startInclusive = Boolean.parseBoolean(val);
                    continue;
                }
                if ("end".equals(name.toLowerCase())) {
                    if (val.startsWith("\"") && !val.endsWith("\"")) {
                        throw new IllegalArgumentException(invalidComponent);
                    }
                    if (!val.startsWith("\"") && val.endsWith("\"")) {
                        throw new IllegalArgumentException(invalidComponent);
                    }
                    if (val.startsWith("\"") && val.endsWith("\"")) {
                        endVal = val.substring(1, val.length() - 1);
                        continue;
                    }
                    endVal = val;
                    continue;
                }
                if (!"endinclusive".equals(name.toLowerCase())) continue;
                endInclusive = Boolean.parseBoolean(val);
            }
            if (nameVal == null) {
                throw new IllegalArgumentException("invalid JSON format: invalid \"name\":\"value\" pair in system property ");
            }
            if (startVal == null && fieldType == null) {
                throw new IllegalArgumentException("invalid JSON format: invalid \"name\":\"value\" pair in system property ");
            }
            retRange = table.createFieldRange(nameVal);
            if (FieldDef.Type.STRING.equals(fieldType)) {
                retRange.setStart(startVal, startInclusive);
                retRange.setEnd(endVal, endInclusive);
            } else {
                try {
                    if (FieldDef.Type.INTEGER.equals(fieldType)) {
                        retRange.setStart(Integer.parseInt(startVal), startInclusive);
                        retRange.setEnd(Integer.parseInt(endVal), endInclusive);
                        break block27;
                    }
                    if (FieldDef.Type.LONG.equals(fieldType)) {
                        retRange.setStart(Long.parseLong(startVal), startInclusive);
                        retRange.setEnd(Long.parseLong(endVal), endInclusive);
                        break block27;
                    }
                    if (FieldDef.Type.FLOAT.equals(fieldType)) {
                        retRange.setStart(Float.parseFloat(startVal), startInclusive);
                        retRange.setEnd(Float.parseFloat(endVal), endInclusive);
                        break block27;
                    }
                    if (FieldDef.Type.DOUBLE.equals(fieldType)) {
                        retRange.setStart(Double.parseDouble(startVal), startInclusive);
                        retRange.setEnd(Double.parseDouble(endVal), endInclusive);
                        break block27;
                    }
                    throw new IllegalArgumentException("invalid JSON format: invalid \"name\":\"value\" pair in system property ");
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(new NumberFormatException("invalid JSON format: invalid \"name\":\"value\" pair in system property "));
                }
            }
        }
        return retRange;
    }

    private static String createLocalKVSecurity(String loginFlnm, String trustFlnm) throws IOException {
        File trustPropFd;
        String trustProp;
        if (loginFlnm == null) {
            return null;
        }
        if (trustFlnm == null) {
            return null;
        }
        File userSecurityDirFd = new File(USER_SECURITY_DIR);
        if (!userSecurityDirFd.exists() && !userSecurityDirFd.mkdirs()) {
            throw new IOException("failed to create " + userSecurityDirFd);
        }
        InputStream loginStream = null;
        InputStream trustStream = null;
        ClassLoader cl = TableRecordReaderBase.class.getClassLoader();
        if (cl != null) {
            loginStream = cl.getResourceAsStream(loginFlnm);
            trustStream = cl.getResourceAsStream(trustFlnm);
        } else {
            loginStream = ClassLoader.getSystemResourceAsStream(loginFlnm);
            trustStream = ClassLoader.getSystemResourceAsStream(trustFlnm);
        }
        Properties loginProps = new Properties();
        if (loginStream != null) {
            loginProps.load(loginStream);
        }
        if ((trustProp = loginProps.getProperty("oracle.kv.ssl.trustStore")) != null && !(trustPropFd = new File(trustProp)).exists()) {
            loginProps.setProperty("oracle.kv.ssl.trustStore", trustPropFd.getName());
        }
        File loginFd = new File(USER_SECURITY_DIR + FILE_SEP + loginFlnm);
        FileOutputStream loginFos = new FileOutputStream(loginFd);
        loginProps.store(loginFos, null);
        loginFos.close();
        File trustFd = new File(USER_SECURITY_DIR + FILE_SEP + trustFlnm);
        FileOutputStream trustFlnmFos = new FileOutputStream(trustFd);
        if (trustStream != null) {
            int nextByte = trustStream.read();
            while (nextByte != -1) {
                trustFlnmFos.write(nextByte);
                nextByte = trustStream.read();
            }
        }
        trustFlnmFos.close();
        return loginFd.toString();
    }

    public Table getKvTable() {
        return this.kvTable;
    }

    public void setIndexKey(IndexKey key) {
        this.indexKey = key;
        this.primaryKey = null;
    }

    public void setPrimaryKey(PrimaryKey key) {
        this.primaryKey = key;
        this.indexKey = null;
    }

    public void setMultiRowOptions(FieldRange fieldRange) {
        this.rowOpts = new MultiRowOptions(fieldRange);
    }

    public void setStore(KVStore testStore) {
        this.kvstore = testStore;
    }

    public void setQueryInfo(int newQueryBy, String newWhereClause) {
        this.queryBy = newQueryBy;
        this.whereClause = newWhereClause;
    }
}

