/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop.hive.table;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.kv.ParamConstant;
import oracle.kv.PasswordCredentials;
import oracle.kv.hadoop.hive.table.TableHiveInputFormat;
import oracle.kv.hadoop.hive.table.TableHiveInputSplit;
import oracle.kv.hadoop.table.TableInputFormat;
import oracle.kv.hadoop.table.TableInputSplit;
import oracle.kv.table.PrimaryKey;
import oracle.kv.table.Row;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.util.ReflectionUtils;

public final class V1V2TableUtil {
    private static final Object V1_V2_UTIL_LOCK = new Object();
    private static final Log LOG = LogFactory.getLog((String)"oracle.kv.hadoop.hive.table.V1V2TableUtil");
    private static InputFormat<PrimaryKey, Row> v2InputFormat;
    private static Map<TableHiveInputSplit, TableInputSplit> v1V2SplitMap;

    private V1V2TableUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<TableHiveInputSplit, TableInputSplit> getSplitMap(JobConf jobConf, TableHiveInputSplit inputSplit, int queryBy, String whereClause, Integer shardKeyPartitionId) throws IOException {
        Object object = V1_V2_UTIL_LOCK;
        synchronized (object) {
            if (v1V2SplitMap == null) {
                V1V2TableUtil.getInputFormat(jobConf, inputSplit, queryBy, whereClause, shardKeyPartitionId);
            }
            return v1V2SplitMap;
        }
    }

    public static Map<TableHiveInputSplit, TableInputSplit> getSplitMap(JobConf jobConf, int queryBy, String whereClause, Integer shardKeyPartitionId) throws IOException {
        return V1V2TableUtil.getSplitMap(jobConf, null, queryBy, whereClause, shardKeyPartitionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputFormat<PrimaryKey, Row> getInputFormat(JobConf jobConf, TableHiveInputSplit inputSplit, int queryBy, String whereClause, Integer shardKeyPartitionId) throws IOException {
        Path[] tablePaths = FileInputFormat.getInputPaths((JobConf)jobConf);
        if (tablePaths == null || tablePaths.length == 0) {
            LOG.debug((Object)("FileInputFormat.getInputPaths returned " + (tablePaths == null ? "NULL" : "zero length array")));
            tablePaths = inputSplit != null ? new Path[]{inputSplit.getPath()} : new Path[]{new Path("/TABLE_PATHS_NOT_SET")};
        }
        LOG.debug((Object)("tablePaths[0] = " + tablePaths[0]));
        V1V2TableUtil.getStoreInfo(jobConf, inputSplit);
        Object object = V1_V2_UTIL_LOCK;
        synchronized (object) {
            if (v2InputFormat == null) {
                v2InputFormat = (InputFormat)ReflectionUtils.newInstance(TableInputFormat.class, (Configuration)jobConf);
                ((TableInputFormat)v2InputFormat).setQueryInfo(queryBy, whereClause, shardKeyPartitionId);
                v1V2SplitMap = new HashMap<TableHiveInputSplit, TableInputSplit>();
                try {
                    List v2Splits = v2InputFormat.getSplits((JobContext)new Job((Configuration)jobConf));
                    for (InputSplit curV2Split : v2Splits) {
                        v1V2SplitMap.put(new TableHiveInputSplit(tablePaths[0], (TableInputSplit)curV2Split), (TableInputSplit)curV2Split);
                    }
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            }
            return v2InputFormat;
        }
    }

    public static InputFormat<PrimaryKey, Row> getInputFormat(JobConf jobConf, int queryBy, String whereClause, Integer shardKeyPartitionId) throws IOException {
        return V1V2TableUtil.getInputFormat(jobConf, null, queryBy, whereClause, shardKeyPartitionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetInputJobInfoForNewQuery() {
        Object object = V1_V2_UTIL_LOCK;
        synchronized (object) {
            TableHiveInputFormat.resetQueryInfo();
            if (v1V2SplitMap != null) {
                v1V2SplitMap.clear();
                v1V2SplitMap = null;
            }
            v2InputFormat = null;
        }
    }

    private static void getStoreInfo(JobConf jobConf, TableHiveInputSplit split) {
        PasswordCredentials passwordCredentials;
        File pwdLocFd;
        PasswordCredentials passwordCredentials2;
        String trustFile;
        String loginFile;
        String tableName;
        String[] hostsArray;
        String hostsStr;
        String storeName = jobConf.get(ParamConstant.KVSTORE_NAME.getName());
        if (storeName == null && split != null && (storeName = split.getKVStoreName()) != null) {
            jobConf.set(ParamConstant.KVSTORE_NAME.getName(), storeName);
        }
        if ((hostsStr = jobConf.get(ParamConstant.KVSTORE_NODES.getName())) == null && split != null && (hostsArray = split.getKVHelperHosts()) != null) {
            StringBuilder buf = new StringBuilder(hostsArray[0]);
            for (int i = 1; i < hostsArray.length; ++i) {
                buf.append("," + hostsArray[i]);
            }
            hostsStr = buf.toString();
            jobConf.set(ParamConstant.KVSTORE_NODES.getName(), hostsStr);
        }
        if ((tableName = jobConf.get(ParamConstant.TABLE_NAME.getName())) == null && split != null && (tableName = split.getTableName()) != null) {
            jobConf.set(ParamConstant.TABLE_NAME.getName(), tableName);
        }
        if ((loginFile = jobConf.get("oracle.kv.security")) == null) {
            if (split != null && (loginFile = split.getSecurityLogin()) != null) {
                jobConf.set("oracle.kv.security", loginFile);
            }
        } else {
            File loginFileFd = new File(loginFile);
            if (!loginFileFd.exists()) {
                if (split != null) {
                    loginFile = split.getSecurityLogin();
                    jobConf.set("oracle.kv.security", loginFile);
                }
            } else {
                jobConf.set("oracle.kv.security", loginFile);
            }
        }
        if ((trustFile = jobConf.get("oracle.kv.ssl.trustStore")) == null) {
            if (split != null && (trustFile = split.getSecurityTrust()) != null) {
                jobConf.set("oracle.kv.ssl.trustStore", trustFile);
            }
        } else {
            File trustFileFd = new File(trustFile);
            if (!trustFileFd.exists()) {
                if (split != null) {
                    trustFile = split.getSecurityTrust();
                    jobConf.set("oracle.kv.ssl.trustStore", trustFile);
                }
            } else {
                jobConf.set("oracle.kv.ssl.trustStore", trustFile);
            }
        }
        String walletLoc = jobConf.get("oracle.kv.auth.wallet.dir");
        String pwdLoc = jobConf.get("oracle.kv.auth.pwdfile.file");
        if (walletLoc == null && pwdLoc == null && split != null && (passwordCredentials2 = split.getSecurityCredentials()) != null) {
            jobConf.set("oracle.kv.auth.username", passwordCredentials2.getUsername());
            jobConf.set(ParamConstant.AUTH_USER_PWD_PROPERTY.getName(), String.valueOf(passwordCredentials2.getPassword()));
        }
        if (walletLoc != null) {
            PasswordCredentials passwordCredentials3;
            File walletLocFd = new File(walletLoc);
            if (!walletLocFd.exists() && split != null && (passwordCredentials3 = split.getSecurityCredentials()) != null) {
                jobConf.set("oracle.kv.auth.username", passwordCredentials3.getUsername());
                jobConf.set(ParamConstant.AUTH_USER_PWD_PROPERTY.getName(), String.valueOf(passwordCredentials3.getPassword()));
            }
        } else if (pwdLoc != null && !(pwdLocFd = new File(pwdLoc)).exists() && split != null && (passwordCredentials = split.getSecurityCredentials()) != null) {
            jobConf.set("oracle.kv.auth.username", passwordCredentials.getUsername());
            jobConf.set(ParamConstant.AUTH_USER_PWD_PROPERTY.getName(), String.valueOf(passwordCredentials.getPassword()));
        }
    }
}

