/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop.hive.table;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.kv.hadoop.hive.table.TableHiveInputFormat;
import oracle.kv.hadoop.hive.table.V1V2TableUtil;
import oracle.kv.hadoop.table.TableRecordReader;
import oracle.kv.table.FieldRange;
import oracle.kv.table.Index;
import oracle.kv.table.IndexKey;
import oracle.kv.table.PrimaryKey;
import oracle.kv.table.Row;
import oracle.kv.table.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.index.IndexPredicateAnalyzer;
import org.apache.hadoop.hive.ql.index.IndexSearchCondition;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;

public class TableHiveRecordReader
implements RecordReader<Text, Text> {
    private static final Log LOG = LogFactory.getLog((String)"oracle.kv.hadoop.hive.table.TableHiveRecordReader");
    private TableRecordReader v2RecordReader;

    public TableHiveRecordReader(JobConf jobConf, TableRecordReader v2RecordReader) {
        this.initialize(jobConf, v2RecordReader);
    }

    public void close() throws IOException {
        if (this.v2RecordReader != null) {
            this.v2RecordReader.close();
            this.v2RecordReader = null;
        }
        V1V2TableUtil.resetInputJobInfoForNewQuery();
        LOG.trace((Object)"close");
    }

    public long getPos() throws IOException {
        LOG.trace((Object)"getPos");
        return 0L;
    }

    public float getProgress() {
        LOG.trace((Object)"getProgress");
        return this.v2RecordReader.getProgress();
    }

    public boolean next(Text key, Text value) {
        LOG.trace((Object)("next [key = " + key + ", value = " + value + "]"));
        if (key == null || value == null) {
            return false;
        }
        boolean ret = false;
        try {
            key.clear();
            value.clear();
            ret = this.v2RecordReader.nextKeyValue();
            if (ret) {
                Row curRow = this.v2RecordReader.getCurrentValue();
                assert (curRow != null);
                key.set(curRow.createPrimaryKey().toString());
                value.set(curRow.toString());
            }
        }
        catch (Exception e) {
            LOG.error((Object)("TableHiveRecordReader " + this + " caught: " + e), (Throwable)e);
        }
        return ret;
    }

    public Text createKey() {
        return new Text();
    }

    public Text createValue() {
        return new Text();
    }

    private void initialize(JobConf jobConf, TableRecordReader v2RecRdr) {
        LOG.trace((Object)"open");
        String filterExprPropVal = jobConf.get("hive.io.filter.expr.serialized");
        if (filterExprPropVal != null) {
            List hiveFilterCols;
            ExprNodeGenericFuncDesc filterExpr = Utilities.deserializeExpression((String)filterExprPropVal);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Hive query = " + HiveConf.getVar((Configuration)jobConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEQUERYSTRING)));
                LOG.trace((Object)("deserialized predicate = " + filterExpr));
                StringBuilder whereClause = new StringBuilder();
                TableHiveInputFormat.buildPushPredicate((ExprNodeDesc)filterExpr, whereClause);
                LOG.trace((Object)("where clause = " + whereClause.toString()));
            }
            if ((hiveFilterCols = filterExpr.getCols()) != null) {
                Table table;
                IndexPredicateAnalyzer analyzer = TableHiveInputFormat.basicPredicateAnalyzer(hiveFilterCols);
                ArrayList<IndexSearchCondition> hiveSearchConditions = new ArrayList<IndexSearchCondition>();
                analyzer.analyzePredicate((ExprNodeDesc)filterExpr, hiveSearchConditions);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("search conditions to validate = " + hiveSearchConditions));
                }
                if ((table = v2RecRdr.getKvTable()) != null) {
                    if (TableHiveInputFormat.searchConditionsValid(hiveSearchConditions, table)) {
                        FieldRange fieldRange = null;
                        PrimaryKey primaryKey = null;
                        IndexKey indexKey = TableHiveInputFormat.indexKeyFromSearchConditionsNoRange(hiveSearchConditions, table);
                        if (indexKey != null) {
                            v2RecRdr.setIndexKey(indexKey);
                            fieldRange = this.indexFieldRangeFromSearchConditions(hiveSearchConditions, indexKey.getIndex());
                        } else {
                            primaryKey = this.primaryKeyFromSearchConditionsNoRange(hiveSearchConditions, table);
                            if (primaryKey != null) {
                                v2RecRdr.setPrimaryKey(primaryKey);
                                fieldRange = this.primaryFieldRangeFromSearchConditions(hiveSearchConditions, table);
                            }
                        }
                        v2RecRdr.setMultiRowOptions(fieldRange);
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("primaryKey = " + primaryKey));
                            LOG.trace((Object)("indexKey = " + indexKey));
                        }
                    } else {
                        LOG.trace((Object)"search conditions not valid for PrimaryKey or IndexKey iteration. Convert predicate to native query string");
                    }
                }
            }
        }
        this.v2RecordReader = v2RecRdr;
    }

    private PrimaryKey primaryKeyFromSearchConditionsNoRange(List<IndexSearchCondition> searchConditions, Table table) {
        if (searchConditions == null || table == null) {
            return null;
        }
        List<String> tableFields = TableHiveInputFormat.getPrimaryColumnsLower(table);
        if (tableFields == null || tableFields.isEmpty()) {
            return null;
        }
        HashMap<String, IndexSearchCondition> searchCondMap = new HashMap<String, IndexSearchCondition>();
        for (IndexSearchCondition cond : searchConditions) {
            String colName = cond.getColumnDesc().getColumn().toLowerCase();
            if (!GenericUDFOPEqual.class.getName().equals(cond.getComparisonOp())) continue;
            searchCondMap.put(colName, cond);
        }
        PrimaryKey primaryKey = table.createPrimaryKey();
        if (searchCondMap.isEmpty()) {
            return primaryKey;
        }
        if (tableFields.containsAll(searchCondMap.keySet())) {
            List<String> fieldNames = primaryKey.getFields();
            for (String fieldName : fieldNames) {
                IndexSearchCondition searchCond = (IndexSearchCondition)searchCondMap.get(fieldName.toLowerCase());
                if (searchCond == null) {
                    return primaryKey;
                }
                TableHiveInputFormat.populateKey(fieldName, searchCond.getConstantDesc(), primaryKey);
            }
        }
        return primaryKey;
    }

    private FieldRange indexFieldRangeFromSearchConditions(List<IndexSearchCondition> searchConditions, Index index) {
        if (searchConditions == null || index == null) {
            return null;
        }
        ArrayList<IndexSearchCondition> rangeSearchConds = new ArrayList<IndexSearchCondition>();
        for (IndexSearchCondition cond : searchConditions) {
            String op = cond.getComparisonOp();
            if (!GenericUDFOPGreaterThan.class.getName().equals(op) && !GenericUDFOPEqualOrGreaterThan.class.getName().equals(op) && !GenericUDFOPLessThan.class.getName().equals(op) && !GenericUDFOPEqualOrLessThan.class.getName().equals(op)) continue;
            rangeSearchConds.add(cond);
        }
        if (rangeSearchConds.isEmpty()) {
            return null;
        }
        String colNameLower = ((IndexSearchCondition)rangeSearchConds.get(0)).getColumnDesc().getColumn().toLowerCase();
        for (String fieldName : index.getFields()) {
            if (!fieldName.toLowerCase().equals(colNameLower)) continue;
            return this.createFieldRange(fieldName, rangeSearchConds, index);
        }
        return null;
    }

    private FieldRange primaryFieldRangeFromSearchConditions(List<IndexSearchCondition> searchConditions, Table table) {
        if (searchConditions == null || table == null) {
            return null;
        }
        ArrayList<IndexSearchCondition> rangeSearchConds = new ArrayList<IndexSearchCondition>();
        for (IndexSearchCondition cond : searchConditions) {
            String op = cond.getComparisonOp();
            if (!GenericUDFOPGreaterThan.class.getName().equals(op) && !GenericUDFOPEqualOrGreaterThan.class.getName().equals(op) && !GenericUDFOPLessThan.class.getName().equals(op) && !GenericUDFOPEqualOrLessThan.class.getName().equals(op)) continue;
            rangeSearchConds.add(cond);
        }
        if (rangeSearchConds.isEmpty()) {
            return null;
        }
        List<String> tableFields = TableHiveInputFormat.getPrimaryColumnsLower(table);
        if (tableFields == null || tableFields.isEmpty()) {
            return null;
        }
        String colNameLower = ((IndexSearchCondition)rangeSearchConds.get(0)).getColumnDesc().getColumn().toLowerCase();
        PrimaryKey primaryKey = table.createPrimaryKey();
        List<String> fieldNames = primaryKey.getFields();
        for (String fieldName : fieldNames) {
            if (!fieldName.toLowerCase().equals(colNameLower)) continue;
            return this.createFieldRange(fieldName, rangeSearchConds, table);
        }
        return null;
    }

    private FieldRange createFieldRange(String fieldName, List<IndexSearchCondition> conditions, Index index) {
        return this.createFieldRange(fieldName, conditions, index, null);
    }

    private FieldRange createFieldRange(String fieldName, List<IndexSearchCondition> conditions, Table table) {
        return this.createFieldRange(fieldName, conditions, null, table);
    }

    private FieldRange createFieldRange(String fieldName, List<IndexSearchCondition> conditions, Index index, Table table) {
        if (!this.rangeConditionsValid(conditions)) {
            return null;
        }
        IndexSearchCondition cond0 = conditions.get(0);
        IndexSearchCondition cond1 = conditions.get(1);
        String op0 = cond0.getComparisonOp();
        String op1 = cond1.getComparisonOp();
        ExprNodeConstantDesc constantDesc0 = cond0.getConstantDesc();
        ExprNodeConstantDesc constantDesc1 = cond1.getConstantDesc();
        FieldRange fieldRange = null;
        if (index != null) {
            fieldRange = index.createFieldRange(fieldName);
        } else if (table != null) {
            fieldRange = table.createFieldRange(fieldName);
        } else {
            return null;
        }
        if (GenericUDFOPGreaterThan.class.getName().equals(op0)) {
            this.setStart(fieldRange, constantDesc0, false);
        }
        if (GenericUDFOPEqualOrGreaterThan.class.getName().equals(op0)) {
            this.setStart(fieldRange, constantDesc0, true);
        }
        if (GenericUDFOPLessThan.class.getName().equals(op0)) {
            this.setEnd(fieldRange, constantDesc0, false);
        }
        if (GenericUDFOPEqualOrLessThan.class.getName().equals(op0)) {
            this.setEnd(fieldRange, constantDesc0, true);
        }
        if (GenericUDFOPGreaterThan.class.getName().equals(op1)) {
            this.setStart(fieldRange, constantDesc1, false);
        }
        if (GenericUDFOPEqualOrGreaterThan.class.getName().equals(op1)) {
            this.setStart(fieldRange, constantDesc1, true);
        }
        if (GenericUDFOPLessThan.class.getName().equals(op1)) {
            this.setEnd(fieldRange, constantDesc1, false);
        }
        if (GenericUDFOPEqualOrLessThan.class.getName().equals(op1)) {
            this.setEnd(fieldRange, constantDesc1, true);
        }
        return fieldRange;
    }

    private boolean rangeConditionsValid(List<IndexSearchCondition> conds) {
        String colName1;
        if (conds.size() != 2) {
            return false;
        }
        IndexSearchCondition cond0 = conds.get(0);
        IndexSearchCondition cond1 = conds.get(1);
        String colName0 = cond0.getColumnDesc().getColumn();
        if (!colName0.equals(colName1 = cond1.getColumnDesc().getColumn())) {
            return false;
        }
        String op0 = cond0.getComparisonOp();
        String op1 = cond1.getComparisonOp();
        return !(GenericUDFOPGreaterThan.class.getName().equals(op0) || GenericUDFOPEqualOrGreaterThan.class.getName().equals(op0) ? !GenericUDFOPLessThan.class.getName().equals(op1) && !GenericUDFOPEqualOrLessThan.class.getName().equals(op1) : (GenericUDFOPLessThan.class.getName().equals(op0) || GenericUDFOPEqualOrLessThan.class.getName().equals(op0)) && !GenericUDFOPGreaterThan.class.getName().equals(op1) && !GenericUDFOPEqualOrGreaterThan.class.getName().equals(op1));
    }

    private void setStart(FieldRange fieldRange, ExprNodeConstantDesc constantDesc, boolean isInclusive) {
        String typeName = constantDesc.getTypeInfo().getTypeName();
        Object value = constantDesc.getValue();
        if ("int".equals(typeName)) {
            fieldRange.setStart((Integer)value, isInclusive);
        } else if ("bigint".equals(typeName)) {
            fieldRange.setStart((Long)value, isInclusive);
        } else if ("float".equals(typeName)) {
            fieldRange.setStart(((Float)value).floatValue(), isInclusive);
        } else if ("decimal".equals(typeName)) {
            fieldRange.setStart(((Float)value).floatValue(), isInclusive);
        } else if ("double".equals(typeName)) {
            fieldRange.setStart((Double)value, isInclusive);
        } else if ("string".equals(typeName)) {
            fieldRange.setStart((String)value, isInclusive);
        }
    }

    private void setEnd(FieldRange fieldRange, ExprNodeConstantDesc constantDesc, boolean isInclusive) {
        String typeName = constantDesc.getTypeInfo().getTypeName();
        Object value = constantDesc.getValue();
        if ("int".equals(typeName)) {
            fieldRange.setEnd((Integer)value, isInclusive);
        } else if ("bigint".equals(typeName)) {
            fieldRange.setEnd((Long)value, isInclusive);
        } else if ("float".equals(typeName)) {
            fieldRange.setEnd(((Float)value).floatValue(), isInclusive);
        } else if ("decimal".equals(typeName)) {
            fieldRange.setEnd(((Float)value).floatValue(), isInclusive);
        } else if ("double".equals(typeName)) {
            fieldRange.setEnd((Double)value, isInclusive);
        } else if ("string".equals(typeName)) {
            fieldRange.setEnd((String)value, isInclusive);
        }
    }
}

