/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop.hive.table;

import oracle.kv.table.FieldValue;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BooleanWritable;

public class TableBooleanObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements SettableBooleanObjectInspector {
    TableBooleanObjectInspector() {
        super(TypeInfoFactory.booleanTypeInfo);
    }

    public Object getPrimitiveWritableObject(Object o) {
        return o == null ? null : new BooleanWritable(this.get(o));
    }

    public boolean get(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof FieldValue) {
            return ((FieldValue)o).asBoolean().get();
        }
        throw new IllegalArgumentException("invalid object type: must be Boolean or BooleanValue");
    }

    public Object create(boolean value) {
        return value ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object set(Object o, boolean value) {
        return value ? Boolean.TRUE : Boolean.FALSE;
    }
}

