/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop.hive.table;

import java.util.Arrays;
import oracle.kv.table.BinaryValue;
import oracle.kv.table.FixedBinaryValue;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BytesWritable;

public class TableBinaryObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements SettableBinaryObjectInspector {
    TableBinaryObjectInspector() {
        super(TypeInfoFactory.binaryTypeInfo);
    }

    public byte[] copyObject(Object o) {
        if (null == o) {
            return null;
        }
        byte[] incoming = (byte[])o;
        byte[] outgoing = new byte[incoming.length];
        System.arraycopy(incoming, 0, outgoing, 0, incoming.length);
        return outgoing;
    }

    public BytesWritable getPrimitiveWritableObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof byte[]) {
            return new BytesWritable((byte[])o);
        }
        if (o instanceof BinaryValue) {
            BinaryValue binaryValue = (BinaryValue)o;
            return new BytesWritable(binaryValue.get());
        }
        if (o instanceof FixedBinaryValue) {
            FixedBinaryValue fixedBinaryValue = (FixedBinaryValue)o;
            return new BytesWritable(fixedBinaryValue.get());
        }
        throw new IllegalArgumentException("invalid input object: must be byte[], BinaryValue, or FixedBinaryValue");
    }

    public byte[] getPrimitiveJavaObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof byte[]) {
            return (byte[])o;
        }
        if (o instanceof BinaryValue) {
            BinaryValue binaryValue = (BinaryValue)o;
            return binaryValue.get();
        }
        if (o instanceof FixedBinaryValue) {
            FixedBinaryValue fixedBinaryValue = (FixedBinaryValue)o;
            return fixedBinaryValue.get();
        }
        throw new IllegalArgumentException("invalid input object: must be byte[], BinaryValue, or FixedBinaryValue");
    }

    public byte[] set(Object o, byte[] bb) {
        return bb == null ? null : Arrays.copyOf(bb, bb.length);
    }

    public byte[] set(Object o, BytesWritable bw) {
        return bw == null ? null : LazyUtils.createByteArray((BytesWritable)bw);
    }

    public byte[] create(byte[] bb) {
        return bb == null ? null : Arrays.copyOf(bb, bb.length);
    }

    public byte[] create(BytesWritable bw) {
        return bw == null ? null : LazyUtils.createByteArray((BytesWritable)bw);
    }
}

