/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop.hive.table;

import java.util.Arrays;
import java.util.List;
import oracle.kv.table.ArrayValue;
import oracle.kv.table.FieldValue;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;

public class TableArrayObjectInspector
extends StandardListObjectInspector {
    TableArrayObjectInspector(ObjectInspector listElementObjectInspector) {
        super(listElementObjectInspector);
    }

    public Object getListElement(Object data, int index) {
        if (data == null || index < 0) {
            return null;
        }
        if (data instanceof FieldValue) {
            ArrayValue arrayValue = ((FieldValue)data).asArray();
            if (index >= arrayValue.size()) {
                return null;
            }
            return arrayValue.get(index);
        }
        if (data instanceof List) {
            List list = (List)data;
            if (index >= list.size()) {
                return null;
            }
            return list.get(index);
        }
        Object[] arr = (Object[])data;
        if (index >= arr.length) {
            return null;
        }
        return arr[index];
    }

    public int getListLength(Object data) {
        if (data == null) {
            return -1;
        }
        if (data instanceof FieldValue) {
            ArrayValue arrayValue = ((FieldValue)data).asArray();
            return arrayValue.size();
        }
        if (data instanceof List) {
            List list = (List)data;
            return list.size();
        }
        Object[] arr = (Object[])data;
        return arr.length;
    }

    public List<?> getList(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof FieldValue) {
            ArrayValue arrayValue = ((FieldValue)data).asArray();
            return arrayValue.toList();
        }
        if (data instanceof List) {
            return (List)data;
        }
        return Arrays.asList((Object[])data);
    }
}

