/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import oracle.kv.impl.util.FastExternalizable;

public class Value
implements FastExternalizable {
    public static final Value EMPTY_VALUE = Value.createValue(new byte[0]);
    private final byte[] val;
    private final Format format;

    private Value(byte[] val, Format format) {
        this.val = val;
        this.format = format;
    }

    public Value(DataInput in, short serialVersion) throws IOException {
        int len = in.readInt();
        if (len == 0) {
            throw new IllegalStateException("Value is zero length, format discriminator is missing");
        }
        byte firstByte = in.readByte();
        this.format = Format.fromFirstByte(firstByte);
        if (this.format == Format.NONE || this.format == Format.TABLE) {
            this.val = new byte[len - 1];
            in.readFully(this.val);
            return;
        }
        this.val = new byte[len];
        this.val[0] = firstByte;
        in.readFully(this.val, 1, len - 1);
    }

    public static byte[] readFastExternal(DataInput in, short serialVersion) throws IOException {
        int len = in.readInt();
        if (len == 0) {
            throw new IllegalStateException("Value is zero length, format discriminator is missing");
        }
        byte[] bytes = new byte[len];
        in.readFully(bytes);
        return bytes;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        if (this.format == Format.NONE || this.format == Format.TABLE) {
            out.writeInt(this.val.length + 1);
            out.write(this.format == Format.NONE ? 0 : 1);
            out.write(this.val);
            return;
        }
        out.writeInt(this.val.length);
        out.write(this.val);
    }

    public static void writeFastExternal(DataOutput out, short serialVersion, byte[] bytes) throws IOException {
        if (bytes.length == 0) {
            throw new IllegalStateException("Value is zero length, format discriminator is missing");
        }
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    public byte[] toByteArray() {
        if (this.format == Format.NONE || this.format == Format.TABLE) {
            byte[] bytes = new byte[this.val.length + 1];
            bytes[0] = (byte)(this.format != Format.NONE ? 1 : 0);
            System.arraycopy(this.val, 0, bytes, 1, this.val.length);
            return bytes;
        }
        return this.val;
    }

    public static Value fromByteArray(byte[] bytes) {
        if (bytes.length == 0) {
            throw new IllegalStateException("Value is zero length, format discriminator is missing");
        }
        Format format = Format.fromFirstByte(bytes[0]);
        if (format == Format.NONE || format == Format.TABLE) {
            byte[] val = new byte[bytes.length - 1];
            System.arraycopy(bytes, 1, val, 0, val.length);
            return new Value(val, format);
        }
        byte[] val = bytes;
        return new Value(val, format);
    }

    public static Value createValue(byte[] val) {
        assert (val != null);
        return new Value(val, Format.NONE);
    }

    public static Value internalCreateValue(byte[] val, Format format) {
        return new Value(val, format);
    }

    public byte[] getValue() {
        return this.val;
    }

    public Format getFormat() {
        return this.format;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Value)) {
            return false;
        }
        Value o = (Value)other;
        if (this.format != o.format) {
            return false;
        }
        return Arrays.equals(this.val, o.val);
    }

    public int hashCode() {
        return this.format.hashCode() + this.val.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("<Value format:");
        sb.append((Object)this.format);
        sb.append(" bytes:");
        for (int i = 0; i < 100 && i < this.val.length; ++i) {
            sb.append(' ');
            sb.append(this.val[i]);
        }
        if (this.val.length > 100) {
            sb.append(" ...");
        }
        sb.append(">");
        return sb.toString();
    }

    public static enum Format {
        NONE,
        AVRO,
        TABLE;


        public static Format fromFirstByte(int firstByte) {
            if (firstByte == 0) {
                return NONE;
            }
            if (firstByte == 1) {
                return TABLE;
            }
            if (firstByte < 0) {
                return AVRO;
            }
            throw new IllegalStateException("Value has unknown format discriminator: " + firstByte);
        }
    }
}

