/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import oracle.kv.FaultException;
import oracle.kv.Key;
import oracle.kv.impl.util.FastExternalizable;

public class KeyRange
implements FastExternalizable {
    private static final int FLAG_START = 1;
    private static final int FLAG_START_INCLUSIVE = 2;
    private static final int FLAG_END = 4;
    private static final int FLAG_END_INCLUSIVE = 8;
    private final String start;
    private final boolean startInclusive;
    private final String end;
    private final boolean endInclusive;

    public KeyRange(String start, boolean startInclusive, String end, boolean endInclusive) {
        if (start == null && end == null) {
            throw new IllegalArgumentException("start or end must be non-null");
        }
        if (!(start == null || end == null || start.compareTo(end) <= 0 && (start.compareTo(end) != 0 || startInclusive && endInclusive))) {
            throw new IllegalArgumentException("start key must be less than the end key. (" + start + "," + end + ")");
        }
        this.start = start;
        this.startInclusive = startInclusive;
        this.end = end;
        this.endInclusive = endInclusive;
    }

    public KeyRange(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix must be non-null");
        }
        this.start = prefix;
        this.startInclusive = true;
        this.end = prefix;
        this.endInclusive = true;
    }

    public KeyRange(DataInput in, short serialVersion) throws IOException {
        int flags = in.readUnsignedByte();
        this.startInclusive = (flags & 2) != 0;
        this.endInclusive = (flags & 8) != 0;
        this.start = (flags & 1) != 0 ? in.readUTF() : null;
        this.end = (flags & 4) != 0 ? in.readUTF() : null;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        int flags = 0;
        if (this.start != null) {
            flags |= 1;
        }
        if (this.startInclusive) {
            flags |= 2;
        }
        if (this.end != null) {
            flags |= 4;
        }
        if (this.endInclusive) {
            flags |= 8;
        }
        out.writeByte(flags);
        if (this.start != null) {
            out.writeUTF(this.start);
        }
        if (this.end != null) {
            out.writeUTF(this.end);
        }
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(200);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeShort(13);
            this.writeFastExternal(oos, (short)13);
            oos.flush();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new FaultException(e, false);
        }
    }

    public static KeyRange fromByteArray(byte[] keyBytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(keyBytes);
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            short serialVersion = ois.readShort();
            return new KeyRange(ois, serialVersion);
        }
        catch (IOException e) {
            throw new FaultException(e, false);
        }
    }

    public String getStart() {
        return this.start;
    }

    public boolean getStartInclusive() {
        return this.startInclusive;
    }

    public String getEnd() {
        return this.end;
    }

    public boolean getEndInclusive() {
        return this.endInclusive;
    }

    public boolean isPrefix() {
        return this.start != null && this.startInclusive && this.start.equals(this.end) && this.endInclusive;
    }

    public boolean inRange(Key parentKey, Key checkKey) {
        int parentPathSize;
        List<String> checkPath;
        if (checkKey == null) {
            throw new IllegalArgumentException("checkKey must be non-null");
        }
        if (parentKey != null && !parentKey.isPrefix(checkKey)) {
            return false;
        }
        if (parentKey == null) {
            checkPath = checkKey.getMajorPath();
            parentPathSize = 0;
        } else if (parentKey.getMajorPath().size() == checkKey.getMajorPath().size()) {
            checkPath = checkKey.getMinorPath();
            parentPathSize = parentKey.getMinorPath().size();
        } else {
            checkPath = checkKey.getMajorPath();
            parentPathSize = parentKey.getMajorPath().size();
        }
        if (checkPath.size() <= parentPathSize) {
            return false;
        }
        String checkComp = checkPath.get(parentPathSize);
        if (this.isPrefix()) {
            return checkComp.startsWith(this.start);
        }
        return this.checkStart(checkComp) && this.checkEnd(checkComp);
    }

    private boolean checkStart(String checkComp) {
        if (this.start == null) {
            return true;
        }
        int cmp = checkComp.compareTo(this.start);
        return this.startInclusive ? cmp >= 0 : cmp > 0;
    }

    private boolean checkEnd(String checkComp) {
        if (this.end == null) {
            return true;
        }
        int cmp = checkComp.compareTo(this.end);
        return this.endInclusive ? cmp <= 0 : cmp < 0;
    }

    public boolean equals(Object other) {
        if (!(other instanceof KeyRange)) {
            return false;
        }
        KeyRange o = (KeyRange)other;
        if (this.start == null != (o.start == null)) {
            return false;
        }
        if (this.start != null && !this.start.equals(o.start)) {
            return false;
        }
        if (this.end == null != (o.end == null)) {
            return false;
        }
        if (this.end != null && !this.end.equals(o.end)) {
            return false;
        }
        if (this.start != null && this.startInclusive != o.startInclusive) {
            return false;
        }
        return this.end == null || this.endInclusive == o.endInclusive;
    }

    public int hashCode() {
        return (this.start != null ? this.start.hashCode() : 0) + (this.end != null ? this.end.hashCode() : 0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        if (this.start != null) {
            Key startKey = Key.createKey(this.start);
            sb.append(this.startInclusive ? "I" : "E");
            sb.append("/");
            sb.append(startKey.toString().substring(1));
            sb.append("/");
        }
        if (this.end != null) {
            Key endKey = Key.createKey(this.end);
            if (this.start == null) {
                sb.append("/");
            }
            sb.append(endKey.toString().substring(1));
            sb.append("/");
            sb.append(this.endInclusive ? "I" : "E");
        }
        return sb.toString();
    }

    public static KeyRange fromString(String keyRangeStringArg) {
        int lastCharIdx;
        String lastChar;
        String keyRangeString = keyRangeStringArg;
        if (keyRangeString == null || keyRangeString.length() == 0) {
            throw new IllegalArgumentException("Null or zero-length argument to KeyRange.fromString()");
        }
        String retStart = null;
        boolean retStartInclusive = false;
        String retEnd = null;
        boolean retEndInclusive = false;
        String firstChar = keyRangeString.substring(0, 1);
        if ("I".equals(firstChar) || "E".equals(firstChar)) {
            retStartInclusive = "I".equals(firstChar);
            if (!"/".equals(keyRangeString.substring(1, 2))) {
                throw new IllegalArgumentException("Couldn't find starting / for start key in KeyRange. (" + keyRangeStringArg + ")");
            }
            int endOfStartKeyIdx = (keyRangeString = keyRangeString.substring(2)).indexOf("/");
            if (endOfStartKeyIdx < 0) {
                throw new IllegalArgumentException("Couldn't find closing / for start key in KeyRange. (" + keyRangeStringArg + ")");
            }
            retStart = keyRangeString.substring(0, endOfStartKeyIdx);
            keyRangeString = keyRangeString.substring(endOfStartKeyIdx);
        }
        if ("I".equals(lastChar = keyRangeString.substring(lastCharIdx = keyRangeString.length() - 1)) || "E".equals(lastChar)) {
            retEndInclusive = "I".equals(lastChar);
            if (!"/".equals(keyRangeString.substring(0, 1))) {
                throw new IllegalArgumentException("Couldn't find starting / for end key in KeyRange.");
            }
            if (--lastCharIdx < 1 || !"/".equals(keyRangeString.substring(lastCharIdx, lastCharIdx + 1))) {
                throw new IllegalArgumentException("Couldn't find ending / for end key in KeyRange. (" + keyRangeStringArg + ")");
            }
            retEnd = keyRangeString.substring(1, lastCharIdx);
            if (retEnd.contains("/")) {
                throw new IllegalArgumentException("Extra / in KeyRange. (" + keyRangeStringArg + ")");
            }
        } else if (keyRangeString.length() != 1) {
            throw new IllegalArgumentException("Extra characters on end of KeyRange. (" + keyRangeStringArg + ")");
        }
        if (retStart == null && retEnd == null) {
            throw new IllegalArgumentException("Couldn't find start or end in KeyRange. (" + keyRangeStringArg + ")");
        }
        return new KeyRange(retStart, retStartInclusive, retEnd, retEndInclusive);
    }
}

