/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import java.io.Closeable;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import oracle.kv.AuthenticationFailureException;
import oracle.kv.BulkWriteOptions;
import oracle.kv.Consistency;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.Durability;
import oracle.kv.EntryStream;
import oracle.kv.ExecutionFuture;
import oracle.kv.FaultException;
import oracle.kv.Key;
import oracle.kv.KeyRange;
import oracle.kv.KeyValue;
import oracle.kv.KeyValueVersion;
import oracle.kv.LoginCredentials;
import oracle.kv.Operation;
import oracle.kv.OperationExecutionException;
import oracle.kv.OperationFactory;
import oracle.kv.OperationResult;
import oracle.kv.ParallelScanIterator;
import oracle.kv.RequestTimeoutException;
import oracle.kv.ReturnValueVersion;
import oracle.kv.StatementResult;
import oracle.kv.StoreIteratorConfig;
import oracle.kv.Value;
import oracle.kv.ValueVersion;
import oracle.kv.Version;
import oracle.kv.avro.AvroCatalog;
import oracle.kv.lob.KVLargeObject;
import oracle.kv.query.ExecuteOptions;
import oracle.kv.query.PreparedStatement;
import oracle.kv.query.Statement;
import oracle.kv.stats.KVStats;
import oracle.kv.table.TableAPI;

public interface KVStore
extends KVLargeObject,
Closeable {
    public ValueVersion get(Key var1);

    public ValueVersion get(Key var1, Consistency var2, long var3, TimeUnit var5);

    public SortedMap<Key, ValueVersion> multiGet(Key var1, KeyRange var2, Depth var3);

    public SortedMap<Key, ValueVersion> multiGet(Key var1, KeyRange var2, Depth var3, Consistency var4, long var5, TimeUnit var7);

    public SortedSet<Key> multiGetKeys(Key var1, KeyRange var2, Depth var3);

    public SortedSet<Key> multiGetKeys(Key var1, KeyRange var2, Depth var3, Consistency var4, long var5, TimeUnit var7);

    public Iterator<KeyValueVersion> multiGetIterator(Direction var1, int var2, Key var3, KeyRange var4, Depth var5);

    public Iterator<KeyValueVersion> multiGetIterator(Direction var1, int var2, Key var3, KeyRange var4, Depth var5, Consistency var6, long var7, TimeUnit var9);

    public Iterator<Key> multiGetKeysIterator(Direction var1, int var2, Key var3, KeyRange var4, Depth var5);

    public Iterator<Key> multiGetKeysIterator(Direction var1, int var2, Key var3, KeyRange var4, Depth var5, Consistency var6, long var7, TimeUnit var9);

    public Iterator<KeyValueVersion> storeIterator(Direction var1, int var2);

    public Iterator<KeyValueVersion> storeIterator(Direction var1, int var2, Key var3, KeyRange var4, Depth var5);

    public Iterator<KeyValueVersion> storeIterator(Direction var1, int var2, Key var3, KeyRange var4, Depth var5, Consistency var6, long var7, TimeUnit var9);

    public ParallelScanIterator<KeyValueVersion> storeIterator(Direction var1, int var2, Key var3, KeyRange var4, Depth var5, Consistency var6, long var7, TimeUnit var9, StoreIteratorConfig var10);

    public Iterator<Key> storeKeysIterator(Direction var1, int var2);

    public Iterator<Key> storeKeysIterator(Direction var1, int var2, Key var3, KeyRange var4, Depth var5);

    public Iterator<Key> storeKeysIterator(Direction var1, int var2, Key var3, KeyRange var4, Depth var5, Consistency var6, long var7, TimeUnit var9);

    public ParallelScanIterator<Key> storeKeysIterator(Direction var1, int var2, Key var3, KeyRange var4, Depth var5, Consistency var6, long var7, TimeUnit var9, StoreIteratorConfig var10);

    public ParallelScanIterator<KeyValueVersion> storeIterator(Iterator<Key> var1, int var2, KeyRange var3, Depth var4, Consistency var5, long var6, TimeUnit var8, StoreIteratorConfig var9);

    public ParallelScanIterator<Key> storeKeysIterator(Iterator<Key> var1, int var2, KeyRange var3, Depth var4, Consistency var5, long var6, TimeUnit var8, StoreIteratorConfig var9);

    public ParallelScanIterator<KeyValueVersion> storeIterator(List<Iterator<Key>> var1, int var2, KeyRange var3, Depth var4, Consistency var5, long var6, TimeUnit var8, StoreIteratorConfig var9);

    public ParallelScanIterator<Key> storeKeysIterator(List<Iterator<Key>> var1, int var2, KeyRange var3, Depth var4, Consistency var5, long var6, TimeUnit var8, StoreIteratorConfig var9);

    public Version put(Key var1, Value var2);

    public Version put(Key var1, Value var2, ReturnValueVersion var3, Durability var4, long var5, TimeUnit var7);

    public Version putIfAbsent(Key var1, Value var2);

    public Version putIfAbsent(Key var1, Value var2, ReturnValueVersion var3, Durability var4, long var5, TimeUnit var7);

    public Version putIfPresent(Key var1, Value var2);

    public Version putIfPresent(Key var1, Value var2, ReturnValueVersion var3, Durability var4, long var5, TimeUnit var7);

    public Version putIfVersion(Key var1, Value var2, Version var3);

    public Version putIfVersion(Key var1, Value var2, Version var3, ReturnValueVersion var4, Durability var5, long var6, TimeUnit var8);

    public boolean delete(Key var1);

    public boolean delete(Key var1, ReturnValueVersion var2, Durability var3, long var4, TimeUnit var6);

    public boolean deleteIfVersion(Key var1, Version var2);

    public boolean deleteIfVersion(Key var1, Version var2, ReturnValueVersion var3, Durability var4, long var5, TimeUnit var7);

    public int multiDelete(Key var1, KeyRange var2, Depth var3);

    public int multiDelete(Key var1, KeyRange var2, Depth var3, Durability var4, long var5, TimeUnit var7);

    public List<OperationResult> execute(List<Operation> var1) throws OperationExecutionException;

    public List<OperationResult> execute(List<Operation> var1, Durability var2, long var3, TimeUnit var5) throws OperationExecutionException;

    public void put(List<EntryStream<KeyValue>> var1, BulkWriteOptions var2);

    public OperationFactory getOperationFactory();

    @Override
    public void close();

    public KVStats getStats(boolean var1);

    @Deprecated
    public AvroCatalog getAvroCatalog();

    public TableAPI getTableAPI();

    public void login(LoginCredentials var1) throws RequestTimeoutException, AuthenticationFailureException, FaultException, IllegalArgumentException;

    public void logout() throws RequestTimeoutException, FaultException;

    public ExecutionFuture execute(String var1);

    public ExecutionFuture execute(String var1, ExecuteOptions var2);

    public StatementResult executeSync(String var1);

    public StatementResult executeSync(String var1, ExecuteOptions var2);

    public ExecutionFuture getFuture(byte[] var1) throws IllegalArgumentException;

    public PreparedStatement prepare(String var1);

    public StatementResult executeSync(Statement var1);

    public StatementResult executeSync(Statement var1, ExecuteOptions var2);
}

