/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import oracle.kv.FaultException;
import oracle.kv.impl.util.FastExternalizable;

public class Durability
implements FastExternalizable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Durability COMMIT_SYNC = new Durability(SyncPolicy.SYNC, SyncPolicy.NO_SYNC, ReplicaAckPolicy.SIMPLE_MAJORITY);
    public static final Durability COMMIT_NO_SYNC = new Durability(SyncPolicy.NO_SYNC, SyncPolicy.NO_SYNC, ReplicaAckPolicy.SIMPLE_MAJORITY);
    public static final Durability COMMIT_WRITE_NO_SYNC = new Durability(SyncPolicy.WRITE_NO_SYNC, SyncPolicy.NO_SYNC, ReplicaAckPolicy.SIMPLE_MAJORITY);
    private final SyncPolicy masterSync;
    private final SyncPolicy replicaSync;
    private final ReplicaAckPolicy replicaAck;
    private static final Durability[][][] durabilityMap = new Durability[SyncPolicy.values().length][SyncPolicy.values().length][ReplicaAckPolicy.values().length];

    public Durability(SyncPolicy masterSync, SyncPolicy replicaSync, ReplicaAckPolicy replicaAck) {
        this.masterSync = masterSync;
        this.replicaSync = replicaSync;
        this.replicaAck = replicaAck;
    }

    public Durability(DataInput in, short serialVersion) throws IOException {
        Durability d = Durability.readFastExternal(in, serialVersion);
        this.masterSync = d.masterSync;
        this.replicaSync = d.replicaSync;
        this.replicaAck = d.replicaAck;
    }

    public static Durability readFastExternal(DataInput in, short serialVersion) throws IOException {
        SyncPolicy masterSync = SyncPolicy.readFastExternal(in, serialVersion);
        SyncPolicy replicaSync = SyncPolicy.readFastExternal(in, serialVersion);
        ReplicaAckPolicy replicaAck = ReplicaAckPolicy.readFastExternal(in, serialVersion);
        return durabilityMap[masterSync.ordinal()][replicaSync.ordinal()][replicaAck.ordinal()];
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        this.masterSync.writeFastExternal(out, serialVersion);
        this.replicaSync.writeFastExternal(out, serialVersion);
        this.replicaAck.writeFastExternal(out, serialVersion);
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(200);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeShort(13);
            this.writeFastExternal(oos, (short)13);
            oos.flush();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new FaultException(e, false);
        }
    }

    public static Durability fromByteArray(byte[] keyBytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(keyBytes);
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            short serialVersion = ois.readShort();
            return Durability.readFastExternal(ois, serialVersion);
        }
        catch (IOException e) {
            throw new FaultException(e, false);
        }
    }

    public String toString() {
        return this.masterSync.toString() + "," + this.replicaSync.toString() + "," + this.replicaAck.toString();
    }

    public SyncPolicy getMasterSync() {
        return this.masterSync;
    }

    public SyncPolicy getReplicaSync() {
        return this.replicaSync;
    }

    public ReplicaAckPolicy getReplicaAck() {
        return this.replicaAck;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.masterSync == null ? 0 : this.masterSync.hashCode());
        result = 31 * result + (this.replicaAck == null ? 0 : this.replicaAck.hashCode());
        result = 31 * result + (this.replicaSync == null ? 0 : this.replicaSync.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Durability)) {
            return false;
        }
        Durability other = (Durability)obj;
        if (this.masterSync == null ? other.masterSync != null : !this.masterSync.equals(other.masterSync)) {
            return false;
        }
        if (this.replicaAck == null ? other.replicaAck != null : !this.replicaAck.equals(other.replicaAck)) {
            return false;
        }
        return !(this.replicaSync == null ? other.replicaSync != null : !this.replicaSync.equals(other.replicaSync));
    }

    static {
        for (SyncPolicy masterSync : SyncPolicy.values()) {
            for (SyncPolicy replicaSync : SyncPolicy.values()) {
                for (ReplicaAckPolicy replicaAckPolicy : ReplicaAckPolicy.values()) {
                    Durability.durabilityMap[masterSync.ordinal()][replicaSync.ordinal()][replicaAckPolicy.ordinal()] = new Durability(masterSync, replicaSync, replicaAckPolicy);
                }
            }
        }
    }

    public static enum ReplicaAckPolicy implements FastExternalizable
    {
        ALL(0),
        NONE(1),
        SIMPLE_MAJORITY(2);

        private static final ReplicaAckPolicy[] VALUES;

        private ReplicaAckPolicy(int ordinal) {
            if (ordinal != this.ordinal()) {
                throw new IllegalArgumentException("Wrong ordinal");
            }
        }

        static ReplicaAckPolicy readFastExternal(DataInput in, short serialVersion) throws IOException {
            int ordinal = in.readUnsignedByte();
            try {
                return VALUES[ordinal];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("unknown ReplicaAckPolicy: " + ordinal);
            }
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            out.writeByte(this.ordinal());
        }

        static {
            VALUES = ReplicaAckPolicy.values();
        }
    }

    public static enum SyncPolicy implements FastExternalizable
    {
        SYNC(0),
        NO_SYNC(1),
        WRITE_NO_SYNC(2);

        private static final SyncPolicy[] VALUES;

        private SyncPolicy(int ordinal) {
            if (ordinal != this.ordinal()) {
                throw new IllegalArgumentException("Wrong ordinal");
            }
        }

        static SyncPolicy readFastExternal(DataInput in, short serialVersion) throws IOException {
            int ordinal = in.readUnsignedByte();
            try {
                return VALUES[ordinal];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("unknown SyncPolicy: " + ordinal);
            }
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            out.writeByte(this.ordinal());
        }

        static {
            VALUES = SyncPolicy.values();
        }
    }
}

