/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import com.sleepycat.je.utilint.PropUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import oracle.kv.FaultException;
import oracle.kv.impl.util.FastExternalizable;

public abstract class Consistency
implements FastExternalizable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Consistency NONE_REQUIRED = new NoneRequired();
    public static final Consistency ABSOLUTE = new Absolute();
    @Deprecated
    public static final Consistency NONE_REQUIRED_NO_MASTER = new NoneRequiredNoMaster();

    Consistency() {
    }

    public static Consistency readFastExternal(DataInput in, short serialVersion) throws IOException {
        SerialType type = SerialType.readFastExternal(in, serialVersion);
        return type.readConsistency(in, serialVersion);
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(200);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeShort(13);
            this.writeFastExternal(oos, (short)13);
            oos.flush();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new FaultException(e, false);
        }
    }

    public static Consistency fromByteArray(byte[] keyBytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(keyBytes);
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            short serialVersion = ois.readShort();
            return Consistency.readFastExternal(ois, serialVersion);
        }
        catch (IOException e) {
            throw new FaultException(e, false);
        }
    }

    public abstract String getName();

    public static class Time
    extends Consistency {
        private static final long serialVersionUID = 1L;
        private static final String NAME = "Consistency.Time";
        private final int permissibleLag;
        private final int timeout;

        public Time(long permissibleLag, TimeUnit permissibleLagUnit, long timeout, TimeUnit timeoutUnit) {
            this.permissibleLag = PropUtil.durationToMillis(permissibleLag, permissibleLagUnit);
            this.timeout = PropUtil.durationToMillis(timeout, timeoutUnit);
        }

        Time(DataInput in, short serialVersion) throws IOException {
            this.permissibleLag = in.readInt();
            this.timeout = in.readInt();
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            SerialType.TIME_TYPE.writeFastExternal(out, serialVersion);
            out.writeInt(this.permissibleLag);
            out.writeInt(this.timeout);
        }

        @Override
        public String getName() {
            return NAME;
        }

        public long getPermissibleLag(TimeUnit unit) {
            return PropUtil.millisToDuration(this.permissibleLag, unit);
        }

        public long getTimeout(TimeUnit unit) {
            return PropUtil.millisToDuration(this.timeout, unit);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.permissibleLag;
            result = 31 * result + this.timeout;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Time other = (Time)obj;
            if (this.permissibleLag != other.permissibleLag) {
                return false;
            }
            return this.timeout == other.timeout;
        }

        public String toString() {
            return this.getName() + " permissibleLag=" + this.permissibleLag;
        }
    }

    public static class Version
    extends Consistency {
        private static final long serialVersionUID = 1L;
        private static final String NAME = "Consistency.Version";
        private final oracle.kv.Version version;
        private final int timeout;

        public Version(oracle.kv.Version version, long timeout, TimeUnit timeoutUnit) {
            if (version == null) {
                throw new IllegalArgumentException("version must not be null");
            }
            this.version = version;
            this.timeout = PropUtil.durationToMillis(timeout, timeoutUnit);
        }

        Version(DataInput in, short serialVersion) throws IOException {
            this.version = oracle.kv.Version.createVersion(in, serialVersion);
            this.timeout = in.readInt();
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            SerialType.VERSION_TYPE.writeFastExternal(out, serialVersion);
            this.version.writeFastExternal(out, serialVersion);
            out.writeInt(this.timeout);
        }

        @Override
        public String getName() {
            return NAME;
        }

        public oracle.kv.Version getVersion() {
            return this.version;
        }

        public long getTimeout(TimeUnit unit) {
            return PropUtil.millisToDuration(this.timeout, unit);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            result = 31 * result + this.timeout;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Version)) {
                return false;
            }
            Version other = (Version)obj;
            if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
                return false;
            }
            return this.timeout == other.timeout;
        }

        public String toString() {
            return this.getName() + " version=" + this.version;
        }
    }

    private static class NoneRequiredNoMaster
    extends Consistency {
        private static final long serialVersionUID = 1L;
        private static final String NAME = "Consistency.NoneRequiredNoMaster";

        NoneRequiredNoMaster() {
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            SerialType.NONE_REQUIRED_NO_MASTER_TYPE.writeFastExternal(out, serialVersion);
        }

        @Override
        public String getName() {
            return NAME;
        }

        public int hashCode() {
            return 43;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return obj instanceof NoneRequiredNoMaster;
        }

        public String toString() {
            return this.getName();
        }
    }

    private static class Absolute
    extends Consistency {
        private static final long serialVersionUID = 1L;
        private static final String NAME = "Consistency.Absolute";

        Absolute() {
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            SerialType.ABSOLUTE_TYPE.writeFastExternal(out, serialVersion);
        }

        @Override
        public String getName() {
            return NAME;
        }

        public int hashCode() {
            return 37;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return obj instanceof Absolute;
        }

        public String toString() {
            return this.getName();
        }
    }

    private static class NoneRequired
    extends Consistency {
        private static final long serialVersionUID = 1L;
        private static final String NAME = "Consistency.NoneRequired";

        NoneRequired() {
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            SerialType.NONE_REQUIRED_TYPE.writeFastExternal(out, serialVersion);
        }

        @Override
        public String getName() {
            return NAME;
        }

        public int hashCode() {
            return 31;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return obj instanceof NoneRequired;
        }

        public String toString() {
            return this.getName();
        }
    }

    private static enum SerialType implements FastExternalizable
    {
        NONE_REQUIRED_TYPE(0){

            @Override
            Consistency readConsistency(DataInput in, short serialVersion) throws IOException {
                return NONE_REQUIRED;
            }
        }
        ,
        ABSOLUTE_TYPE(1){

            @Override
            Consistency readConsistency(DataInput in, short serialVersion) throws IOException {
                return ABSOLUTE;
            }
        }
        ,
        VERSION_TYPE(2){

            @Override
            Consistency readConsistency(DataInput in, short serialVersion) throws IOException {
                return new Version(in, serialVersion);
            }
        }
        ,
        TIME_TYPE(3){

            @Override
            Consistency readConsistency(DataInput in, short serialVersion) throws IOException {
                return new Time(in, serialVersion);
            }
        }
        ,
        NONE_REQUIRED_NO_MASTER_TYPE(4){

            @Override
            Consistency readConsistency(DataInput in, short serialVersion) throws IOException {
                return NONE_REQUIRED_NO_MASTER;
            }
        };

        private static final SerialType[] VALUES;

        private SerialType(int ordinal) {
            if (ordinal != this.ordinal()) {
                throw new IllegalArgumentException("Wrong ordinal");
            }
        }

        static SerialType readFastExternal(DataInput in, short serialVersion) throws IOException {
            int ordinal = in.readUnsignedByte();
            try {
                return VALUES[ordinal];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("unknown SerialType: " + ordinal);
            }
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            out.writeByte(this.ordinal());
        }

        abstract Consistency readConsistency(DataInput var1, short var2) throws IOException;

        static {
            VALUES = SerialType.values();
        }
    }
}

