/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.utilint;

import com.sleepycat.je.EnvironmentFailureException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class StatLogger {
    private final File logFile;
    private final String fileext;
    private final String filename;
    private final File logDir;
    private int maxFileCount;
    private int maxRowCount;
    private String header = null;
    private String lastVal = null;
    private int currentRowCount;

    public StatLogger(File logdir, String filename, String fileext, int filecount, int rowcount) throws IOException {
        this.logFile = new File(logdir.getAbsolutePath() + File.separator + filename + "." + fileext);
        this.maxFileCount = filecount - 1;
        this.maxRowCount = rowcount;
        this.filename = filename;
        this.fileext = fileext;
        this.logDir = logdir;
        if (this.logFile.exists()) {
            if (!this.logFile.isFile()) {
                throw new IllegalArgumentException("Statistic log file" + this.logFile.getAbsolutePath() + " exists but is not a file.");
            }
            this.header = this.getHeader();
            this.getLastRow();
        }
    }

    public void setRowCount(int rowcount) {
        this.maxRowCount = rowcount;
    }

    public void setFileCount(int filecount) {
        if (this.maxFileCount > --filecount) {
            for (int i = this.maxFileCount; i > filecount; --i) {
                File deleme = new File(this.formFn(i - 2));
                if (!deleme.exists()) continue;
                deleme.delete();
            }
        }
        this.maxFileCount = filecount;
    }

    public void setHeader(String val) throws IOException {
        if (!val.equals(this.header)) {
            if (this.header != null) {
                this.rotateFiles();
            }
            ++this.currentRowCount;
            this.write(val);
            this.header = val;
            this.lastVal = null;
        }
    }

    public void log(String val) throws IOException {
        if (this.currentRowCount >= this.maxRowCount) {
            this.rotateFiles();
            ++this.currentRowCount;
            this.write(this.header);
        }
        ++this.currentRowCount;
        this.write(val);
        this.lastVal = val;
    }

    public void logDelta(String val) throws IOException {
        if (this.header == null) {
            throw EnvironmentFailureException.unexpectedState("Unexpected state logHeader not called before logDelta.");
        }
        if (this.lastVal == null) {
            this.lastVal = this.getLastRow();
        }
        String lastNoFirst = null;
        if (this.lastVal != null) {
            lastNoFirst = this.lastVal.substring(this.lastVal.indexOf(44) + 1);
        }
        if (!val.substring(val.indexOf(44) + 1).equals(lastNoFirst)) {
            this.log(val);
        }
    }

    private String getHeader() throws IOException {
        String header;
        BufferedReader fr = null;
        try {
            fr = new BufferedReader(new FileReader(this.logFile));
            header = fr.readLine();
        }
        catch (FileNotFoundException e) {
            throw new IOException("Error occured accessing statistic log file FileNotFoundException " + this.logFile.getAbsolutePath(), e);
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException iOException) {}
            }
        }
        return header;
    }

    private String getLastRow() throws IOException {
        BufferedReader fr = null;
        this.currentRowCount = 0;
        try {
            String row;
            fr = new BufferedReader(new FileReader(this.logFile));
            String prevrow = null;
            while ((row = fr.readLine()) != null) {
                ++this.currentRowCount;
                prevrow = row;
            }
            String string = prevrow;
            return string;
        }
        catch (FileNotFoundException e) {
            throw new IOException("Error occured accessing statistic log file FileNotFoundException " + this.logFile.getAbsolutePath(), e);
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String formFn(int version) {
        if (version < 0) {
            return this.logDir.getAbsolutePath() + File.separator + this.filename + "." + this.fileext;
        }
        return this.logDir.getAbsolutePath() + File.separator + this.filename + "." + version + "." + this.fileext;
    }

    private void write(String val) throws IOException {
        PrintWriter ps = null;
        try {
            ps = new PrintWriter(new FileWriter(this.logFile, true));
            ps.println(val);
        }
        catch (FileNotFoundException e) {
            throw new IOException("Error occured accessing statistic log file FileNotFoundException " + this.logFile.getAbsolutePath(), e);
        }
        finally {
            if (ps != null) {
                ps.flush();
                ps.close();
            }
        }
    }

    private void rotateFiles() {
        File cf = new File(this.formFn(this.maxFileCount - 1));
        if (cf.exists()) {
            cf.delete();
        }
        for (int i = this.maxFileCount - 2; i >= -1; --i) {
            cf = new File(this.formFn(i));
            if (!cf.exists()) continue;
            cf.renameTo(new File(this.formFn(i + 1)));
        }
        this.currentRowCount = 0;
    }
}

