/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.View;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.validators.ConstraintValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.SchemaObjectValidator;
import oracle.javatools.db.validators.ValidationContext;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.util.ModelUtil;

public abstract class RelationValidator<T extends Relation>
extends SchemaObjectValidator<T> {
    public RelationValidator(DBObjectProvider prov) {
        super(prov);
    }

    @DBObjectValidator.PropertyValidator(value={"constraints"})
    public void validateConstraints(ValidationContext<T> context) throws ValidationException {
        Constraint[] cons = ((Relation)context.getUpdatedObject()).getConstraints();
        ConstraintValidator.validateOnePK(cons);
        this.validateOwnedObjects(context.getLevel(), (DBObject[])cons);
    }

    @DBObjectValidator.PropertyValidator(value={"columns"})
    public void validateColumns(ValidationContext<T> context) throws ValidationException {
        Relation original = (Relation)context.getOriginalObject();
        Relation updated = (Relation)context.getUpdatedObject();
        Object[] cols = updated.getColumns();
        if (!ModelUtil.hasNonNullElement((Object[])cols) && this.enforceOneColumnExists(context)) {
            throw new ValidationException((DBObject)updated, APIBundle.format((String)"COLUMN_ERROR_NEED_COLUMN", (Object[])new Object[]{updated.getName()}));
        }
        this.validateOwnedObjects(context.getLevel(), (DBObject[])cols);
    }

    protected boolean enforceOneColumnExists(ValidationContext<T> context) {
        return !(context.getUpdatedObject() instanceof View);
    }

    public DBObjectValidator.NamespaceType getNamespaceType() {
        return DBObjectValidator.NamespaceType.SCHEMA;
    }

    protected CascadeAction cascadePropertyChange(Difference objDiff, String propName, Object oldValue, Object newValue, T obj) throws DBException {
        Relation otherRel;
        CascadeAction retval = super.cascadePropertyChange(objDiff, propName, oldValue, newValue, obj);
        Object updatedObj = objDiff.getUpdatedObject();
        Object originalObj = objDiff.getOriginalObject();
        if ("name".equals(propName) && originalObj instanceof Column && updatedObj instanceof Column && ((otherRel = ((Column)originalObj).getRelation()) == obj || TemporaryObjectID.findOriginalObject(obj) == otherRel) && this.cascadeColumnRename((Column)updatedObj, obj)) {
            retval = CascadeAction.UPDATE;
        }
        return retval;
    }

    protected boolean isColumnRenameCascadableToVirtualExpression() {
        return true;
    }

    protected boolean cascadeColumnRename(Column renamedCol, T obj) {
        SQLFragment frag;
        boolean retval = false;
        if (this.isColumnRenameCascadableToVirtualExpression() || TemporaryObjectID.findOriginalObject((DBObject)renamedCol) == null) {
            for (Column column : obj.getColumns()) {
                frag = column.getVirtualExpression();
                if (DBUtil.findUsagesIn((DBObject)renamedCol, (DBObject)frag).isEmpty()) continue;
                column.setVirtualExpressionSource(frag.getSQLText());
                column.setVirtualExpression(frag);
                retval = true;
            }
        }
        for (Column column : obj.getConstraints()) {
            if (!(column instanceof CheckConstraint) || DBUtil.findUsagesIn((DBObject)renamedCol, (DBObject)(frag = ((CheckConstraint)column).getCheckConditionFragment())).isEmpty()) continue;
            ((CheckConstraint)column).setCheckCondition(frag.getSQLText());
            ((CheckConstraint)column).setCheckConditionFragment(frag);
            retval = true;
        }
        return retval;
    }

    public CascadeAction cascadeDelete(DBObject removed, T obj) throws DBException {
        CascadeAction action;
        CascadeAction retval = CascadeAction.NONE;
        if (removed instanceof Column) {
            SQLFragment frag;
            for (Constraint constraint : obj.getConstraints()) {
                if (!(constraint instanceof CheckConstraint) || (frag = ((CheckConstraint)constraint).getCheckConditionFragment()) == null || DBUtil.findUsagesIn((DBObject)removed, (DBObject)frag).isEmpty()) continue;
                obj.removeConstraint(constraint);
                retval = CascadeAction.UPDATE;
            }
            for (Constraint constraint : obj.getColumns()) {
                frag = constraint.getVirtualExpression();
                if (frag == null || DBUtil.findUsagesIn((DBObject)removed, (DBObject)frag).isEmpty()) continue;
                obj.removeColumn((Column)constraint);
                retval = CascadeAction.UPDATE;
            }
        }
        return (action = super.cascadeDelete(removed, obj)).compareTo((Enum)retval) > 0 ? action : retval;
    }
}

