/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.util.Collection;
import java.util.List;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.PlSqlUtilCore;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.SchemaObjectValidator;
import oracle.javatools.db.validators.SourceValidationException;
import oracle.javatools.db.validators.ValidationCancelledException;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;

public class PlSqlValidator<T extends PlSqlSourceObject>
extends SchemaObjectValidator<T> {
    private boolean m_isBody;

    public PlSqlValidator(DBObjectProvider prov) {
        this(prov, false);
    }

    public PlSqlValidator(DBObjectProvider prov, boolean isBody) {
        super(prov);
        this.m_isBody = isBody;
    }

    @DBObjectValidator.PropertyValidator(value={"source"}, level=ValidationLevel.FULL)
    public void validateSource(T original, T updated) throws ValidationException {
        ValidationException ex = null;
        if (this.isCheckPlSqlSyntax() && updated != null && updated.getSource() != null) {
            DBObjectProvider pro = this.getProvider();
            List issues = null;
            try {
                PlSqlParser parser = PlSqlUtil.findOrCreateParser(updated, (DBObjectProvider)pro);
                if (parser != null) {
                    issues = parser.getIssues();
                }
            }
            catch (CancelledException e) {
                throw new ValidationCancelledException();
            }
            if (issues != null) {
                for (PlSqlParser.Issue issue : issues) {
                    ex = this.addException(ex, updated, SourceValidationException.ErrorType.SYNTAX, issue.getStartOffset(), issue.getEndOffset(), issue.getMessage());
                }
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    protected boolean isCheckPlSqlSyntax() {
        return true;
    }

    protected boolean isSyntaxOK(T obj) {
        try {
            this.validateSource(null, obj);
        }
        catch (ValidationException e) {
            return false;
        }
        return true;
    }

    protected final ValidationException addException(ValidationException ex, T updated, SourceValidationException.ErrorType type, int start, int end, String message) {
        SourceValidationException sve = new SourceValidationException(updated, type, start, end, message);
        return (ValidationException)((Object)ValidationException.append((DBException)((Object)ex), (DBException)sve));
    }

    public CascadeAction cascadeDelete(DBObject removed, T obj) throws DBException {
        CascadeAction retval = CascadeAction.NONE;
        if (PlSqlUtil.isBodyOf(removed, obj) || this.checkSchemaDelete(removed, (SchemaObject)obj)) {
            retval = CascadeAction.DELETE;
        }
        return retval;
    }

    protected CascadeAction cascadePropertyChange(Difference objDiff, String propName, Object oldValue, Object newValue, T obj) throws DBException {
        DBObject origObj;
        CascadeAction retval = CascadeAction.NONE;
        if (("name".equals(propName) || "schema".equals(propName)) && obj != DBUtil.getSystemObject((DBObject)(origObj = (DBObject)objDiff.getOriginalObject()))) {
            DBObject updateObj = (DBObject)objDiff.getUpdatedObject();
            if (!(updateObj.getID() instanceof TemporaryObjectID)) {
                DBLog.getLogger(PlSqlUtil.class).warning("Cascading a rename but the new object doesn't have a temp id");
            }
            boolean changed = PlSqlUtil.updateSourceForRefactor(obj, this.getProvider(), origObj, propName, origObj.getProperty(propName), newValue);
            boolean moved = this.checkSchemaRename(objDiff, propName, (SchemaObject)obj);
            if (changed || moved) {
                String nameInSource;
                retval = CascadeAction.UPDATE;
                String source = obj.getSource();
                if (source != null && ModelUtil.hasLength((String)(nameInSource = PlSqlUtilCore.getNameFromSource((String)source)))) {
                    obj.setName(this.getProvider().getInternalName(nameInSource));
                }
            }
        }
        return retval;
    }

    public Collection<String> listAlwaysValidProperties() {
        Collection retval = super.listAlwaysValidProperties();
        retval.add("returnTypeReference");
        return retval;
    }

    public DBObjectValidator.NamespaceType getNamespaceType() {
        return this.m_isBody ? DBObjectValidator.NamespaceType.NONE : DBObjectValidator.NamespaceType.SCHEMA;
    }
}

