/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sqlite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Index;
import oracle.javatools.db.ddl.BundleDDLGenerator;
import oracle.javatools.db.ddl.TokenGenerator;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.sqlite.SQLiteDDLSupport;
import oracle.javatools.db.sqlite.SQLiteDDLType;
import oracle.javatools.db.sqlite.SQLiteDatabase;

final class SQLiteDDLGenerator
extends BundleDDLGenerator<SQLiteDDLType> {
    SQLiteDDLGenerator(Class<? extends SQLiteDatabase> dbClz, DBObjectProvider pro) {
        super(dbClz, pro, new String[]{"/oracle/javatools/db/sqlite/SQLiteDDL.properties"});
        this.registerTokens();
    }

    protected void registerTokens() {
        for (Map.Entry<String, TokenGenerator> entry : SQLiteDDLSupport.getInstance().getGlobalTokenGenerators().entrySet()) {
            this.registerTokenGenerator(entry.getKey(), entry.getValue());
        }
    }

    protected SQLiteDDLType getDDLType(String type) {
        return SQLiteDDLType.getDDLType(type);
    }

    public Collection getAllowedPropertyValues(DBObject originalObject, DBObject updatedObject, String property) {
        if (updatedObject instanceof Trigger && "baseType".equals(property)) {
            ArrayList<Trigger.BaseType> c = new ArrayList<Trigger.BaseType>();
            c.add(Trigger.BaseType.TABLE);
            c.add(Trigger.BaseType.VIEW);
            return c;
        }
        if (updatedObject instanceof Index && "indexType".equals(property)) {
            ArrayList<Index.IndexType> c = new ArrayList<Index.IndexType>();
            c.add(Index.IndexType.NORMAL);
            c.add(Index.IndexType.UNIQUE);
            return c;
        }
        if ("deferrableState".equals(property) && updatedObject instanceof Constraint && !(updatedObject instanceof FKConstraint)) {
            return Collections.emptyList();
        }
        return super.getAllowedPropertyValues(originalObject, updatedObject, property);
    }
}

