/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql.parser;

import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.plsql.PlSqlSchemaObject;
import oracle.javatools.db.plsql.PlSqlSchemaObjectBody;
import oracle.javatools.db.plsql.PlSqlSchemaObjectSpec;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.plsql.parser.PlSqlSourceObjectBuilder;

public class PlSqlSpecAndBodyBuilder<T extends PlSqlSchemaObject>
extends PlSqlSourceObjectBuilder<T> {
    public PlSqlSpecAndBodyBuilder(AbstractDBObjectProvider pro, String type) {
        super(pro, type);
    }

    @Override
    protected void addNameProperties(T pso, PlSqlParser parser, PlSqlUtil.TypeAndNameInfo info) throws CancelledException {
        super.addNameProperties(pso, parser, info);
        String nameInSource = info.getName();
        String psoName = pso.getName();
        String otherType = PlSqlUtil.getCompanionObjectType(pso);
        if (otherType != null) {
            NameBasedID otherID = new NameBasedID(otherType, DBUtil.getSchemaName(pso), nameInSource, this.getProvider());
            if (pso instanceof PlSqlSchemaObjectSpec) {
                ((PlSqlSchemaObjectSpec)pso).setBodyID((DBObjectID)otherID);
            } else if (pso instanceof PlSqlSchemaObjectBody) {
                ((PlSqlSchemaObjectBody)pso).setSpecID((DBObjectID)otherID);
            }
        }
    }
}

