/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql.parser;

import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.Function;
import oracle.javatools.db.plsql.PlSqlBlock;
import oracle.javatools.db.plsql.PlSqlCodeFragment;
import oracle.javatools.db.plsql.PlSqlComment;
import oracle.javatools.db.plsql.PlSqlParameter;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.Procedure;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.plsql.parser.AbstractPlSqlBuilder;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.plsql.parser.PlSqlParserFactory;
import oracle.javatools.db.token.Token;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public class PlSqlSourceObjectBuilder<T extends PlSqlBlock>
extends AbstractPlSqlBuilder<T> {
    private PlSqlParser m_parser;
    private final Holder<Boolean> m_deferredHolder = new Holder((Object)Boolean.FALSE);
    private PlSqlSourceObject m_deferredPSO;

    public PlSqlSourceObjectBuilder(AbstractDBObjectProvider abstractDBObjectProvider, String string) {
        super(abstractDBObjectProvider, string);
    }

    @Override
    public PlSqlParser getParser(T frag) throws CancelledException {
        SchemaObject top;
        this.checkInterruptOrCancel(frag);
        final Holder retval = new Holder((Object)this.m_parser);
        if (retval.get() == null && (top = DBUtil.getSchemaObject(frag)) instanceof PlSqlSourceObject) {
            Runnable mo = new Runnable((DBObject)top){
                final /* synthetic */ DBObject val$top;
                {
                    this.val$top = dBObject;
                }

                @Override
                public void run() {
                    retval.set((Object)PlSqlSourceObjectBuilder.this.m_parser);
                    if (retval.get() == null) {
                        AbstractDBObjectProvider pro = PlSqlSourceObjectBuilder.this.getProvider();
                        PlSqlParserFactory fac = pro.getDescriptor().getPlSqlParserFactory((DBObjectProvider)pro);
                        retval.set((Object)fac.createParser((PlSqlSourceObject)this.val$top));
                        PlSqlSourceObjectBuilder.this.m_parser = (PlSqlParser)retval.get();
                    }
                }
            };
            DBUtil.invokeCompoundChange((DBObject)top, (Runnable)mo, (boolean)false);
        }
        return (PlSqlParser)retval.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deferRebuildSource() {
        Holder<Boolean> holder = this.m_deferredHolder;
        synchronized (holder) {
            this.m_deferredHolder.set((Object)Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionRebuildSource() throws CancelledException {
        Holder<Boolean> holder = this.m_deferredHolder;
        synchronized (holder) {
            boolean isDeferred = (Boolean)this.m_deferredHolder.get();
            PlSqlSourceObject pso = this.m_deferredPSO;
            this.m_deferredPSO = null;
            this.m_deferredHolder.set((Object)Boolean.FALSE);
            if (isDeferred && pso != null && pso.getSource() != null) {
                PlSqlUtil.rebuildSource((DBObjectProvider)this.getProvider(), pso);
            }
        }
    }

    public boolean isClearDerivedPropertiesRequired(T obj, DBObjectChange change, Collection<String> currentlyBuiltProps) {
        boolean retval = super.isClearDerivedPropertiesRequired(obj, change, currentlyBuiltProps);
        if (!retval) {
            boolean bl = retval = change.getPropertyChange("name") != null || change.getPropertyChange("schema") != null;
        }
        if (change.getPropertyChange("source") != null) {
            this.m_parser = null;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> clearDerivedProperties(T obj, DBObjectChange change) {
        Holder<Boolean> holder = this.m_deferredHolder;
        synchronized (holder) {
            Collection<String> ret;
            boolean isDeferred = (Boolean)this.m_deferredHolder.get();
            if (!(obj instanceof PlSqlSourceObject)) {
                Object pso = null;
                throw new IllegalArgumentException("obj is expected to be a PlSqlSourceObject");
            }
            PlSqlSourceObject pso = (PlSqlSourceObject)obj;
            boolean clearDerivedProps = false;
            boolean rebuildSource = false;
            try {
                block19: {
                    Collection changedProps = change.getAllChangedProperties();
                    if (changedProps.contains("source")) {
                        if (isDeferred) {
                            throw new IllegalStateException("Cannot set the source while source building is deferred");
                        }
                        clearDerivedProps = true;
                        for (String derivedProp : this.getDerivedProperties("source")) {
                            if (!changedProps.contains(derivedProp)) continue;
                            clearDerivedProps = false;
                            break;
                        }
                    } else if (this.m_deferredPSO == null) {
                        IdentityHashMap<DBObject, DBObjectChange> changeMap = new IdentityHashMap<DBObject, DBObjectChange>();
                        this.getFlattenedMap(change, changeMap);
                        for (Map.Entry e : changeMap.entrySet()) {
                            DBObject dbo = (DBObject)e.getKey();
                            DBObjectChange change2 = (DBObjectChange)e.getValue();
                            for (String property : change2.getAllChangedProperties()) {
                                PropertyChangeEvent pce = change2.getPropertyChange(property);
                                if (pce == null) continue;
                                Object oldVal = pce.getOldValue();
                                Object newVal = pce.getNewValue();
                                if ("name".equals(property)) {
                                    if (oldVal == null) continue;
                                    if (isDeferred) {
                                        this.m_deferredPSO = pso;
                                        break block19;
                                    }
                                    boolean updated = PlSqlUtil.updateSourceForRefactor(pso, (DBObjectProvider)this.getProvider(), dbo, property, oldVal, newVal);
                                    if (!updated) continue;
                                    clearDerivedProps = true;
                                    continue;
                                }
                                if (!this.rebuildSourceSupported(pso, dbo, property, oldVal, newVal)) continue;
                                if (isDeferred) {
                                    this.m_deferredPSO = pso;
                                    break block19;
                                }
                                rebuildSource = true;
                            }
                        }
                    }
                }
                if (rebuildSource) {
                    PlSqlUtil.rebuildSource((DBObjectProvider)this.getProvider(), pso);
                    clearDerivedProps = true;
                }
            }
            catch (CancelledException e) {
                DBLog.getLogger((Object)((Object)this)).warning(e.getMessage());
            }
            if (clearDerivedProps) {
                ret = super.clearDerivedProperties(obj, "source", change);
                this.m_parser = null;
            } else {
                ret = Collections.emptyList();
            }
            return ret;
        }
    }

    private void getFlattenedMap(DBObjectChange change, Map<DBObject, DBObjectChange> changeMap) {
        Map childChanges = change.getOwnedObjectsUpdated();
        if (childChanges == null || childChanges.isEmpty()) {
            changeMap.put(change.getDBObject(), change);
        } else {
            for (DBObjectChange childChange : childChanges.values()) {
                this.getFlattenedMap(childChange, changeMap);
            }
        }
    }

    private boolean rebuildSourceSupported(PlSqlSourceObject pso, DBObject dbo, String propName, Object oldValue, Object newValue) {
        boolean ret = false;
        if (pso != null && ModelUtil.hasLength((String)pso.getSource()) && ModelUtil.areDifferent((Object)oldValue, (Object)newValue)) {
            if (pso == dbo) {
                if (pso instanceof Procedure && "parameters".equals(propName)) {
                    ret = true;
                } else if (pso instanceof Function && "returnTypeReference".equals(propName)) {
                    ret = true;
                } else if (pso instanceof Trigger && ("baseObjectID".equals(propName) || "columnIDs".equals(propName) || "events".equals(propName) || "referencingNewAs".equals(propName) || "referencingOldAs".equals(propName) || "statementLevel".equals(propName) || "timing".equals(propName) || "whenClause".equals(propName))) {
                    ret = true;
                }
            } else if (dbo instanceof PlSqlParameter && dbo.getParent() == pso && ("dataTypeReference".equals(propName) || "defaultValue".equals(propName) || "mode".equals(propName) || "noCopy".equals(propName))) {
                ret = true;
            }
        }
        return ret;
    }

    protected void checkInterruptOrCancel(T object) throws CancelledException {
        super.checkInterruptOrCancel(object);
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"source"}, derived=true, depends={"startOffset"})
    public boolean buildSourceObjectProperties(T obj) throws DBException {
        if (!(obj instanceof PlSqlSourceObject)) {
            Object pso = null;
            throw new IllegalArgumentException("obj is expected to be a PlSqlSourceObject");
        }
        PlSqlSourceObject pso = (PlSqlSourceObject)obj;
        PlSqlParser parser = this.getParser(obj);
        if (ModelUtil.hasLength((String)pso.getSource())) {
            for (String prop : this.getBuiltProperties("propertyReferences")) {
                pso.setProperty(prop, null);
            }
            DBObjectPlSqlFragment frag = (DBObjectPlSqlFragment)pso;
            PlSqlUtil.TypeAndNameInfo info = PlSqlUtil.getTypeAndNameFromSource(pso, this.getProvider().getDescriptor());
            if (ModelUtil.hasLength((String)info.getName())) {
                this.addNameProperties(obj, parser, info);
            }
            if (!parser.isWrapped()) {
                this.buildObjectProperties(obj, parser);
                Object parseNode = parser.getParseNode(frag);
                this.addChildren(parseNode, obj, parser);
            }
        }
        return true;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"startOffset", "endOffset"})
    public boolean buildOffsets(T obj) throws DBException {
        String source = obj == null ? null : obj.getSource();
        obj.setStartOffset(Integer.valueOf(0));
        if (ModelUtil.hasLength((String)source)) {
            PlSqlParser parser = this.getParser(obj);
            PlSqlToken tk = parser.getTokenAtOffset(source.length() - 1);
            if (!tk.isCode()) {
                tk = (PlSqlToken)tk.getPrevCodeToken();
            }
            obj.setEndOffset(Integer.valueOf(tk.getEnd()));
        }
        return true;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"comments"})
    public boolean buildComments(T obj) throws DBException {
        String source;
        String string = source = obj == null ? null : obj.getSource();
        if (ModelUtil.hasLength((String)source)) {
            PlSqlParser parser = this.getParser(obj);
            byte[] bytes = source.getBytes();
            int len = bytes.length;
            for (int i = 0; i < len - 1; ++i) {
                int end;
                PlSqlToken tk;
                if ((bytes[i] != 45 || bytes[i + 1] != 45) && (bytes[i] != 47 || bytes[i + 1] != 42) || (tk = parser.getTokenAtOffset(i)) == null || !tk.isComment()) continue;
                PlSqlToken tk2 = tk;
                int start = tk.getStart();
                if (tk.getType() == Token.Type.SINGLE_LINE_COMMENT) {
                    tk2 = (PlSqlToken)tk.getNextToken();
                    while (tk2.getType() == Token.Type.WHITESPACE || tk2.getType() == Token.Type.SINGLE_LINE_COMMENT) {
                        tk2 = (PlSqlToken)tk2.getNextToken();
                    }
                    while (tk2.getType() != Token.Type.SINGLE_LINE_COMMENT) {
                        tk2 = (PlSqlToken)tk2.getPrevToken();
                    }
                    end = tk2.getEnd();
                } else {
                    end = tk.getEnd();
                }
                PlSqlComment comm = PlSqlSourceObjectBuilder.createFragment(PlSqlComment.class);
                comm.setText(tk.getSource(false, (Token)tk2));
                obj.addComment(comm);
                this.setCommon(parser, (DBObjectPlSqlFragment)comm, start, end, "comments." + start, null);
                i = end;
            }
        }
        return true;
    }

    protected void addNameProperties(T owningSO, PlSqlParser owningSOParser, PlSqlUtil.TypeAndNameInfo info) throws CancelledException {
        String nameInSource = info.getName();
        if (ModelUtil.hasLength((String)nameInSource)) {
            String internalisedTk;
            String psoName = owningSO.getName();
            if (!ModelUtil.hasLength((String)psoName)) {
                owningSO.setName(nameInSource);
            }
            List<String> names = Collections.singletonList(nameInSource);
            this.buildReference(owningSOParser, (PlSqlCodeFragment)owningSO, names, info.getNameStart(), info.getNameEnd(), true);
            PlSqlToken tk = owningSOParser.getTokenAtOffset(owningSO.getEndOffset().intValue());
            if (tk != null && !tk.isCode()) {
                tk = (PlSqlToken)tk.getPrevCodeToken();
            }
            if (tk != null && tk.matches(";")) {
                tk = (PlSqlToken)tk.getPrevCodeToken();
            }
            if (tk != null && ((PlSqlToken)tk.getPrevCodeToken()).matches("end") && ((internalisedTk = this.getProvider().getInternalName(tk.getSource())).equals(psoName) || internalisedTk.equals(nameInSource))) {
                this.buildReference(owningSOParser, (PlSqlCodeFragment)owningSO, names, tk.getStart(), tk.getEnd(), true);
            }
        }
    }

    protected void buildObjectProperties(T pso, PlSqlParser parser) throws CancelledException {
    }
}

