/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlBlock;
import oracle.javatools.db.plsql.PlSqlCodeFragment;
import oracle.javatools.db.plsql.PlSqlComment;
import oracle.javatools.db.plsql.PlSqlDatatype;
import oracle.javatools.db.plsql.PlSqlDatum;
import oracle.javatools.db.plsql.PlSqlMethod;
import oracle.javatools.db.plsql.PlSqlParameter;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlStatement;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenPattern;
import oracle.javatools.db.plsql.PlSqlVariable;
import oracle.javatools.db.plsql.Procedure;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.plsql.TypeBody;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.sql.SqlAliasExpander;
import oracle.javatools.db.token.Token;
import oracle.javatools.db.token.TokenPattern;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractPlSqlBuilder<T extends PlSqlCodeFragment>
extends DerivedPropertyBuilder<T> {
    private static final String LPAREN = "(";
    private static final String RPAREN = ")";
    private final SqlAliasExpander m_sqlAliasExpander;

    public AbstractPlSqlBuilder(AbstractDBObjectProvider pro, String string) {
        super(pro, string);
        Schema schema = null;
        try {
            schema = pro.getDefaultSchema();
        }
        catch (DBException dBException) {
            // empty catch block
        }
        this.m_sqlAliasExpander = pro.getDescriptor().getSqlAliasExpander((DBObjectProvider)pro, schema);
    }

    public abstract PlSqlParser getParser(T var1) throws CancelledException;

    @AbstractDBObjectBuilder.PropertyBuilder(value={"references"}, depends={"propertyReferences"})
    public boolean buildObjectReferences(T obj) throws DBException {
        this.checkInterruptOrCancel((AbstractBuildableObject)obj);
        PlSqlParser parser = this.getParser(obj);
        PlSqlToken startTk = null;
        PlSqlToken endTk = null;
        PlSqlStatement stmt = null;
        if (parser != null && obj.getStartOffset() != null) {
            if (obj instanceof PlSqlDatum && obj.getParent() instanceof PlSqlStatement) {
                stmt = (PlSqlStatement)obj.getParent();
                startTk = parser.getTokenAtOffset(obj.getStartOffset().intValue());
                startTk = (PlSqlToken)startTk.getNextCodeToken();
                endTk = parser.getTokenAtOffset(obj.getEndOffset().intValue());
            } else if (obj instanceof PlSqlStatement) {
                stmt = (PlSqlStatement)obj;
                PlSqlStatement.Type type = stmt.getStatementType();
                if (type == PlSqlStatement.Type.STATEMENT) {
                    startTk = parser.getTokenAtOffset(stmt.getStartOffset().intValue());
                    endTk = parser.getTokenAtOffset(stmt.getEndOffset().intValue());
                } else if (type == PlSqlStatement.Type.IF || type == PlSqlStatement.Type.ELSIF || type == PlSqlStatement.Type.EX_WHEN) {
                    startTk = parser.getTokenAtOffset(stmt.getStartOffset().intValue());
                    endTk = startTk = (PlSqlToken)startTk.getNextCodeToken();
                    PlSqlToken nextTk = (PlSqlToken)endTk.getNextCodeToken();
                    while (nextTk.isCode() && !nextTk.matches("THEN")) {
                        endTk = nextTk;
                        nextTk = (PlSqlToken)nextTk.getNextCodeToken();
                    }
                } else if (type == PlSqlStatement.Type.FOR_LOOP || type == PlSqlStatement.Type.WHILE_LOOP) {
                    int skip = type == PlSqlStatement.Type.FOR_LOOP ? 3 : 1;
                    startTk = parser.getTokenAtOffset(stmt.getStartOffset().intValue());
                    PlSqlToken nextTk = startTk = (PlSqlToken)startTk.getNextCodeToken(skip);
                    while (nextTk.isCode() && !nextTk.matches("LOOP")) {
                        endTk = nextTk;
                        nextTk = (PlSqlToken)nextTk.getNextCodeToken();
                    }
                }
            }
            while (startTk != null && endTk != null && startTk.getStart() <= endTk.getStart()) {
                this.checkInterruptOrCancel((AbstractBuildableObject)obj);
                startTk = this.buildReferences(startTk, endTk, (DBObjectPlSqlFragment)stmt, parser);
            }
        }
        return true;
    }

    protected void addChildren(Object parentParseNode, T parentFrag, PlSqlParser parser) throws CancelledException {
        if (parentParseNode != null && parentFrag != null) {
            for (Object childNode : parser.getChildParseNodes(parentFrag, parentParseNode)) {
                this.checkInterruptOrCancel((AbstractBuildableObject)parentFrag);
                DBObjectPlSqlFragment child = parser.createFragment(parentFrag, parentParseNode, childNode);
                if (child != null) {
                    PlSqlToken nameTk = null;
                    if (child instanceof PlSqlParameter && parentFrag instanceof PlSqlSubProgram) {
                        ((PlSqlSubProgram)parentFrag).addParameter((PlSqlParameter)child);
                    } else if (child instanceof PlSqlVariable && parentFrag instanceof PlSqlBlock) {
                        ((PlSqlBlock)parentFrag).addVariable((PlSqlVariable)child);
                    } else if (child instanceof PlSqlVariable) {
                        boolean bl = false;
                    } else if (child instanceof PlSqlDatatype && parentFrag instanceof PlSqlBlock) {
                        ((PlSqlBlock)parentFrag).addDatatype((PlSqlDatatype)child);
                    } else if (child instanceof PlSqlSubProgram && parentFrag instanceof PlSqlBlock) {
                        ((PlSqlBlock)parentFrag).addSubProgram((PlSqlSubProgram)child);
                        nameTk = this.getNameToken(parser, child);
                        child.setName(this.getSubProgramName(nameTk, (PlSqlSubProgram)child));
                    } else if (child instanceof PlSqlStatement && parentFrag instanceof PlSqlStatement) {
                        ((PlSqlStatement)parentFrag).addStatement((PlSqlStatement)child);
                        nameTk = this.getNameToken(parser, child);
                        if (nameTk == null) {
                            child.setName(String.valueOf(((PlSqlStatement)parentFrag).getStatements().length));
                        }
                    }
                    this.setCommon(parser, child, parser.getStartOffset(childNode), parser.getEndOffset(childNode), child.getName(), nameTk);
                    continue;
                }
                if (!(parentFrag instanceof PlSqlStatement)) continue;
                this.addChildren(childNode, parentFrag, parser);
            }
        }
    }

    protected final void buildReference(PlSqlParser parser, PlSqlCodeFragment frag, List<String> names, int start, int end) throws CancelledException {
        this.buildReference(parser, frag, names, start, end, false);
    }

    protected final void buildReference(PlSqlParser parser, PlSqlCodeFragment frag, List<String> names, int start, int end, boolean propertyRef) throws CancelledException {
        int size = names.size();
        if (size > 0) {
            PlSqlReference ref = AbstractPlSqlBuilder.createFragment(PlSqlReference.class);
            ref.setReferenceNames(names.toArray(new String[names.size()]));
            if (propertyRef) {
                frag.addPropertyReference(ref);
                int count = frag.getPropertyReferences().length;
                String name = "propertyReferences." + count;
                this.setCommon(parser, (DBObjectPlSqlFragment)ref, start, end, name, null);
            } else {
                frag.addReference(ref);
                int count = frag.getReferences().length;
                String name = "references." + count;
                this.setCommon(parser, (DBObjectPlSqlFragment)ref, start, end, name, null);
            }
        }
    }

    protected final void setCommon(PlSqlParser parser, DBObjectPlSqlFragment dboFrag, int start, int end, String name, PlSqlToken nameToken) throws CancelledException {
        DBObject par = dboFrag.getParent();
        dboFrag.setStartOffset(Integer.valueOf(start));
        dboFrag.setEndOffset(Integer.valueOf(end));
        if (nameToken == null) {
            nameToken = this.getNameToken(parser, dboFrag);
        }
        if (name == null && nameToken != null) {
            name = this.getProvider().getInternalName(nameToken.getSource());
        }
        dboFrag.setName(name);
        if (par != null && par.getID() instanceof BaseObjectID) {
            NameBasedID id = new NameBasedID((DBObject)dboFrag, this.getProvider());
            dboFrag.setID((DBObjectID)id);
        } else {
            dboFrag.setID(TemporaryObjectID.createID((DBObject)dboFrag));
        }
        if (nameToken != null && dboFrag instanceof PlSqlCodeFragment) {
            this.buildReference(parser, (PlSqlCodeFragment)dboFrag, Collections.singletonList(name), nameToken.getStart(), nameToken.getEnd(), true);
        }
        this.getProvider().getObjectFactory().ensureDerivedPropertyBuilder((DBObject)dboFrag);
    }

    protected final PlSqlReference findDataTypeReference(PlSqlToken start, PlSqlToken end, String name, PlSqlParser parser) throws CancelledException {
        TokenPattern.PatternResult mr;
        PlSqlToken lastTk;
        PlSqlReference retval = AbstractPlSqlBuilder.createFragment(PlSqlReference.class);
        PlSqlReference.ReferenceType refType = PlSqlReference.ReferenceType.DIRECT;
        if (start.matches("ref") && !((PlSqlToken)start.getNextCodeToken()).matches(".")) {
            start = (PlSqlToken)start.getNextCodeToken();
            refType = PlSqlReference.ReferenceType.REF;
        }
        ArrayList<PlSqlToken> tokens = new ArrayList<PlSqlToken>();
        ArrayList<String> names = new ArrayList<String>();
        this.buildNameAndTokenLists(start, end, false, tokens, names, parser);
        if (names.size() > 0 && refType != PlSqlReference.ReferenceType.REF && (lastTk = (PlSqlToken)tokens.get(tokens.size() - 1)).getNextCodeToken() != null && ((PlSqlToken)lastTk.getNextCodeToken()).matches("%")) {
            if ((lastTk = (PlSqlToken)lastTk.getNextCodeToken()).getNextCodeToken() != null && ((PlSqlToken)lastTk.getNextCodeToken()).matches("type")) {
                refType = PlSqlReference.ReferenceType.PCT_TYPE;
            } else if (lastTk.getNextCodeToken() != null && ((PlSqlToken)lastTk.getNextCodeToken()).matches("rowtype")) {
                refType = PlSqlReference.ReferenceType.PCT_ROWTYPE;
            }
        }
        retval.setReferenceType(refType);
        PlSqlTokenPattern selfSearch = this.getSelfSearch();
        TokenPattern.PatternResult patternResult = mr = selfSearch == null ? null : selfSearch.getResult((Token)start, (Token)end);
        if ((refType == PlSqlReference.ReferenceType.DIRECT || refType == PlSqlReference.ReferenceType.REF) && mr != null) {
            PlSqlSourceObject root = parser.getRoot();
            DBObjectID id = root == null ? null : root.getID();
            retval.setReferences(new DBObjectID[]{id});
        } else {
            if (refType == PlSqlReference.ReferenceType.DIRECT) {
                retval.setDataTypeUsageSource(start.getSource(true, (Token)end));
            }
            retval.setReferenceNames(names.toArray(new String[names.size()]));
        }
        this.setCommon(parser, (DBObjectPlSqlFragment)retval, start.getStart(), end.getEnd(), name, null);
        return retval;
    }

    protected PlSqlTokenPattern getSelfSearch() {
        return null;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"parameters"})
    public boolean buildParameters(T obj) throws DBException {
        this.checkInterruptOrCancel((AbstractBuildableObject)obj);
        if (obj instanceof PlSqlSubProgram) {
            PlSqlSubProgram sub = (PlSqlSubProgram)obj;
            PlSqlParser parser = this.getParser(obj);
            if (parser == null) {
                throw new CancelledException();
            }
            PlSqlSearch search = sub instanceof PlSqlMethod ? new PlSqlSearch("[ { NOT FINAL | <final FINAL> |     NOT OVERRIDING | <over OVERRIDING> |     <notInst  NOT INSTANTIABLE> | INSTANTIABLE }...] <methodType {MEMBER|STATIC|CONSTRUCTOR|MAP MEMBER|ORDER MEMBER}> { PROCEDURE <pname ?> <pparams [(...)]> |   FUNCTION <fname ?> <fparams [(...)]> RETURN <datatype {SELF AS RESULT|?%}> } [EXTERNAL {NAME <extname ?> | VARIABLE NAME <extvarname ?> } ][{DETERMINISTIC|PIPELINED|RESULT_CACHE}...][ {IS|AS} LANGUAGE     { JAVA NAME <javaname ?>     | C [NAME <cname ?>] LIBRARY <clibname ?.>       [AGENT IN ({^)}...) ]       [WITH <ccontext CONTEXT>]       [PARAMETERS ({^)}...) ]     } ]") : new PlSqlSearch("{PROCEDURE <pname ?> <pparams [(...)]>|FUNCTION <fname ?> <fparams [(...)]> RETURN <datatype ?%>}");
            Integer start = sub.getStartOffset();
            PlSqlToken startTk = null;
            if (obj instanceof Procedure) {
                startTk = parser.getTokenAtOffset(start == null ? 0 : start);
                PlSqlSearch s2 = new PlSqlSearch("[CREATE [OR REPLACE]] <start {PROCEDURE|FUNCTION}>");
                if (startTk != null && s2.matches(startTk)) {
                    startTk = s2.getNamedMatchStartToken("start");
                }
            } else if (start != null) {
                startTk = parser.getTokenAtOffset(start.intValue());
            }
            if (startTk != null && search.matches(startTk)) {
                PlSqlToken pnameTk = search.getNamedMatchStartToken("pname");
                PlSqlToken fnameTk = search.getNamedMatchStartToken("fname");
                PlSqlToken sigStartTk = pnameTk != null ? pnameTk : fnameTk;
                String name = sigStartTk.getSource(true);
                sub.setParameters(new PlSqlParameter[0]);
                for (Object paramNode : parser.getPropertyNodes((DBObjectPlSqlFragment)sub, "parameters")) {
                    this.checkInterruptOrCancel((AbstractBuildableObject)obj);
                    PlSqlParameter p = AbstractPlSqlBuilder.createFragment(PlSqlParameter.class);
                    p.setStartOffset(Integer.valueOf(parser.getStartOffset(paramNode)));
                    p.setEndOffset(Integer.valueOf(parser.getEndOffset(paramNode)));
                    sub.addParameter(p);
                    this.setCommon(parser, (DBObjectPlSqlFragment)p, p.getStartOffset(), p.getEndOffset(), p.getName(), null);
                }
                String signature = this.getSubProgramName(sigStartTk, sub);
                PlSqlToken n = parser.getTokenAtOffset(sub.getEndOffset().intValue());
                PlSqlToken nMinus1 = (PlSqlToken)n.getPrevCodeToken();
                PlSqlToken nMinus2 = (PlSqlToken)nMinus1.getPrevCodeToken();
                if (nMinus2.matches("END") && nMinus1.matches(name) && n.matches(";") && sub.getParent() instanceof DBObjectPlSqlFragment) {
                    ArrayList<String> names = new ArrayList<String>();
                    names.add(signature);
                    this.buildReference(parser, (PlSqlCodeFragment)sub, names, nMinus1.getStart(), nMinus1.getEnd(), true);
                }
                PlSqlReference ref = null;
                if (fnameTk != null && search.getNamedMatchStartToken("datatype") != null) {
                    PlSqlToken startTk2 = search.getNamedMatchStartToken("datatype");
                    PlSqlToken endTk = search.getNamedMatchEndToken("datatype");
                    ref = this.findDataTypeReference(startTk2, endTk, "returnTypeReference", parser);
                }
                sub.setReturnTypeReference(ref);
            }
        }
        return true;
    }

    protected final void buildPlSqlSubProgram(PlSqlSubProgram sub, PlSqlParser parser) throws CancelledException {
        PlSqlToken startTk;
        PlSqlSearch search = sub instanceof PlSqlMethod ? new PlSqlSearch("[ { NOT FINAL | <final FINAL> |     NOT OVERRIDING | <over OVERRIDING> |     <notInst  NOT INSTANTIABLE> | INSTANTIABLE }...] <methodType {MEMBER|STATIC|CONSTRUCTOR|MAP MEMBER|ORDER MEMBER}> { PROCEDURE <pname ?> <pparams [(...)]> |   FUNCTION <fname ?> <fparams [(...)]> RETURN <datatype {SELF AS RESULT|?%}> } [EXTERNAL {NAME <extname ?> | VARIABLE NAME <extvarname ?> } ][{DETERMINISTIC|PIPELINED|RESULT_CACHE}...][ {IS|AS} LANGUAGE     { JAVA NAME <javaname ?>     | C [NAME <cname ?>] LIBRARY <clibname ?.>       [AGENT IN ({^)}...) ]       [WITH <ccontext CONTEXT>]       [PARAMETERS ({^)}...) ]     } ]") : new PlSqlSearch("{PROCEDURE <pname ?> <pparams [(...)]>|FUNCTION <fname ?> <fparams [(...)]> RETURN <datatype ?%>}");
        if (search.matches(startTk = parser.getTokenAtOffset(sub.getStartOffset().intValue()))) {
            PlSqlToken pnameTk = search.getNamedMatchStartToken("pname");
            PlSqlToken fnameTk = search.getNamedMatchStartToken("fname");
            PlSqlToken sigStartTk = pnameTk != null ? pnameTk : fnameTk;
            String name = sigStartTk.getSource(true);
            String signature = this.getSubProgramName(sigStartTk, sub);
            PlSqlToken n = parser.getTokenAtOffset(sub.getEndOffset().intValue());
            PlSqlToken nMinus1 = (PlSqlToken)n.getPrevCodeToken();
            PlSqlToken nMinus2 = (PlSqlToken)nMinus1.getPrevCodeToken();
            if (nMinus2.matches("END") && nMinus1.matches(name) && n.matches(";") && sub.getParent() instanceof DBObjectPlSqlFragment) {
                ArrayList<String> names = new ArrayList<String>();
                names.add(signature);
                this.buildReference(parser, (PlSqlCodeFragment)sub, names, nMinus1.getStart(), nMinus1.getEnd(), true);
            }
            PlSqlReference ref = null;
            if (fnameTk != null && search.getNamedMatchStartToken("datatype") != null) {
                PlSqlToken startTk2 = search.getNamedMatchStartToken("datatype");
                PlSqlToken endTk = search.getNamedMatchEndToken("datatype");
                ref = this.findDataTypeReference(startTk2, endTk, "returnTypeReference", parser);
            }
            sub.setReturnTypeReference(ref);
        }
    }

    protected final void buildPlSqlParameter(PlSqlParameter param, PlSqlParser parser) throws CancelledException {
        PlSqlSearch search = new PlSqlSearch("<param ?> [<mode {IN OUT|OUT|IN}>] [<nocopy NOCOPY>] <datatype ?%> [{DEFAULT|:=} <default ?.[(...)]>]");
        PlSqlParameter.Mode mode = PlSqlParameter.Mode.IN;
        PlSqlToken tk = parser.getTokenAtOffset(param.getStartOffset().intValue());
        if (search.matches(tk)) {
            String modeStr = search.getNamedMatch("mode");
            if (modeStr != null) {
                if (modeStr.equals("OUT")) {
                    mode = PlSqlParameter.Mode.OUT;
                } else if (modeStr.equals("IN OUT")) {
                    mode = PlSqlParameter.Mode.INOUT;
                }
            }
            param.setMode(mode);
            String defVal = search.getNamedMatch("default");
            if (defVal != null) {
                param.setDefaultValue(defVal);
            }
            param.setNoCopy(search.getNamedMatch("nocopy") != null);
            PlSqlToken startTk = search.getNamedMatchStartToken("datatype");
            PlSqlToken endTk = search.getNamedMatchEndToken("datatype");
            PlSqlReference ref = this.findDataTypeReference(startTk, endTk, "dataTypeReference", parser);
            param.setDataTypeReference(ref);
        }
    }

    protected final PlSqlToken buildReferences(PlSqlToken startToken, PlSqlToken endToken, DBObjectPlSqlFragment dboFrag, PlSqlParser parser) throws CancelledException {
        DBObjectPlSqlFragment f;
        for (f = dboFrag; f != null && !(f instanceof PlSqlCodeFragment); f = f.getParent()) {
        }
        PlSqlCodeFragment codeFrag = (PlSqlCodeFragment)f;
        PlSqlToken tk = startToken;
        PlSqlToken endTk = endToken;
        if (endTk.matches(";")) {
            endTk = (PlSqlToken)endTk.getPrevCodeToken();
        }
        if (tk.matches("select")) {
            if (((PlSqlToken)startToken.getPrevCodeToken()).matches(LPAREN)) {
                endTk = startToken;
                int parens = 1;
                while (parens > 0) {
                    if (endTk.matches(LPAREN)) {
                        ++parens;
                    } else if (endTk.matches(RPAREN)) {
                        --parens;
                    }
                    endTk = (PlSqlToken)endTk.getNextCodeToken();
                }
                endTk = (PlSqlToken)endTk.getPrevCodeToken();
                endTk = (PlSqlToken)endTk.getPrevCodeToken();
            } else {
                PlSqlSearch intoSearch = new PlSqlSearch("select {^{into|from}}... into <intoClause {^from}...>");
                if (intoSearch.matches(startToken, endToken)) {
                    PlSqlToken intoStartTK = intoSearch.getNamedMatchStartToken("intoClause");
                    PlSqlToken intoEndTK = intoSearch.getNamedMatchEndToken("intoClause");
                    PlSqlToken intoItemStart = intoStartTK;
                    while (intoItemStart.isCode() && intoItemStart.getStart() < intoEndTK.getEnd()) {
                        intoItemStart = this.buildReferences(intoItemStart, intoEndTK, dboFrag, parser);
                        intoItemStart = (PlSqlToken)intoItemStart.getNextCodeToken();
                    }
                }
            }
            tk = this.buildReferencesInSQL(tk, endTk, codeFrag, parser);
        } else if (tk.matches("insert")) {
            tk = this.buildReferencesInSQL(tk, endTk, codeFrag, parser);
        } else if (tk.matches("update")) {
            tk = this.buildReferencesInSQL(tk, endTk, codeFrag, parser);
        } else if (tk.matches("delete")) {
            tk = this.buildReferencesInSQL(tk, endTk, codeFrag, parser);
        } else {
            if (tk.getType() != Token.Type.ALPHANUMERIC && tk.getType() != Token.Type.DOUBLE_QUOTED_STRING && !tk.matches(":")) {
                return (PlSqlToken)tk.getNextCodeToken();
            }
            if (((PlSqlToken)tk.getNextCodeToken()).matches("=>")) {
                return (PlSqlToken)tk.getNextCodeToken(2);
            }
            ArrayList<PlSqlToken> tokens = new ArrayList<PlSqlToken>();
            ArrayList<String> names = new ArrayList<String>();
            tk = this.buildNameAndTokenLists(tk, endToken, true, tokens, names, parser);
            if (names.size() > 0 && codeFrag != null) {
                int end = tokens.size() - 1;
                boolean addNames = false;
                if (((String)names.get(names.size() - 1)).startsWith(LPAREN)) {
                    end = names.size() - 2;
                    addNames = true;
                }
                this.buildReference(parser, codeFrag, names, ((PlSqlToken)tokens.get(0)).getStart(), ((PlSqlToken)tokens.get(end)).getEnd());
                if (addNames) {
                    for (int i = end + 1; i < tokens.size(); ++i) {
                        if (tokens.get(i) == null) continue;
                        ArrayList<String> names2 = new ArrayList<String>();
                        names2.addAll(names);
                        names2.add(((PlSqlToken)tokens.get(i)).getSource(true));
                        this.buildReference(parser, codeFrag, names2, ((PlSqlToken)tokens.get(i)).getStart(), ((PlSqlToken)tokens.get(i)).getEnd());
                    }
                }
            }
        }
        return tk;
    }

    private PlSqlToken buildReferencesInSQL(PlSqlToken startToken, PlSqlToken endToken, PlSqlCodeFragment stmt, PlSqlParser parser) throws CancelledException {
        for (SqlAliasExpander.Usage u : this.m_sqlAliasExpander.getUsages(startToken, endToken)) {
            List names = u.getTokens();
            if (names.size() > 0 && parser.getRoot() instanceof Trigger) {
                PlSqlToken tk = (PlSqlToken)startToken.getTokenAt(u.getStartOffset());
                tk = (PlSqlToken)tk.getPrevCodeToken();
                while (tk.matches(".")) {
                    tk = (PlSqlToken)tk.getPrevCodeToken();
                    tk = (PlSqlToken)tk.getPrevCodeToken();
                }
                if (this.isTriggerColonNewOrOld(tk, parser)) {
                    names.remove(0);
                    names.add(0, DBUtil.getDBObjectName((DBObjectID)((Trigger)parser.getRoot()).getBaseObjectID()));
                }
            }
            this.buildReference(parser, stmt, names, u.getStartOffset(), u.getEndOffset());
        }
        return (PlSqlToken)endToken.getNextCodeToken();
    }

    protected PlSqlToken buildNameAndTokenLists(PlSqlToken startToken, PlSqlToken endToken, boolean includeParens, List<PlSqlToken> tokens, List<String> names, PlSqlParser parser) {
        PlSqlToken tk = startToken;
        if (!tk.isCode()) {
            tk = (PlSqlToken)tk.getNextCodeToken();
        }
        String name = null;
        if (names.size() == 0 && this.isTriggerColonNewOrOld(tk, parser)) {
            tk = (PlSqlToken)tk.getNextToken();
            name = DBUtil.getDBObjectName((DBObjectID)((Trigger)parser.getRoot()).getBaseObjectID());
        } else if (tk.getType() == Token.Type.ALPHANUMERIC) {
            try {
                Float.valueOf(tk.getSource());
            }
            catch (NumberFormatException nfe) {
                name = tk.getSource(true);
            }
        } else if (tk.getType() == Token.Type.DOUBLE_QUOTED_STRING) {
            name = tk.getSource(false);
            name = name.substring(1, name.length() - 1);
        }
        if (name != null) {
            tokens.add(tk);
            names.add(name);
            tk = (PlSqlToken)tk.getNextCodeToken();
            if (tk.getStart() <= endToken.getEnd()) {
                if (tk.matches(".")) {
                    tk = (PlSqlToken)tk.getNextCodeToken();
                    tk = this.buildNameAndTokenLists(tk, endToken, includeParens, tokens, names, parser);
                } else if (tk.matches(LPAREN) && includeParens) {
                    String sep = LPAREN;
                    StringBuilder sb = new StringBuilder();
                    int parens = 1;
                    PlSqlToken tk2 = (PlSqlToken)tk.getNextCodeToken();
                    if (tk2.matches(RPAREN)) {
                        --parens;
                    }
                    boolean newArg = true;
                    while (parens > 0) {
                        if (parens == 1 && newArg) {
                            sb.append(sep);
                            sep = ",";
                            if (((PlSqlToken)tk2.getNextCodeToken()).matches("=>")) {
                                sb.append(tk2.getSource(true));
                                tokens.add(tk2);
                                tk2 = (PlSqlToken)tk2.getNextCodeToken(2);
                            } else {
                                sb.append("?");
                                tokens.add(null);
                            }
                            newArg = tk2.matches(",");
                        } else if (parens == 1 && tk2.matches(",")) {
                            newArg = true;
                        } else if (tk2.matches(LPAREN)) {
                            ++parens;
                        }
                        if (tk2.matches(RPAREN) && --parens == 0) {
                            sb.append(RPAREN);
                            names.add(sb.toString());
                        }
                        if (!(tk2 = (PlSqlToken)tk2.getNextCodeToken()).isEndMarker() && tk2.getStart() <= endToken.getEnd()) continue;
                        if (parens > 0) {
                            sb.append(RPAREN);
                            names.add(sb.toString());
                        }
                        break;
                    }
                }
            }
        } else {
            tk = (PlSqlToken)tk.getNextCodeToken();
        }
        return tk;
    }

    private PlSqlToken getNameToken(PlSqlParser parser, DBObjectPlSqlFragment dboFrag) throws CancelledException {
        PlSqlToken ret = null;
        if (dboFrag != null && !(dboFrag instanceof PlSqlComment) && !(dboFrag instanceof PlSqlReference)) {
            String type = dboFrag.getType();
            PlSqlToken firstTk = parser.getTokenAtOffset(dboFrag.getStartOffset().intValue());
            if (dboFrag instanceof PlSqlSubProgram || dboFrag instanceof PlSqlDatatype) {
                ret = (PlSqlToken)firstTk.getNextCodeToken();
            } else if ("STATEMENT".equals(type) || "BLOCK".equals(type)) {
                PlSqlToken t1 = (PlSqlToken)firstTk.getPrevCodeToken();
                PlSqlToken t2 = null;
                if (t1.matches(">>") && (t1 = (PlSqlToken)(t2 = (PlSqlToken)t1.getPrevCodeToken()).getPrevCodeToken()).matches("<<")) {
                    ret = t2;
                }
            } else {
                ret = firstTk;
            }
        }
        return ret;
    }

    private boolean isTriggerColonNewOrOld(PlSqlToken tk, PlSqlParser parser) {
        PlSqlSourceObject root = parser.getRoot();
        if (tk.matches(":") && root instanceof Trigger) {
            PlSqlToken nextTk;
            String oldAs;
            String newAs = ((Trigger)root).getReferencingNewAs();
            if (!ModelUtil.hasLength((String)newAs)) {
                newAs = "NEW";
            }
            if (!ModelUtil.hasLength((String)(oldAs = ((Trigger)root).getReferencingOldAs()))) {
                oldAs = "OLD";
            }
            if ((nextTk = (PlSqlToken)tk.getNextCodeToken()) != null && (nextTk.matches(newAs) || nextTk.matches(oldAs))) {
                return true;
            }
        }
        return false;
    }

    protected String getSubProgramName(PlSqlToken nameTk, PlSqlSubProgram sub) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getProvider().getInternalName(nameTk.getSource(true)));
        if (!(sub instanceof PlSqlSourceObject)) {
            String sep = LPAREN;
            PlSqlSearch search = new PlSqlSearch("? (...)");
            if (search.matches(nameTk)) {
                int end = search.getEndToken().getStart();
                int parens = 0;
                boolean inDatatype = false;
                PlSqlToken tk = (PlSqlToken)nameTk.getNextCodeToken();
                while (tk.getStart() < end) {
                    if (tk.matches(sep) && parens == 0) {
                        sb.append(sep);
                        tk = (PlSqlToken)tk.getNextCodeToken();
                        sb.append(this.getProvider().getInternalName(tk.getSource(true)));
                        if (((PlSqlToken)tk.getNextCodeToken()).matches("IN")) {
                            tk = (PlSqlToken)tk.getNextCodeToken();
                        }
                        if (((PlSqlToken)tk.getNextCodeToken()).matches("OUT")) {
                            tk = (PlSqlToken)tk.getNextCodeToken();
                        }
                        if (((PlSqlToken)tk.getNextCodeToken()).matches("NOCOPY")) {
                            tk = (PlSqlToken)tk.getNextCodeToken();
                        }
                        inDatatype = true;
                        sep = ",";
                    } else if (inDatatype) {
                        if (tk.matches("DEFAULT") || tk.matches(":=")) {
                            inDatatype = false;
                        } else {
                            if (tk.matches(LPAREN)) {
                                ++parens;
                            } else if (tk.matches(RPAREN)) {
                                --parens;
                            }
                            if (tk.getType() != Token.Type.PUNCTUATION) {
                                sb.append(" ");
                            }
                            sb.append(this.getProvider().getInternalName(tk.getSource(true)));
                        }
                    }
                    tk = (PlSqlToken)tk.getNextCodeToken();
                }
                sb.append(RPAREN);
            }
        }
        return sb.toString();
    }

    protected boolean isSourcePropertyValueEqual(T orig, T object, String sourceProp) {
        if ("source".equals(sourceProp) && !(orig instanceof PlSqlSourceObject)) {
            return orig.getStartOffset() == object.getStartOffset() && orig.getEndOffset() == object.getEndOffset();
        }
        return super.isSourcePropertyValueEqual(orig, object, sourceProp);
    }

    protected static final <T extends DBObjectPlSqlFragment> T createFragment(Class<T> clz) {
        if (SwingUtilities.isEventDispatchThread()) {
            DBLog.logIllegalState((String)"Building PL/SQL derived properties on EDT");
        }
        DBObjectPlSqlFragment ret = null;
        try {
            ret = (DBObjectPlSqlFragment)clz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return (T)ret;
    }

    protected static final PlSqlSubProgram createPlSqlSubProgram(PlSqlSourceObject parent) {
        if (parent instanceof TypeBody) {
            return (PlSqlSubProgram)AbstractPlSqlBuilder.createFragment(PlSqlMethod.class);
        }
        return AbstractPlSqlBuilder.createFragment(PlSqlSubProgram.class);
    }
}

