/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.math.BigInteger;
import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;

public class StoragePropertiesValidator
extends AbstractChildDBObjectValidator<OracleStorageProperties> {
    public StoragePropertiesValidator(DBObjectProvider pro) {
        super(pro);
    }

    protected boolean canHaveEmptyName() {
        return true;
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection retval = super.listAlwaysValidProperties();
        retval.add("tablespaceID");
        retval.add("logging");
        return retval;
    }

    @DBObjectValidator.PropertyValidator(value={"percentFree"}, level=ValidationLevel.FULL)
    @DBObjectValidator.PropertyDependency(value={"percentUsed"})
    public void validatePercentFree(OracleStorageProperties original, OracleStorageProperties updated) throws ValidationException {
        Integer pctFree = updated.getPercentFree();
        if (pctFree != null && (pctFree < 0 || pctFree > 99)) {
            throw new ValidationException((DBObject)updated, APIBundle.format((String)"STORAGE_PROPERTY_ERROR_INVALID_RANGE_VALUE", (Object[])new Object[]{"PCTFREE", 0, 99}));
        }
        this.validateSumOfPctFreeAndPctUsed(updated);
        this.validateNonNullableProperty((DBObject)original, (DBObject)updated, "percentFree");
    }

    @DBObjectValidator.PropertyValidator(value={"percentUsed"}, level=ValidationLevel.FULL)
    @DBObjectValidator.PropertyDependency(value={"percentFree"})
    public void validatePercentUsed(OracleStorageProperties original, OracleStorageProperties updated) throws ValidationException {
        Integer pctUsed = updated.getPercentUsed();
        if (pctUsed != null && (pctUsed < 0 || pctUsed > 99)) {
            throw new ValidationException((DBObject)updated, APIBundle.format((String)"STORAGE_PROPERTY_ERROR_INVALID_RANGE_VALUE", (Object[])new Object[]{"PCTUSED", 0, 99}));
        }
        this.validateSumOfPctFreeAndPctUsed(updated);
        this.validateNonNullableProperty((DBObject)original, (DBObject)updated, "percentUsed");
    }

    @DBObjectValidator.PropertyValidator(value={"initrans"}, level=ValidationLevel.FULL)
    public void validateInitrans(OracleStorageProperties original, OracleStorageProperties updated) throws ValidationException {
        Integer initrans = updated.getInitrans();
        if (initrans != null && (initrans < 1 || initrans > 255)) {
            throw new ValidationException((DBObject)updated, APIBundle.format((String)"STORAGE_PROPERTY_ERROR_INVALID_RANGE_VALUE", (Object[])new Object[]{"INITRANS", 1, 255}));
        }
        this.validateNonNullableProperty((DBObject)original, (DBObject)updated, "initrans");
    }

    @DBObjectValidator.PropertyValidator(value={"maxtrans"}, level=ValidationLevel.FULL)
    public void validateMaxtrans(OracleStorageProperties original, OracleStorageProperties updated) throws ValidationException {
        Integer maxtrans = updated.getMaxtrans();
        if (maxtrans != null && (maxtrans < 1 || maxtrans > 255)) {
            throw new ValidationException((DBObject)updated, APIBundle.format((String)"STORAGE_PROPERTY_ERROR_INVALID_RANGE_VALUE", (Object[])new Object[]{"MAXTRANS", 1, 255}));
        }
        this.validateNonNullableProperty((DBObject)original, (DBObject)updated, "maxtrans");
    }

    @DBObjectValidator.PropertyValidator(value={"initialExtent"}, level=ValidationLevel.FULL)
    public void validateInitialExtent(OracleStorageProperties original, OracleStorageProperties updated) throws ValidationException {
        BigInteger initialExtent = updated.getInitialExtent();
        if (initialExtent != null && initialExtent.compareTo(BigInteger.ONE) < 0) {
            throw new ValidationException((DBObject)updated, APIBundle.format((String)"STORAGE_PROPERTY_ERROR_TOO_SMALL", (Object[])new Object[]{"INITIAL", 1}));
        }
        this.validateNonNullableProperty((DBObject)original, (DBObject)updated, "initialExtent");
    }

    @DBObjectValidator.PropertyValidator(value={"nextExtent"}, level=ValidationLevel.FULL)
    public void validateNextExtent(OracleStorageProperties original, OracleStorageProperties updated) throws ValidationException {
        BigInteger nextExtent = updated.getNextExtent();
        if (nextExtent != null && nextExtent.compareTo(BigInteger.ONE) < 0) {
            throw new ValidationException((DBObject)updated, APIBundle.format((String)"STORAGE_PROPERTY_ERROR_TOO_SMALL", (Object[])new Object[]{"NEXT", 1}));
        }
        this.validateNonNullableProperty((DBObject)original, (DBObject)updated, "nextExtent");
    }

    @DBObjectValidator.PropertyValidator(value={"minExtent"}, level=ValidationLevel.FULL)
    public void validateMinExtent(OracleStorageProperties original, OracleStorageProperties updated) throws ValidationException {
        BigInteger minExtent = updated.getMinExtent();
        if (minExtent != null && minExtent.compareTo(BigInteger.ONE) < 0) {
            throw new ValidationException((DBObject)updated, APIBundle.format((String)"STORAGE_PROPERTY_ERROR_TOO_SMALL", (Object[])new Object[]{"MINEXTENT", 1}));
        }
        this.validateNonNullableProperty((DBObject)original, (DBObject)updated, "minExtent");
    }

    @DBObjectValidator.PropertyValidator(value={"maxExtent"}, level=ValidationLevel.FULL)
    public void validateMaxExtent(OracleStorageProperties original, OracleStorageProperties updated) throws ValidationException {
        BigInteger maxExtent = updated.getMaxExtent();
        if (maxExtent != null && maxExtent.compareTo(BigInteger.ZERO) < 0) {
            throw new ValidationException((DBObject)updated, APIBundle.format((String)"STORAGE_PROPERTY_ERROR_TOO_SMALL", (Object[])new Object[]{"MAXEXTENT", 0}));
        }
        this.validateNonNullableProperty((DBObject)original, (DBObject)updated, "maxExtent");
    }

    @DBObjectValidator.PropertyValidator(value={"percentIncrease"}, level=ValidationLevel.FULL)
    public void validatePercentIncrease(OracleStorageProperties original, OracleStorageProperties updated) throws ValidationException {
        Integer pctIncrease = updated.getPercentIncrease();
        if (pctIncrease != null && pctIncrease < 0) {
            throw new ValidationException((DBObject)updated, APIBundle.format((String)"STORAGE_PROPERTY_ERROR_TOO_SMALL", (Object[])new Object[]{"PCTINCREASE", 0}));
        }
        this.validateNonNullableProperty((DBObject)original, (DBObject)updated, "percentIncrease");
    }

    @DBObjectValidator.PropertyValidator(value={"freelistGroups"}, level=ValidationLevel.FULL)
    public void validateFreelistGroups(OracleStorageProperties original, OracleStorageProperties updated) throws ValidationException {
        Integer freelistGroups = updated.getFreelistGroups();
        if (freelistGroups != null && freelistGroups < 1) {
            throw new ValidationException((DBObject)updated, APIBundle.format((String)"STORAGE_PROPERTY_ERROR_TOO_SMALL", (Object[])new Object[]{"FREELIST_GROUPS", 1}));
        }
        this.validateNonNullableProperty((DBObject)original, (DBObject)updated, "freelistGroups");
    }

    @DBObjectValidator.PropertyValidator(value={"freelists"}, level=ValidationLevel.FULL)
    public void validateFreelists(OracleStorageProperties original, OracleStorageProperties updated) throws ValidationException {
        Integer freelists = updated.getFreelists();
        if (freelists != null && freelists < 1) {
            throw new ValidationException((DBObject)updated, APIBundle.format((String)"STORAGE_PROPERTY_ERROR_TOO_SMALL", (Object[])new Object[]{"FREELISTS", 1}));
        }
        this.validateNonNullableProperty((DBObject)original, (DBObject)updated, "freelists");
    }

    @DBObjectValidator.PropertyValidator(value={"bufferMode"}, level=ValidationLevel.FULL)
    public void validateBufferMode(OracleStorageProperties original, OracleStorageProperties updated) throws ValidationException {
    }

    private void validateSumOfPctFreeAndPctUsed(OracleStorageProperties props) throws ValidationException {
        Integer pctFree = props.getPercentFree();
        Integer pctUsed = props.getPercentUsed();
        if (pctFree != null && pctUsed != null && pctFree + pctUsed > 100) {
            throw new ValidationException((DBObject)props, APIBundle.get((String)"STORAGE_PROPERTY_ERROR_PCTFREE_PCTUSED_INVALID_VALUE"));
        }
    }
}

