/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ora.OracleNumberDataType;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.DataTypeUsageValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.util.ModelUtil;

public class OracleDataTypeUsageValidator
extends DataTypeUsageValidator {
    public OracleDataTypeUsageValidator(DBObjectProvider dbObjectProvider) {
        super(dbObjectProvider);
    }

    @Override
    protected void validateAttributeUsage(DataTypeAttribute attribute, Object attributeValue, DataType dataType, DataTypeUsage dataTypeUsage) throws ValidationException {
        if (DataTypeHelper.isTypeOf((DataType)dataType, OracleNumberDataType.class)) {
            Long scale;
            if ("precision".equals(attribute.getName())) {
                String precision = DataTypeHelper.toString((Object)attributeValue);
                if (ModelUtil.hasLength((String)precision) && !precision.trim().equals("*")) {
                    int value = 0;
                    try {
                        value = Long.valueOf(precision).intValue();
                    }
                    catch (NumberFormatException x) {
                        this.throwAttributeValueInvalid(dataTypeUsage, attribute, APIBundle.get((String)"DATATYPE_ERROR_INVALID_ORACLE_PRECISION"));
                    }
                    if (value < 1) {
                        this.throwAttributeValueInvalid(dataTypeUsage, attribute, APIBundle.format((String)"DATATYPE_ERROR_INVALID_NUMERIC_VALUE1", (Object[])new Object[]{APIBundle.get((String)"DATATYPE_ATTRIBUTE_LABEL_PRECISION"), 1}));
                    }
                    if (value > 38) {
                        this.throwAttributeValueInvalid(dataTypeUsage, attribute, APIBundle.format((String)"DATATYPE_ERROR_INVALID_NUMERIC_VALUE2", (Object[])new Object[]{APIBundle.get((String)"DATATYPE_ATTRIBUTE_LABEL_PRECISION"), 38}));
                    }
                }
            } else if ("scale".equals(attribute.getName()) && (scale = DataTypeHelper.toLong((Object)attributeValue)) != null) {
                if (scale.compareTo(-84L) < 0) {
                    this.throwAttributeValueInvalid(dataTypeUsage, attribute, APIBundle.format((String)"DATATYPE_ERROR_INVALID_NUMERIC_VALUE1", (Object[])new Object[]{APIBundle.get((String)"DATATYPE_ATTRIBUTE_LABEL_SCALE"), -84}));
                }
                if (scale.compareTo(127L) > 0) {
                    this.throwAttributeValueInvalid(dataTypeUsage, attribute, APIBundle.format((String)"DATATYPE_ERROR_INVALID_NUMERIC_VALUE2", (Object[])new Object[]{APIBundle.get((String)"DATATYPE_ATTRIBUTE_LABEL_SCALE"), 127}));
                }
            }
        } else {
            super.validateAttributeUsage(attribute, attributeValue, dataType, dataTypeUsage);
        }
    }
}

