/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.lang.reflect.Field;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnSequenceProcessor;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.IdentityColumnProperties;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.datatypes.DataTypeSynonym;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.ora.Oracle12c;
import oracle.javatools.db.ora.Oracle9i;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.OracleNumberDataType;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.validators.ColumnValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;
import oracle.sql.CharacterSet;

public class OracleColumnValidator
extends ColumnValidator {
    public OracleColumnValidator(DBObjectProvider prov) {
        super(prov, true);
    }

    protected void validateName(Column obj) throws InvalidNameException {
        super.validateName((DBObject)obj);
        String name = obj.getName();
        if (name.equals("ROWID")) {
            throw new InvalidNameException((DBObject)obj, APIBundle.format((String)"DBOV_INVALID_NAME", (Object[])new Object[]{name, APIBundle.format((String)"INVALID_IDENTIFIER_RESERVED_WORD", (Object[])new Object[]{name})}));
        }
    }

    @Override
    @DBObjectValidator.PropertyValidator(value={"dataTypeUsage"}, level=ValidationLevel.FULL)
    public void validateDataTypeUsage(Column original, Column column) throws ValidationException {
        DataTypeUsage dtu;
        boolean validateDTU = true;
        if (column.getVirtualExpressionSource() != null && ((dtu = column.getDataTypeUsage()) == null || dtu.getDataTypeID() == null)) {
            validateDTU = false;
        }
        if (validateDTU) {
            super.validateDataTypeUsage(original, column);
        }
    }

    @Override
    protected void validateDataTypeUsage(Column column, DataTypeUsage dtu, DBObjectID dataTypeID, DataType dataType) throws ValidationException {
        super.validateDataTypeUsage(column, dtu, dataTypeID, dataType);
        if (!this.isViewColumn(column)) {
            String dataTypeName = dataType instanceof DataTypeSynonym ? ((DataTypeSynonym)dataType).getBaseType().getName() : (dataType != null ? dataType.getName() : DBUtil.getDBObjectName((DBObjectID)dataTypeID));
            boolean complex = dataType instanceof Type || dataTypeID instanceof ReferenceID;
            Table.TableType tableType = (Table.TableType)column.getRelation().getProperty("TableType");
            if (tableType == Table.TableType.EXTERNAL && (complex || dataTypeName.startsWith("LONG"))) {
                throw new ValidationException((DBObject)column, APIBundle.get((String)"EXTERNAL_TABLE_PROPERTY_INVALID_COLUMN"));
            }
            if (dataTypeName.startsWith("LONG")) {
                Column[] columns = column.getRelation().getColumns();
                for (int i = 0; i < columns.length; ++i) {
                    DBObjectID otherDataTypeID;
                    if (columns[i] == column) continue;
                    DataTypeUsage otherDTU = columns[i].getDataTypeUsage();
                    DBObjectID dBObjectID = otherDataTypeID = otherDTU == null ? null : otherDTU.getDataTypeID();
                    if (!(otherDataTypeID instanceof DataTypeID)) continue;
                    DataType otherDataType = null;
                    try {
                        otherDataType = (DataType)otherDataTypeID.resolveID();
                        if (otherDataType != null && otherDataType.getName().startsWith("LONG")) {
                            throw new ValidationException((DBObject)column, APIBundle.format((String)"COLUMN_ERROR_TOO_MANY_LONGS", (Object[])new Object[]{columns[i].getName()}));
                        }
                        continue;
                    }
                    catch (DBException dbe) {
                        this.logException(dbe, Level.FINE);
                    }
                }
            }
            if (column.getVirtualExpressionSource() != null) {
                boolean ok = true;
                if ("CLOB".equals(dataTypeName) || "BLOB".equals(dataTypeName) || "NCLOB".equals(dataTypeName) || "BFILE".equals(dataTypeName) || "CLOB".equals(dataTypeName)) {
                    ok = false;
                } else if (complex) {
                    ok = false;
                    String schemaName = null;
                    if (dataType instanceof Type) {
                        Schema schema = ((Type)dataType).getSchema();
                        schemaName = schema == null ? null : schema.getName();
                    } else if (dataTypeID instanceof BaseObjectID) {
                        schemaName = ((BaseObjectID)dataTypeID).getSchemaName();
                    }
                    if ("XMLTYPE".equals(dataTypeName) && ("SYS".equals(schemaName) || "PUBLIC".equals(schemaName))) {
                        ok = true;
                    }
                }
                if (!ok) {
                    throw new ValidationException((DBObject)column, "dataTypeUsage", APIBundle.get((String)"VIRTUAL_COLUMN_INVALID_DATATYPE"));
                }
            }
        }
    }

    @Override
    protected void validateBinaryDefaultValue(String defaultValue, Column column, DataTypeUsage dataTypeUsage, DataType dataType) throws ValidationException {
        if ("RAW".equals(dataType.getName())) {
            SQLFragment frag = this.parseDefaultValue(defaultValue, column);
            String hexstr = ParserUtils.getHexToRawString((SQLFragment)frag);
            if (hexstr == null) {
                hexstr = ParserUtils.getString((SQLFragment)frag);
            }
            if (hexstr != null) {
                int defaultValueLength;
                hexstr = hexstr.replace('\'', ' ').trim();
                try {
                    BigInteger bigInteger = new BigInteger(hexstr, 16);
                }
                catch (NumberFormatException ne) {
                    throw new ValidationException((DBObject)column, APIBundle.format((String)"DEFAULT_VALUE_ERROR_INVALID_HEX", (Object[])new Object[]{hexstr}));
                }
                DataTypeAttribute size = dataType.getDataTypeAttribute("size");
                Long dataTypeSize = size.isDeclarable() ? DataTypeHelper.getLongAttributeValue((DataTypeUsage)column.getDataTypeUsage(), (String)"size") : size.getMaxValue();
                if (dataTypeSize == null) {
                    dataTypeSize = (Long)size.getDefaultValue();
                }
                if (dataTypeSize != null && (long)(defaultValueLength = hexstr.length()) > dataTypeSize * 2L) {
                    throw new ValidationException((DBObject)column, APIBundle.format((String)"DEFAULT_VALUE_ERROR_HEX_TOO_LARGE", (Object[])new Object[]{new Long(defaultValueLength), dataTypeSize}));
                }
            }
        } else {
            super.validateBinaryDefaultValue(defaultValue, column, dataTypeUsage, dataType);
        }
    }

    @Override
    protected void validateDefaultValue(String defaultValue, Column column, DataTypeUsage dataTypeUsage, DataType dataType) throws ValidationException {
        if (DataTypeHelper.isTypeOf((DataType)dataType, OracleNumberDataType.class)) {
            String precision = DataTypeHelper.getStringAttributeValue((DataTypeUsage)dataTypeUsage, (String)"precision");
            Long scale = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"scale");
            dataTypeUsage = (DataTypeUsage)DBUtil.makeClonedCopy((DBObject)dataTypeUsage);
            if (precision != null) {
                if (precision.trim().equals("*")) {
                    if (scale != null) {
                        dataTypeUsage.putAttributeValue("precision", (Object)38L);
                    } else {
                        dataTypeUsage.deleteAttributeValue("precision");
                    }
                }
            } else if (scale != null) {
                dataTypeUsage.putAttributeValue("precision", (Object)38L);
            }
        }
        super.validateDefaultValue(defaultValue, column, dataTypeUsage, dataType);
        if (this.getProvider() instanceof Oracle9i) {
            String dataTypeName = dataType.getName();
            Oracle9i db = (Oracle9i)this.getProvider();
            if (defaultValue.charAt(0) == '\'') {
                defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
                String charSetName = "NCHAR".equals(dataTypeName) || "NVARCHAR2".equals(dataTypeName) || "NCLOB".equals(dataTypeName) ? db.getSessionParameterValue("NLS_NCHAR_CHARACTERSET") : db.getSessionParameterValue("NLS_CHARACTERSET");
                CharacterSet charSet = null;
                try {
                    Field field = CharacterSet.class.getDeclaredField(charSetName + "_CHARSET");
                    charSet = CharacterSet.make((int)field.getInt(null));
                }
                catch (Throwable t) {
                    this.getLogger().fine("Couldn't make charset " + charSetName);
                }
                if (charSet != null && !charSet.isUnknown()) {
                    byte[] bytes;
                    try {
                        bytes = charSet.convert(defaultValue);
                    }
                    catch (SQLException sqe) {
                        throw new ValidationException((DBObject)column, APIBundle.format((String)"DEFAULT_VALUE_NOT_ENCODABLE", (Object[])new Object[]{defaultValue, charSetName}));
                    }
                    catch (Throwable t) {
                        this.getLogger().log(DBLog.getExceptionLogLevel(), "Error using CharacterSet.convert for " + charSetName, t);
                        bytes = null;
                    }
                    if (bytes != null) {
                        String unit = (String)dataTypeUsage.getAttributeValue("unit");
                        if (("CHAR".equals(dataTypeName) || "VARCHAR2".equals(dataTypeName)) && ("BYTE".equals(unit) || unit == null && "BYTE".equals(db.getSessionParameterValue("NLS_LENGTH_SEMANTICS")))) {
                            Long dataTypeSize = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"size");
                            if (dataTypeSize == null) {
                                DataTypeAttribute sizeAttr = dataType.getDataTypeAttribute("size");
                                Long l = dataTypeSize = sizeAttr != null ? (Long)sizeAttr.getDefaultValue() : null;
                            }
                            if (dataTypeSize != null && (long)bytes.length > dataTypeSize) {
                                throw new ValidationException((DBObject)column, APIBundle.format((String)"DEFAULT_VALUE_ERROR_LENGTH_TOO_LARGE", (Object[])new Object[]{new Long(bytes.length), dataTypeSize}));
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    protected void validateVirtualExpressionFragment(Column updated, SQLFragment frag) throws ValidationException {
        super.validateVirtualExpressionFragment(updated, frag);
        if (updated.getParent().getProperty("TableType") != Table.TableType.NORMAL) {
            throw new ValidationException((DBObject)updated, "virtualExpressionSource", APIBundle.get((String)"VIRTUAL_COLUMN_NON_HEAP_TABLE"));
        }
        if (updated.getDefault() != null) {
            throw new ValidationException((DBObject)updated, "virtualExpressionSource", APIBundle.get((String)"VIRTUAL_COLUMN_EXPRESSION_AND_DEFAULT"));
        }
        if (updated.getIdentityProperties() != null) {
            throw new ValidationException((DBObject)updated, "virtualExpressionSource", APIBundle.format((String)"IDENTITY_COL_VIRTUAL_COL_ERROR", (Object[])new Object[]{updated.getName()}));
        }
        for (Column col : ((Relation)updated.getParent()).getColumns()) {
            String virtualExpression;
            if (col == updated || (virtualExpression = col.getVirtualExpressionSource()) == null) continue;
            if (DBUtil.findUsagesIn((DBObject)col, (DBObject)frag).size() > 0) {
                throw new ValidationException((DBObject)updated, "virtualExpressionSource", APIBundle.format((String)"VIRTUAL_COLUMN_EXPRESSION_INVALID", (Object[])new Object[]{APIBundle.get((String)"VIRTUAL_COLUMN_EXPRESSION_VIRTUAL_REFERENCE")}));
            }
            if (!virtualExpression.equals(updated.getVirtualExpressionSource())) continue;
            throw new ValidationException((DBObject)updated, "virtualExpressionSource", APIBundle.format((String)"VIRTUAL_COLUMN_EXPRESSION_INVALID", (Object[])new Object[]{APIBundle.get((String)"VIRTUAL_COLUMN_EXPRESSION_DUPLICATE")}));
        }
        if (frag instanceof ColumnUsage) {
            throw new ValidationException((DBObject)updated, "virtualExpressionSource", APIBundle.format((String)"VIRTUAL_COLUMN_EXPRESSION_INVALID", (Object[])new Object[]{APIBundle.get((String)"VIRTUAL_COLUMN_EXPRESSION_SINGLE_COLUMN")}));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"identityProperties"}, level=ValidationLevel.FULL)
    public void validateIdentityProperties(Column original, Column updated) throws ValidationException {
        IdentityColumnProperties newProps = updated != null ? updated.getIdentityProperties() : null;
        if (newProps != null) {
            if (ModelUtil.areEqual((Object)Table.TableType.EXTERNAL, (Object)updated.getRelation().getProperty("TableType"))) {
                throw new ValidationException((DBObject)updated, "identityProperties", APIBundle.get((String)"IDENTITY_COL_PROPS_TABLE_TYPE_ERROR"));
            }
            if (updated.getVirtualExpressionSource() != null) {
                throw new ValidationException((DBObject)updated, "identityProperties", APIBundle.format((String)"IDENTITY_COL_VIRTUAL_COL_ERROR", (Object[])new Object[]{updated.getName()}));
            }
            IdentityColumnProperties origProps = original != null ? original.getIdentityProperties() : null;
            if (this.getProvider() instanceof Oracle12c && original != null && origProps == null) {
                throw new ValidationException((DBObject)updated, "identityProperties", APIBundle.format((String)"IDENTITY_COL_PROPS_ON_EXISTING_COLUMN_ERROR", (Object[])new Object[]{updated.getName()}));
            }
            if (updated.getDataTypeUsage() != null) {
                DataType datatype = null;
                try {
                    datatype = DataTypeHelper.getDataType((DataTypeUsage)updated.getDataTypeUsage());
                }
                catch (DBException dbe) {
                    this.logException(dbe, Level.FINE);
                    datatype = null;
                }
                if (datatype != null && !DataTypeHelper.isNumericType((DataType)datatype)) {
                    throw new ValidationException((DBObject)updated, "identityProperties", APIBundle.format((String)"IDENTITY_COL_PROPS_ON_NON_NUMERIC_COLUMN_ERROR", (Object[])new Object[]{updated.getName()}));
                }
            }
            if (updated.getDefault() != null) {
                throw new ValidationException((DBObject)updated, "identityProperties", APIBundle.format((String)"IDENTITY_COL_PROPS_COL_HAS_DEFAULT_ERROR", (Object[])new Object[]{updated.getName()}));
            }
            for (Column c : updated.getRelation().getColumns()) {
                if (c.getIdentityProperties() == null || c == updated) continue;
                throw new ValidationException((DBObject)updated, "identityProperties", APIBundle.format((String)"IDENTITY_COL_PROPS_MORE_THAN_ONE_ERROR", (Object[])new Object[]{updated.getRelation().getName()}));
            }
            this.getProvider().validateObject((DBObject)origProps, (DBObject)newProps);
        }
    }

    @DBObjectValidator.PropertyValidator(value={"AUTO_GENERATED_SEQUENCE_TRIGGER"}, level=ValidationLevel.FULL)
    public void validateColumnSequenceTrigger(Column original, Column column) throws ValidationException {
        if (column != null) {
            DBObjectID trigId;
            Relation relation = column.getRelation();
            if (ColumnSequenceProcessor.hasColumnSequenceProps(column)) {
                if (Table.TableType.EXTERNAL.equals(relation.getProperty("TableType"))) {
                    throw new ValidationException((DBObject)column, "identityProperties", APIBundle.get((String)"COLSEQ_TABLE_TYPE_ERROR"));
                }
                if (column.getVirtualExpressionSource() != null) {
                    throw new ValidationException((DBObject)column, "identityProperties", APIBundle.format((String)"IDENTITY_COL_VIRTUAL_COL_ERROR", (Object[])new Object[]{column.getName()}));
                }
                DataTypeUsage dtu = column.getDataTypeUsage();
                if (dtu != null) {
                    DataType datatype = null;
                    String datatypeName = DataTypeHelper.getTypeStringFromUsage((DataTypeUsage)dtu, (Schema)relation.getSchema(), (DBObjectProvider)this.getProvider());
                    try {
                        datatype = DataTypeHelper.getDataType((DataTypeUsage)dtu, (boolean)false);
                        if (datatype != null) {
                            datatypeName = datatype.getName();
                        }
                    }
                    catch (DBException e) {
                        this.logException(e, Level.FINE);
                    }
                    PredefinedDataType.ValueType valueType = DataTypeHelper.getValueType((DataType)datatype);
                    if (!PredefinedDataType.ValueType.isNumericType((PredefinedDataType.ValueType)valueType) && valueType != PredefinedDataType.ValueType.CHAR) {
                        throw new ValidationException((DBObject)column, "AUTO_GENERATED_SEQUENCE_TRIGGER", APIBundle.format((String)"COLSEQ_COLUMN_DATATYPE_ERROR", (Object[])new Object[]{column.getName(), datatypeName}));
                    }
                }
            }
            if ((trigId = (DBObjectID)column.getProperty("AUTO_GENERATED_SEQUENCE_TRIGGER")) != null && !(trigId instanceof ReferenceID)) {
                Trigger trig = null;
                try {
                    trig = (Trigger)trigId.resolveID();
                }
                catch (DBException e) {
                    trig = null;
                    this.logException(e, Level.FINE);
                }
                if (trig != null) {
                    if (ModelUtil.areDifferent((Object)relation.getID(), (Object)trig.getBaseObjectID())) {
                        throw new ValidationException((DBObject)column, "AUTO_GENERATED_SEQUENCE_TRIGGER", APIBundle.format((String)"COLSEQ_TRIGGER_VALIDATION_TABLE", (Object[])new Object[]{trig.getName(), column.getName(), relation.getName()}));
                    }
                } else {
                    String triggerName = DBUtil.getDBObjectName((DBObjectID)trigId);
                    throw new ValidationException((DBObject)column, "AUTO_GENERATED_SEQUENCE_TRIGGER", APIBundle.format((String)"COLSEQ_TRIGGER_VALIDATION_TRIGGER_NOT_FOUND", (Object[])new Object[]{triggerName, column.getName()}));
                }
            }
        }
    }

    protected void validateMissingPath(Column original, Column updated, String property) throws ValidationException {
        String nestedTabNamePath = Property.createPath((String[])new String[]{"OracleColumnProperties", "nestedTableProperties", "tableName"});
        if (property.equals(nestedTabNamePath)) {
            DataType dataType = null;
            try {
                dataType = DataTypeHelper.getDataType((DataTypeUsage)updated.getDataTypeUsage(), (boolean)false);
            }
            catch (DBException dbe) {
                this.logException(dbe, Level.FINE);
            }
            if (DataTypeHelper.isTableType((DataType)dataType)) {
                throw new ValidationException((DBObject)updated, nestedTabNamePath, APIBundle.get((String)"NESTED_TABLE_PROPS_TABLE_NAME_MISSING_ERROR"));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"OracleColumnProperties"}, level=ValidationLevel.FULL)
    public void validateOracleColumnProperties(Column orig, Column upd) throws ValidationException {
        OracleColumnProperties ocp = (OracleColumnProperties)upd.getProperty("OracleColumnProperties");
        if (ocp != null) {
            boolean isTemp;
            Relation rel = upd.getRelation();
            Table.TableType tableType = rel instanceof Table ? (Table.TableType)rel.getProperty("TableType") : null;
            boolean bl = isTemp = tableType == Table.TableType.SESSION_TEMP || tableType == Table.TableType.TRANSACTION_TEMP;
            if (ocp.getVAProperties() != null || ocp.getLOBProperties() != null) {
                if (isTemp) {
                    throw new ValidationException((DBObject)upd, APIBundle.format((String)"TABLE_PROPERTY_ERROR_INVALID_PROPERTY", (Object[])new Object[]{APIBundle.get((String)"TABLE_TYPE_TEMPORARY"), APIBundle.get((String)"TABLE_PROPERTY_LOB_PARAMETERS")}));
                }
                if (tableType == Table.TableType.EXTERNAL) {
                    throw new ValidationException((DBObject)upd, "OracleColumnProperties", APIBundle.format((String)"TABLE_PROPERTY_ERROR_INVALID_PROPERTY", (Object[])new Object[]{APIBundle.get((String)"TABLE_TYPE_EXTERNAL"), APIBundle.get((String)"TABLE_PROPERTY_LOB_PARAMETERS")}));
                }
            }
            if (ocp.getNestedTableProperties() != null && isTemp) {
                throw new ValidationException((DBObject)upd, APIBundle.format((String)"TABLE_PROPERTY_ERROR_INVALID_PROPERTY", (Object[])new Object[]{APIBundle.get((String)"TABLE_TYPE_TEMPORARY"), APIBundle.get((String)"TABLE_PROPERTY_NESTED_TABLES")}));
            }
            this.validateOwnedObjects(ValidationLevel.FULL, new DBObject[]{ocp});
        }
    }
}

